/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tag;

import com.gentics.mesh.core.data.dao.LanguageDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.NONE, testSize=TestSize.PROJECT, startServer=false)
public class AtomicTagTest
extends AbstractMeshTest {
    @Test
    public void testTagCreation() throws Exception {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            TagDao tagDao = tx.tagDao();
            HibUser user = userDao.create("test", null);
            LanguageDao languageRoot = tx.languageDao();
            Assert.assertNotNull((Object)languageRoot);
            HibProject project = this.project();
            HibTagFamily tagFamily = tx.tagFamilyDao().create(project, "basic", user);
            HibTag tag = tagDao.create(tagFamily, "dummyName", project, user);
            String uuid = tag.getUuid();
            Assert.assertNotNull((Object)tag);
            Assert.assertEquals((Object)"dummyName", (Object)tag.getName());
            tag.setName("renamed tag");
            Assert.assertEquals((Object)"renamed tag", (Object)tag.getName());
            HibTag reloadedTag = (HibTag)tx.tagDao().findByUuid(uuid);
            Assert.assertNotNull((Object)reloadedTag);
            Assert.assertEquals((Object)"renamed tag", (Object)reloadedTag.getName());
        }
    }
}

