/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tag;

import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class TagEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String tagFamilyUuid = this.tagFamily("colors").getUuid();
            String etag = ClientHelper.callETag(() -> this.client().findTags("dummy", tagFamilyUuid, new ParameterProvider[0]));
            ClientHelper.callETag(() -> this.client().findTags("dummy", tagFamilyUuid, new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findTags("dummy", tagFamilyUuid, new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadOne() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTagFamily tagfamily = this.tagFamily("colors");
            HibTag tag = this.tag("red");
            String actualEtag = ClientHelper.callETag(() -> this.client().findTagByUuid("dummy", tagfamily.getUuid(), tag.getUuid(), new ParameterProvider[0]));
            String etag = tagDao.getETag((HibTransformableElement)tag, this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)actualEtag);
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findTagByUuid("dummy", tagfamily.getUuid(), tag.getUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304));
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findTagByUuid("dummy", tagfamily.getUuid(), tag.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304));
            ClientHelper.callETag(() -> this.client().findTagByUuid("dummy", tagfamily.getUuid(), tag.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findTagByUuid("dummy", tagfamily.getUuid(), tag.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304);
        }
    }
}

