/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tag;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.PermissionInfoAssert;
import com.gentics.mesh.assertj.impl.TagMeshEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.node.NodeTaggedEventModel;
import com.gentics.mesh.core.rest.event.tag.TagMeshEventModel;
import com.gentics.mesh.core.rest.tag.TagCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyListResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.core.rest.tag.TagUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class TagEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    @Test
    public void testReadMultiple() throws Exception {
        int nBasicTags = 9;
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily basicTagFamily = this.tagFamily("basic");
            HibTag noPermTag = tagDao.create(basicTagFamily, "noPermTag", this.project(), this.user());
            String noPermTagUUID = noPermTag.getUuid();
            tagFamilyDao.addTag(basicTagFamily, noPermTag);
            Assert.assertNotNull((Object)noPermTag.getUuid());
            ListResponse restResponse = (ListResponse)ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[0]));
            Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
            Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
            Assert.assertEquals((String)"The response did not contain the correct amount of items. We only have nine basic tags in the test data.", (long)9L, (long)restResponse.getData().size());
            long perPage = 4L;
            int totalTags = 9;
            int totalPages = (int)Math.ceil((double)totalTags / 4.0);
            ArrayList allTags = new ArrayList();
            for (int page = 1; page <= totalPages; ++page) {
                int currentPage = page;
                TagListResponse tagPage = (TagListResponse)ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[]{new PagingParametersImpl(currentPage, Long.valueOf(4L))}));
                restResponse = tagPage;
                long expectedItemsCount = 4L;
                if (page == 3) {
                    expectedItemsCount = 1L;
                }
                Assert.assertEquals((String)("The expected item count for page {" + page + "} does not match"), (long)expectedItemsCount, (long)restResponse.getData().size());
                Assert.assertEquals((long)4L, (long)restResponse.getMetainfo().getPerPage());
                Assert.assertEquals((String)("We requested page {" + page + "} but got a metainfo with a different page back."), (long)page, (long)restResponse.getMetainfo().getCurrentPage());
                Assert.assertEquals((String)("The amount of total pages did not match the expected value. There are {" + totalTags + "} tags and {4} tags per page"), (long)totalPages, (long)restResponse.getMetainfo().getPageCount());
                Assert.assertEquals((String)"The total tag count does not match.", (long)totalTags, (long)restResponse.getMetainfo().getTotalCount());
                allTags.addAll(restResponse.getData());
            }
            Assert.assertEquals((String)"Somehow not all users were loaded when loading all pages.", (long)totalTags, (long)allTags.size());
            List filteredUserList = allTags.parallelStream().filter(restTag -> restTag.getUuid().equals(noPermTagUUID)).collect(Collectors.toList());
            Assert.assertTrue((String)"The no perm tag should not be part of the list since no permissions were added.", (filteredUserList.size() == 0 ? 1 : 0) != 0);
            ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(4L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
            ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[]{new PagingParametersImpl(0, Long.valueOf(4L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"0"});
            ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
            long currentPerPage = 25L;
            totalPages = (int)Math.ceil((double)totalTags / (double)currentPerPage);
            TagListResponse tagList = (TagListResponse)ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(currentPerPage))}));
            Assert.assertEquals((long)0L, (long)tagList.getData().size());
            Assert.assertEquals((long)4242L, (long)tagList.getMetainfo().getCurrentPage());
            Assert.assertEquals((long)currentPerPage, (long)tagList.getMetainfo().getPerPage());
            Assert.assertEquals((long)9L, (long)tagList.getMetainfo().getTotalCount());
            Assert.assertEquals((long)totalPages, (long)tagList.getMetainfo().getPageCount());
            this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findTags("dummy", basicTagFamily.getUuid(), new ParameterProvider[]{param})), TagResponse::getName, "name", "List of tag names");
        }
    }

    @Test
    public void testReadMetaCountOnly() {
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            TagListResponse pageResponse = (TagListResponse)this.client().findTags("dummy", parentTagFamily.getUuid(), new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L))}).blockingGet();
            Assert.assertEquals((long)0L, (long)pageResponse.getData().size());
        }
    }

    @Override
    @Test
    public void testReadByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("red");
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            Assert.assertNotNull((String)"The UUID of the tag must not be null.", (Object)tag.getUuid());
            TagResponse response = (TagResponse)this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), tag.getUuid(), new ParameterProvider[0]).blockingGet();
            MeshAssertions.assertThat((TagResponse)response).matches(tag);
        }
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("red");
            String uuid = tag.getUuid();
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            TagResponse response = (TagResponse)ClientHelper.call(() -> this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), uuid, new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.role().getUuid())}));
            ((PermissionInfoAssert)MeshAssertions.assertThat((PermissionInfo)response.getRolePerms()).as("Role perms", new Object[0])).hasPerm(new Permission[]{Permission.CREATE, Permission.READ, Permission.UPDATE, Permission.DELETE});
        }
    }

    @Test
    public void testReadTagByUUIDWithoutPerm() throws Exception {
        String uuid;
        String parentTagFamilyUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibTagFamily parentTagFamily = this.tagFamily("basic");
            parentTagFamilyUuid = parentTagFamily.getUuid();
            HibTag tag = this.tag("vehicle");
            uuid = tag.getUuid();
            Assert.assertNotNull((String)"The UUID of the tag must not be null.", (Object)tag.getUuid());
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findTagByUuid("dummy", parentTagFamilyUuid, uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testUpdate() throws Exception {
        List nodes;
        String newName = "new Name";
        HibTag tag = this.tag("vehicle");
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        HibTagFamily parentTagFamily = this.tagFamily("basic");
        String parentTagFamilyUuid = (String)this.tx(() -> parentTagFamily.getUuid());
        TagUpdateRequest tagUpdateRequest = new TagUpdateRequest();
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            String tagName = tag.getName();
            Assert.assertNotNull((Object)tag.getEditor());
            TagResponse restTag = (TagResponse)ClientHelper.call(() -> this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), tag.getUuid(), new ParameterProvider[0]));
            Assert.assertNotNull((String)"The name of the tag should be loaded.", (Object)tagName);
            String restName = restTag.getName();
            Assert.assertNotNull((String)"The tag name must be set.", (Object)restName);
            Assert.assertEquals((Object)tagName, (Object)restName);
            tagUpdateRequest.setName("new Name");
            Assert.assertEquals((Object)"new Name", (Object)tagUpdateRequest.getName());
            this.trackingSearchProvider().clear().blockingAwait();
            nodes = tagDao.getNodes(tag, this.project().getLatestBranch()).list();
            tx.success();
        }
        this.expect(MeshEvent.TAG_UPDATED).match(1, TagMeshEventModel.class, event -> ((TagMeshEventModelAssert)((TagMeshEventModelAssert)MeshAssertions.assertThat((TagMeshEventModel)event).hasName("new Name")).hasUuid(tagUuid)).hasTagFamily("basic", parentTagFamilyUuid));
        TagResponse tag2 = (TagResponse)ClientHelper.call(() -> this.client().updateTag("dummy", parentTagFamilyUuid, tagUuid, tagUpdateRequest));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibTag.composeIndexName((String)this.projectUuid()), HibTag.composeDocumentId((String)tag2.getUuid()));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibTagFamily.composeIndexName((String)this.projectUuid()), HibTagFamily.composeDocumentId((String)parentTagFamilyUuid));
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            MeshAssertions.assertThat((TagResponse)tag2).matches(tag);
            String projectUuid = this.project().getUuid();
            String branchUuid = this.project().getLatestBranch().getUuid();
            for (HibNode node : nodes) {
                String schemaContainerVersionUuid = contentDao.getLatestDraftFieldContainer(node, this.english()).getSchemaContainerVersion().getUuid();
                for (ContainerType type : Arrays.asList(ContainerType.DRAFT, ContainerType.PUBLISHED)) {
                    MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)projectUuid, (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)type, null, null), ContentDao.composeDocumentId((String)node.getUuid(), (String)"en"));
                    MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)projectUuid, (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)type, null, null), ContentDao.composeDocumentId((String)node.getUuid(), (String)"de"));
                }
            }
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibTagFamily.composeIndexName((String)projectUuid), HibTagFamily.composeDocumentId((String)parentTagFamily.getUuid()));
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents((long)(2 + nodes.size() * 4), 0L, 0L, 0L, 0L);
            TagResponse reloadedTag = (TagResponse)ClientHelper.call(() -> this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), tagUuid, new ParameterProvider[0]));
            Assert.assertEquals((Object)tagUpdateRequest.getName(), (Object)reloadedTag.getName());
            MeshAssertions.assertThat((TagResponse)reloadedTag).matches(tag);
        }
    }

    @Test
    public void testUpdateTagWithConflictingName() {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("red");
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            String uuid = tag.getUuid();
            String tagFamilyName = tag.getTagFamily().getName();
            String newName = "green";
            TagUpdateRequest request = new TagUpdateRequest();
            request.setName("green");
            TagUpdateRequest tagUpdateRequest = new TagUpdateRequest();
            tagUpdateRequest.setName("green");
            Assert.assertEquals((Object)"green", (Object)tagUpdateRequest.getName());
            ClientHelper.call(() -> this.client().updateTag("dummy", parentTagFamily.getUuid(), uuid, tagUpdateRequest), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"tag_create_tag_with_same_name_already_exists", (String[])new String[]{"green", tagFamilyName});
        }
    }

    @Test
    public void testUpdateTagWithNoName() {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("red");
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            String uuid = tag.getUuid();
            TagUpdateRequest tagUpdateRequest = new TagUpdateRequest();
            ClientHelper.call(() -> this.client().updateTag("dummy", parentTagFamily.getUuid(), uuid, tagUpdateRequest), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"tag_name_not_set", (String[])new String[0]);
        }
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        HibTag tag = this.tag("vehicle");
        HibTagFamily parentTagFamily = this.tagFamily("basic");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            String tagName = tag.getName();
            String tagUuid = tag.getUuid();
            TagUpdateRequest request = new TagUpdateRequest();
            request.setName("new Name");
            ClientHelper.call(() -> this.client().updateTag("dummy", parentTagFamily.getUuid(), tagUuid, request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tagUuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            TagResponse loadedTag = (TagResponse)this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), tagUuid, new ParameterProvider[0]).blockingGet();
            Assert.assertEquals((Object)tagName, (Object)loadedTag.getName());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        String projectUuid = (String)this.db().tx(() -> this.project().getUuid());
        String branchUuid = (String)this.db().tx(() -> this.project().getLatestBranch().getUuid());
        HibTag tag = this.tag("vehicle");
        HibTagFamily parentTagFamily = this.tagFamily("basic");
        String parentTagFamilyUuid = (String)this.tx(() -> parentTagFamily.getUuid());
        String tagUuid = (String)this.tx(() -> tag.getUuid());
        this.expect(MeshEvent.TAG_DELETED).match(1, TagMeshEventModel.class, event -> ((TagMeshEventModelAssert)((TagMeshEventModelAssert)MeshAssertions.assertThat((TagMeshEventModel)event).hasName("Vehicle")).hasUuid(tagUuid)).hasTagFamily("basic", parentTagFamilyUuid)).one();
        this.tx(tx -> {
            TagDao tagDao = tx.tagDao();
            tagDao.getNodes(tag, this.initialBranch()).forEach(n -> {
                String uuid = n.getUuid();
                this.expect(MeshEvent.NODE_UNTAGGED).match(1, NodeTaggedEventModel.class, event -> {
                    Assert.assertEquals((Object)uuid, (Object)event.getNode().getUuid());
                    Assert.assertEquals((Object)tagUuid, (Object)event.getTag().getUuid());
                });
            });
        });
        List nodes = (List)this.tx(tx -> {
            TagDao tagDao = tx.tagDao();
            return tagDao.getNodes(tag, this.project().getLatestBranch()).list();
        });
        ClientHelper.call(() -> this.client().deleteTag("dummy", parentTagFamily.getUuid(), tagUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        try (Tx tx2 = this.tx();){
            ContentDao contentDao = tx2.contentDao();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibTag.composeIndexName((String)projectUuid), HibTag.composeDocumentId((String)tagUuid));
            for (HibNode node : nodes) {
                String schemaContainerVersionUuid = contentDao.getLatestDraftFieldContainer(node, this.english()).getSchemaContainerVersion().getUuid();
                MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)projectUuid, (String)branchUuid, (String)schemaContainerVersionUuid, (ContainerType)ContainerType.DRAFT, null, null), ContentDao.composeDocumentId((String)node.getUuid(), (String)"en"));
            }
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(4L, 0L, 1L, 0L, 0L);
            HibTag reloadedTag = (HibTag)tx2.tagDao().findByUuid(tagUuid);
            Assert.assertNull((String)"The tag should have been deleted", (Object)reloadedTag);
            HibProject project = (HibProject)tx2.projectDao().findByName("dummy");
            Assert.assertNotNull((Object)project);
        }
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        String uuid;
        HibTag tag;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tag("vehicle"), new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        try (Tx tx = this.tx();){
            tag = this.tag("vehicle");
            uuid = tag.getUuid();
            HibTagFamily parentTagFamily = this.tagFamily("basic");
            ClientHelper.call(() -> this.client().deleteTag("dummy", parentTagFamily.getUuid(), uuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.DELETE_PERM.getRestPerm().getName()});
        }
        tx = this.tx();
        try {
            tag = (HibTag)tx.tagDao().findByUuid(uuid);
            Assert.assertNotNull((String)"The tag should not have been deleted", (Object)tag);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testCreateConflictingName() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            TagCreateRequest tagCreateRequest = new TagCreateRequest();
            tagCreateRequest.setName("red");
            MeshRestClientMessageException exception = ClientHelper.call(() -> this.client().createTag("dummy", tagFamily.getUuid(), tagCreateRequest), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"tag_create_tag_with_same_name_already_exists", (String[])new String[]{"red", "colors"});
            Assert.assertNotNull((Object)exception.getResponseMessage().getProperties());
            Assert.assertNotNull(exception.getResponseMessage().getProperties().get("conflictingUuid"));
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        TagCreateRequest tagCreateRequest = new TagCreateRequest();
        tagCreateRequest.setName("SomeName");
        String parentTagFamilyUuid = (String)this.db().tx(() -> this.tagFamily("colors").getUuid());
        String projectUuid = (String)this.db().tx(() -> this.project().getUuid());
        this.expect(MeshEvent.TAG_CREATED).match(1, TagMeshEventModel.class, event -> ((TagMeshEventModelAssert)((TagMeshEventModelAssert)MeshAssertions.assertThat((TagMeshEventModel)event).hasName("SomeName")).uuidNotNull()).hasTagFamily("colors", parentTagFamilyUuid));
        TagResponse response = (TagResponse)ClientHelper.call(() -> this.client().createTag("dummy", parentTagFamilyUuid, tagCreateRequest));
        Assert.assertEquals((Object)"SomeName", (Object)response.getName());
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibTag.composeIndexName((String)projectUuid), HibTag.composeDocumentId((String)response.getUuid()));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibTagFamily.composeIndexName((String)projectUuid), HibTagFamily.composeDocumentId((String)parentTagFamilyUuid));
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(2L, 0L, 0L, 0L, 0L);
        try (Tx tx = this.tx();){
            Assert.assertNotNull((String)"The tag could not be found within the meshRoot.tagRoot node.", (Object)tx.tagDao().findByUuid(response.getUuid()));
        }
        String uuid = response.getUuid();
        response = (TagResponse)ClientHelper.call(() -> this.client().findTagByUuid("dummy", parentTagFamilyUuid, uuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)"SomeName", (Object)response.getName());
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        TagCreateRequest tagCreateRequest = new TagCreateRequest();
        tagCreateRequest.setName("SomeName");
        String parentTagFamilyUuid = (String)this.db().tx(() -> this.tagFamily("colors").getUuid());
        String tagRootUuid = (String)this.db().tx(() -> this.tagFamily("colors").getUuid());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.tagFamily("colors"), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().createTag("dummy", parentTagFamilyUuid, tagCreateRequest), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tagRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        TagCreateRequest tagUpdateRequest = new TagCreateRequest();
        tagUpdateRequest.setName("SomeName");
        String parentTagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String uuid = UUIDUtil.randomUUID();
        TagResponse response = (TagResponse)ClientHelper.call(() -> this.client().createTag("dummy", parentTagFamilyUuid, uuid, tagUpdateRequest));
        MeshAssertions.assertThat((TagResponse)response).hasName("SomeName").hasUuid(uuid);
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        TagUpdateRequest tagUpdateRequest = new TagUpdateRequest();
        tagUpdateRequest.setName("SomeName");
        String parentTagFamilyUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String uuid = this.userUuid();
        ClientHelper.call(() -> this.client().updateTag("dummy", parentTagFamilyUuid, uuid, tagUpdateRequest), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
    }

    @Test
    public void testCreateTagWithSameNameInSameTagFamily() {
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            TagCreateRequest tagCreateRequest = new TagCreateRequest();
            Assert.assertNotNull((String)"We expect that a tag with the name already exists.", (Object)this.tag("red"));
            tagCreateRequest.setName("red");
            HibTagFamily tagFamily = this.data().getTagFamilies().get("colors");
            String tagFamilyName = tagFamily.getName();
            ClientHelper.call(() -> this.client().createTag("dummy", parentTagFamily.getUuid(), tagCreateRequest), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"tag_create_tag_with_same_name_already_exists", (String[])new String[]{"red", tagFamilyName});
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet supported")
    public void testUpdateMultithreaded() throws Exception {
        int nJobs = 5;
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            TagUpdateRequest request = new TagUpdateRequest();
            request.setName("newName");
            String uuid = this.tag("red").getUuid();
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().updateTag("dummy", parentTagFamily.getUuid(), uuid, request));
        }
    }

    @Override
    @Test
    public void testReadByUuidMultithreaded() throws Exception {
        int nJobs = 100;
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            String uuid = this.tag("red").getUuid();
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), uuid, new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet supported")
    public void testDeleteByUUIDMultithreaded() throws Exception {
        int nJobs = 3;
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            String uuid = this.tag("red").getUuid();
            ClientHelper.validateDeletion(i -> this.client().deleteTag("dummy", parentTagFamily.getUuid(), uuid), (int)nJobs);
        }
    }

    @Override
    @Test
    @Ignore(value="Disabled since test is unstable - CL-246")
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 200;
        HibTagFamily parentTagFamily = this.tagFamily("colors");
        MeshTestHelper.validateCreation(nJobs, i -> {
            TagCreateRequest request = new TagCreateRequest();
            request.setName("newcolor_" + i);
            return this.client().createTag("dummy", parentTagFamily.getUuid(), request);
        });
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        int nJobs = 200;
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findTagByUuid("dummy", parentTagFamily.getUuid(), this.tag("red").getUuid(), new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        TagCreateRequest tagCreateRequest = new TagCreateRequest();
        tagCreateRequest.setName("SomeName");
        HibTagFamily tagFamily = this.data().getTagFamilies().get("colors");
        try (Tx tx = this.tx();){
            TagResponse response = (TagResponse)ClientHelper.call(() -> this.client().createTag("dummy", tagFamily.getUuid(), tagCreateRequest));
            Assert.assertEquals((Object)"SomeName", (Object)response.getName());
            String uuid = response.getUuid();
            response = (TagResponse)ClientHelper.call(() -> this.client().findTagByUuid("dummy", tagFamily.getUuid(), uuid, new ParameterProvider[0]));
            Assert.assertEquals((Object)"SomeName", (Object)response.getName());
            String uuid2 = response.getUuid();
            ClientHelper.call(() -> this.client().deleteTag("dummy", tagFamily.getUuid(), uuid2));
        }
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        String uuid;
        String parentTagFamilyUuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibTag tag = this.tag("red");
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            parentTagFamilyUuid = parentTagFamily.getUuid();
            Assert.assertNotNull((String)"The UUID of the tag must not be null.", (Object)tag.getUuid());
            uuid = tag.getUuid();
            roleDao.revokePermissions(this.role(), (HibBaseElement)tag, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findTagByUuid("dummy", parentTagFamilyUuid, uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        TagUpdateRequest request = new TagUpdateRequest();
        request.setName("newName");
        try (Tx tx = this.tx();){
            HibTagFamily parentTagFamily = this.tagFamily("colors");
            ClientHelper.call(() -> this.client().updateTag("dummy", parentTagFamily.getUuid(), "bogus", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
        }
    }

    @Override
    @Test
    public void testPermissionResponse() {
        TagFamilyResponse tagfamily = (TagFamilyResponse)((TagFamilyListResponse)this.client().findTagFamilies("dummy", new ParameterProvider[0]).blockingGet()).getData().get(0);
        TagResponse tag = (TagResponse)((TagListResponse)this.client().findTags("dummy", tagfamily.getUuid(), new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)tag.getPermissions()).hasNoPublishPermsSet();
    }
}

