/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tag;

import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.tag.TagCreateRequest;
import com.gentics.mesh.core.rest.tag.TagListResponse;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class TagNodeEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadNodesForTag() {
        try (Tx tx = this.tx();){
            NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", this.tagFamily("colors").getUuid(), this.tag("red").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            NodeResponse concorde = new NodeResponse();
            concorde.setUuid(this.content("concorde").getUuid());
            ((AbstractListAssert)Assertions.assertThat((List)nodeList.getData()).as("Tagged nodes", new Object[0]).isNotNull().usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        }
    }

    @Test
    public void testReadPublishedNodesForTag() {
        String colorsUuid = (String)this.tx(() -> this.tagFamily("colors").getUuid());
        String redUuid = (String)this.tx(() -> this.tag("red").getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", (String)this.tx(() -> this.project().getBaseNode().getUuid()), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeListResponse nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", colorsUuid, redUuid, new ParameterProvider[]{new VersioningParametersImpl().published()}));
        Assertions.assertThat((List)nodeList.getData()).as("Published tagged nodes", new Object[0]).isNotNull().isEmpty();
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            InternalActionContext ac = this.mockActionContext();
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(nodeDao.getParentNode(this.content("concorde"), this.project().getLatestBranch().getUuid()), ac, bac);
            nodeDao.publish(this.content("concorde"), ac, bac);
        }
        nodeList = (NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", colorsUuid, redUuid, new ParameterProvider[0]));
        NodeResponse concorde = new NodeResponse();
        concorde.setUuid((String)this.tx(() -> this.content("concorde").getUuid()));
        ((AbstractListAssert)Assertions.assertThat((List)nodeList.getData()).as("Tagged nodes", new Object[0]).isNotNull().usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
    }

    @Test
    public void testReadNodesForTagInBranch() {
        NodeResponse concorde = new NodeResponse();
        concorde.setUuid((String)this.db().tx(() -> this.content("concorde").getUuid()));
        HibBranch newBranch = (HibBranch)this.tx(() -> this.createBranch("newbranch"));
        try (Tx tx = this.tx();){
            HibBranch initialBranch = this.initialBranch();
            Assertions.assertThat((List)((NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", this.tagFamily("colors").getUuid(), this.tag("red").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}))).getData()).as("Nodes tagged in latest branch", new Object[0]).isNotNull().isEmpty();
            Assertions.assertThat((List)((NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", this.tagFamily("colors").getUuid(), this.tag("red").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranch.getUuid())}))).getData()).as("Nodes tagged in new branch", new Object[0]).isNotNull().isEmpty();
            ((AbstractListAssert)Assertions.assertThat((List)((NodeListResponse)ClientHelper.call(() -> this.client().findNodesForTag("dummy", this.tagFamily("colors").getUuid(), this.tag("red").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(initialBranch.getUuid())}))).getData()).as("Nodes tagged in initial branch", new Object[0]).isNotNull().usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new NodeResponse[]{concorde});
        }
    }

    @Test
    public void testTagOrder() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            RoleDao roleDao = tx.roleDao();
            HibTagFamily root = this.tagFamily("basic");
            HibTag tag1 = tagDao.create(root, "test1", this.project(), this.user());
            HibTag tag2 = tagDao.create(root, "test2", this.project(), this.user());
            HibTag tag3 = tagDao.create(root, "test3", this.project(), this.user());
            HibNode node = this.content();
            tagDao.addTag(node, tag1, this.latestBranch());
            tagDao.addTag(node, tag3, this.latestBranch());
            tagDao.addTag(node, tag2, this.latestBranch());
            roleDao.grantPermissions(this.role(), (HibBaseElement)tag1, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)tag2, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)tag3, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        String tagFamilyUuid = (String)this.db().tx(() -> this.tagFamily("basic").getUuid());
        TagResponse tagResponse = (TagResponse)ClientHelper.call(() -> this.client().createTag("dummy", tagFamilyUuid, new TagCreateRequest().setName("test4")));
        String nodeUuid = this.contentUuid();
        TagListResponse list = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[0]));
        List names = list.getData().stream().map(entry -> entry.getName()).collect(Collectors.toList());
        Assertions.assertThat(names).containsExactlyInAnyOrder((Object[])new String[]{"test1", "test3", "test2"});
        ClientHelper.call(() -> this.client().addTagToNode("dummy", nodeUuid, tagResponse.getUuid(), new ParameterProvider[0]));
        list = (TagListResponse)ClientHelper.call(() -> this.client().findTagsForNode("dummy", nodeUuid, new ParameterProvider[0]));
        names = list.getData().stream().map(entry -> entry.getName()).collect(Collectors.toList());
        Assertions.assertThat(names).containsExactlyInAnyOrder((Object[])new String[]{"test1", "test3", "test2", "test4"});
    }
}

