/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tag;

import com.gentics.mesh.context.BranchMigrationContext;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.BranchMigrationContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PersistingTagDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.migration.BranchMigration;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.tag.TagReference;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class TagTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    private static Logger log = LoggerFactory.getLogger(TagTest.class);
    public static final String GERMAN_NAME = "test german name";
    public static final String ENGLISH_NAME = "test english name";
    private BranchMigration branchMigrationHandler;

    @Before
    public void setupHandler() {
        this.branchMigrationHandler = this.meshDagger().branchMigrationHandler();
    }

    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("red");
            TagReference reference = tag.transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)tag.getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)tag.getName(), (Object)reference.getName());
        }
    }

    @Test
    public void testTagFamilyTagCreation() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            String TAG_FAMILY_NAME = "mycustomtagFamily";
            HibTagFamily tagFamily = tagFamilyDao.create(this.project(), "mycustomtagFamily", this.user());
            Assert.assertNotNull((Object)tagFamily);
            Assert.assertEquals((Object)"mycustomtagFamily", (Object)tagFamily.getName());
            Assert.assertNull((Object)tagFamily.getDescription());
            tagFamily.setDescription("description");
            Assert.assertEquals((Object)"description", (Object)tagFamily.getDescription());
            Assert.assertEquals((long)0L, (long)tagDao.count((HibCoreElement)tagFamily));
            Assert.assertNotNull((Object)tagDao.create(tagFamily, GERMAN_NAME, this.project(), this.user()));
            Assert.assertEquals((long)1L, (long)tagDao.count((HibCoreElement)tagFamily));
        }
    }

    @Test
    public void testReadFieldContainer() {
        try (Tx tx = this.tx();){
            HibTag tag = this.tags().get("red");
            Assert.assertEquals((Object)"red", (Object)tag.getName());
        }
    }

    @Test
    public void testSimpleTag() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTagFamily root = this.tagFamily("basic");
            HibTag tag = tagDao.create(root, "test", this.project(), this.user());
            Assert.assertEquals((Object)"test", (Object)tag.getName());
            tag.setName("test2");
            Assert.assertEquals((Object)"test2", (Object)tag.getName());
        }
    }

    @Test
    public void testProjectTag() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTagFamily root = this.tagFamily("basic");
            HibTag tag = tagDao.create(root, "test", this.project(), this.user());
            Assert.assertEquals((Object)this.project(), (Object)tag.getProject());
        }
    }

    @Test
    public void testNodeTagging() throws Exception {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            NodeDao nodeDao = tx.nodeDao();
            TagDao tagDao = tx.tagDao();
            HibTagFamily root = this.tagFamily("basic");
            HibProject project = this.project();
            HibBranch branch = project.getLatestBranch();
            HibTag tag = tagDao.create(root, ENGLISH_NAME, project, this.user());
            String uuid = tag.getUuid();
            Assert.assertNotNull((Object)tx.tagDao().findByUuid(uuid));
            String GERMAN_TEST_FILENAME = "german.html";
            HibNode parentNode = this.folder("2015");
            HibNode node = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), project);
            String german = "de";
            HibNodeFieldContainer germanContainer = tx.contentDao().createFieldContainer(node, german, branch, this.user());
            germanContainer.getSchemaContainerVersion().getSchema().addField((FieldSchema)new StringFieldSchemaImpl().setName("displayName"));
            germanContainer.getSchemaContainerVersion().getSchema().addField((FieldSchema)new StringFieldSchemaImpl().setName("name"));
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)germanContainer.getSchemaContainerVersion());
            germanContainer.createString("displayName").setString("german.html");
            germanContainer.createString("name").setString("german node name");
            tagDao.addTag(node, tag, branch);
            HibTag reloadedTag = (HibTag)tx.tagDao().findByUuid(tag.getUuid());
            Assert.assertEquals((String)"The tag should have exactly one node.", (long)1L, (long)tagDao.getNodes(reloadedTag, branch).count());
            HibNode contentFromTag = (HibNode)tagDao.getNodes(reloadedTag, branch).iterator().next();
            HibNodeFieldContainer fieldContainer = contentDao.getLatestDraftFieldContainer(contentFromTag, german);
            Assert.assertNotNull((Object)contentFromTag);
            Assert.assertEquals((String)"We did not get the correct content.", (Object)node.getUuid(), (Object)contentFromTag.getUuid());
            String filename = fieldContainer.getString("displayName").getString();
            Assert.assertEquals((String)"The name of the file from the loaded tag did not match the expected one.", (Object)"german.html", (Object)filename);
            tagDao.removeNode(reloadedTag, contentFromTag);
            Assert.assertEquals((String)"The tag should not have any file.", (long)0L, (long)tagDao.getNodes(reloadedTag, branch).count());
        }
    }

    @Test
    public void testNodeTaggingInBranch() throws Exception {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            TagDao tagDao = tx.tagDao();
            HibTagFamily root = this.tagFamily("basic");
            HibProject project = this.project();
            HibTag tag = tagDao.create(root, ENGLISH_NAME, project, this.user());
            String uuid = tag.getUuid();
            Assert.assertNotNull((Object)tagDao.findByUuid(uuid));
            Assert.assertNotNull((Object)tagDao.findByUuid(project, uuid));
            HibBranch initialBranch = this.initialBranch();
            HibBranch newBranch = this.createBranch("newbranch");
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(newBranch);
            context.setOldBranch(initialBranch);
            this.branchMigrationHandler.migrateBranch((BranchMigrationContext)context).blockingAwait();
            HibNode node = nodeDao.create(this.folder("2015"), this.user(), (HibSchemaVersion)this.getSchemaContainer().getLatestVersion(), project);
            tagDao.addTag(node, tag, initialBranch);
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getTags(node, initialBranch).list())).as("Tags in initial Release", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new HibTag[]{tag});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, initialBranch).list())).as("Nodes with tag in initial Release", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new HibNode[]{node});
            Assertions.assertThat((List)tagDao.getTags(node, newBranch).list()).as("Tags in new Branch", new Object[0]).isEmpty();
            Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, newBranch).list())).as("Nodes with tag in new Branch", new Object[0]).isEmpty();
            tagDao.addTag(node, tag, newBranch);
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getTags(node, initialBranch).list())).as("Tags in initial Release", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new HibTag[]{tag});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, initialBranch).list())).as("Nodes with tag in initial Release", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new HibNode[]{node});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getTags(node, newBranch).list())).as("Tags in new Release", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new HibTag[]{tag});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, newBranch).list())).as("Nodes with tag in new Release", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new HibNode[]{node});
        }
    }

    @Test
    public void testMigrateTagsForBranch() throws Exception {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTagFamily root = this.tagFamily("basic");
            HibProject project = this.project();
            HibBranch initialBranch = project.getInitialBranch();
            HibTag tag = tagDao.create(root, ENGLISH_NAME, project, this.user());
            String uuid = tag.getUuid();
            Assert.assertNotNull((Object)tx.tagDao().findByUuid(uuid));
            HibNode node = this.folder("2015");
            tagDao.removeAllTags(node, initialBranch);
            tagDao.addTag(node, tag, initialBranch);
            HibBranch newBranch = this.createBranch("newbranch");
            BranchMigrationContextImpl context = new BranchMigrationContextImpl();
            context.setNewBranch(newBranch);
            context.setOldBranch(initialBranch);
            this.branchMigrationHandler.migrateBranch((BranchMigrationContext)context).blockingAwait();
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getTags(node, initialBranch).list())).as("Tags in initial Branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new HibTag[]{tag});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, initialBranch).list())).as("Nodes with tag in initial Branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new HibNode[]{node});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getTags(node, newBranch).list())).as("Tags in new Branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new HibTag[]{tag});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, newBranch).list())).as("Nodes with tag in new Branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new HibNode[]{node});
        }
    }

    @Test
    public void testNodeUntaggingInBranch() throws Exception {
        HibNode node = null;
        HibBranch initialBranch = (HibBranch)this.tx(() -> this.initialBranch());
        HibProject project = this.project();
        HibBranch newBranch = null;
        HibTag tag = null;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            TagDao tagDao = tx.tagDao();
            HibTagFamily root = this.tagFamily("basic");
            initialBranch = this.reloadBranch(project.getInitialBranch());
            tag = tagDao.create(root, ENGLISH_NAME, project, this.user());
            String uuid = tag.getUuid();
            Assert.assertNotNull((Object)tagDao.findByUuid((HibCoreElement)root, uuid));
            tagDao.removeAllTags(node, initialBranch);
            tagDao.addTag(node, tag, initialBranch);
            newBranch = this.createBranch("newbranch");
            tx.success();
        }
        BranchMigrationContextImpl context = new BranchMigrationContextImpl();
        context.setNewBranch(newBranch);
        context.setOldBranch(initialBranch);
        this.branchMigrationHandler.migrateBranch((BranchMigrationContext)context).blockingAwait();
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            Assertions.assertThat((List)tagDao.getTags(node, newBranch).list()).isNotEmpty();
            tagDao.removeTag(node, tag, initialBranch);
            Assertions.assertThat((List)tagDao.getTags(node, initialBranch).list()).as("Tags in initial Branch", new Object[0]).isEmpty();
            Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, initialBranch).list())).as("Nodes with tag in initial Branch", new Object[0]).isEmpty();
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getTags(node, newBranch).list())).as("Tags in new Branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid", "name"})).containsOnly((Object[])new HibTag[]{tag});
            ((AbstractListAssert)Assertions.assertThat(new ArrayList(tagDao.getNodes(tag, newBranch).list())).as("Nodes with tag in new Branch", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsOnly((Object[])new HibNode[]{node});
        }
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            Page tagPage = tx.tagDao().findAll(ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(10L)));
            Assert.assertEquals((long)12L, (long)tagPage.getTotalElements());
            Assert.assertEquals((long)10L, (long)tagPage.getSize());
            tagPage = tx.tagDao().findAll(ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(14L)));
            Assert.assertEquals((long)this.tags().size(), (long)tagPage.getTotalElements());
            Assert.assertEquals((long)12L, (long)tagPage.getSize());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            RoleDao roleDao = tx.roleDao();
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily basicTagFamily = this.tagFamily("basic");
            long beforeCount = tagDao.count((HibCoreElement)basicTagFamily);
            HibTag noPermTag = tagDao.create(basicTagFamily, "noPermTag", this.project(), this.user());
            tagFamilyDao.addTag(basicTagFamily, noPermTag);
            Assert.assertNotNull((Object)noPermTag.getUuid());
            Assert.assertEquals((long)(beforeCount + 1L), (long)tagDao.count((HibCoreElement)basicTagFamily));
            Page tagfamilyTagpage = tagDao.findAll((HibCoreElement)basicTagFamily, this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(20L)));
            this.assertPage((Page<? extends HibTag>)tagfamilyTagpage, beforeCount);
            roleDao.grantPermissions(this.role(), (HibBaseElement)noPermTag, new InternalPermission[]{InternalPermission.READ_PERM});
            Page globalTagPage = tagDao.findAll((HibCoreElement)basicTagFamily, this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(20L)));
            this.assertPage((Page<? extends HibTag>)globalTagPage, beforeCount + 1L);
        }
    }

    private void assertPage(Page<? extends HibTag> page, long expectedTagCount) {
        Assert.assertNotNull(page);
        int nTags = 0;
        for (HibTag tag : page) {
            Assert.assertNotNull((Object)tag.getName());
            ++nTags;
        }
        Assert.assertEquals((String)"The page did not contain the correct amount of tags", (long)expectedTagCount, (long)nTags);
        Assert.assertEquals((long)expectedTagCount, (long)page.getTotalElements());
        Assert.assertEquals((long)1L, (long)page.getNumber());
        Assert.assertEquals((long)1L, (long)page.getPageCount());
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            PersistingTagDao tagDao = ((CommonTx)tx.unwrap()).tagDao();
            long tagsSize = tagDao.count((HibCoreElement)tagFamily);
            HibTag tag = this.tag("red");
            tagDao.removeItem((HibCoreElement)tagFamily, (HibCoreElement)tag);
            Assert.assertEquals((long)(tagsSize - 1L), (long)tagDao.count((HibCoreElement)tagFamily));
            tagDao.removeItem((HibCoreElement)tagFamily, (HibCoreElement)tag);
            Assert.assertEquals((long)(tagsSize - 1L), (long)tagDao.count((HibCoreElement)tagFamily));
            tagDao.addItem((HibCoreElement)tagFamily, (HibCoreElement)tag);
            Assert.assertEquals((long)tagsSize, (long)tagDao.count((HibCoreElement)tagFamily));
            tagDao.addItem((HibCoreElement)tagFamily, (HibCoreElement)tag);
            Assert.assertEquals((long)tagsSize, (long)tagDao.count((HibCoreElement)tagFamily));
            tagDao.onRootDeleted((HibCoreElement)tagFamily, this.createBulkContext());
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTag tag = this.tag("car");
            HibTag foundTag = (HibTag)tagDao.findByName((HibCoreElement)tag.getTagFamily(), "Car");
            Assert.assertNotNull((Object)foundTag);
            Assert.assertEquals((Object)"Car", (Object)foundTag.getName());
            Assert.assertNull((String)"No tag with the name bogus should be found", (Object)tagDao.findByName((HibCoreElement)tag.getTagFamily(), "bogus"));
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("car");
            Assert.assertNotNull((String)"The tag with the uuid could not be found", (Object)tx.tagDao().findByUuid(tag.getUuid()));
            Assert.assertNull((String)"A tag with the a bogus uuid should not be found but it was.", (Object)tx.tagDao().findByUuid("bogus"));
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTagFamily tagFamily = this.tagFamily("basic");
            HibTag tag = tagDao.create(tagFamily, GERMAN_NAME, this.project(), this.user());
            Assert.assertNotNull((Object)tag);
            String uuid = tag.getUuid();
            CountDownLatch latch = new CountDownLatch(1);
            HibTag loadedTag = (HibTag)tx.tagDao().findByUuid(uuid);
            Assert.assertNotNull((String)"The folder could not be found.", (Object)loadedTag);
            String name = loadedTag.getName();
            Assert.assertEquals((String)"The loaded name of the folder did not match the expected one.", (Object)GERMAN_NAME, (Object)name);
            Assert.assertEquals((long)10L, (long)tagDao.count((HibCoreElement)tagFamily));
            latch.countDown();
            HibTag projectTag = (HibTag)tagDao.findByUuid((HibCoreElement)tagFamily, uuid);
            Assert.assertNotNull((String)"The tag should also be assigned to the project tag root", (Object)projectTag);
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTag tag = this.tag("red");
            Assert.assertNotNull((String)"The UUID of the tag must not be null.", (Object)tag.getUuid());
            ArrayList<String> languageTags = new ArrayList<String>();
            languageTags.add("en");
            languageTags.add("de");
            int depth = 3;
            InternalActionContext ac = this.mockActionContext("lang=de,en");
            int nTransformations = 100;
            for (int i = 0; i < nTransformations; ++i) {
                long start = System.currentTimeMillis();
                TagResponse response = (TagResponse)tagDao.transformToRestSync((Object)tag, ac, 0, new String[0]);
                Assert.assertNotNull((Object)response);
                long dur = System.currentTimeMillis() - start;
                log.info((Object)("Transformation with depth {" + depth + "} took {" + dur + "} [ms]"));
                response.toJson();
            }
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTagFamily tagFamily = this.tagFamily("basic");
            HibTag tag = tagDao.create(tagFamily, "someTag", this.project(), this.user());
            String uuid = tag.getUuid();
            Assert.assertNotNull((Object)tx.tagDao().findByUuid(uuid));
            tagDao.delete((HibBaseElement)tag, this.createBulkContext());
            Assert.assertNull((Object)tx.tagDao().findByUuid(uuid));
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            UserDao userDao = tx.userDao();
            HibTagFamily tagFamily = this.tagFamily("basic");
            HibTag tag = tagDao.create(tagFamily, "someTag", this.project(), this.user());
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)tagFamily, InternalPermission.READ_PERM));
            Assert.assertFalse((boolean)userDao.hasPermission(this.user(), (HibBaseElement)tag, InternalPermission.READ_PERM));
            userDao.inheritRolePermissions(this.getRequestUser(), (HibBaseElement)tagFamily, (HibBaseElement)tag);
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)tag, InternalPermission.READ_PERM));
        }
    }

    @Override
    @Test
    public void testRead() {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("car");
            Assert.assertEquals((Object)"Car", (Object)tag.getName());
            Assert.assertNotNull((Object)tag.getCreationTimestamp());
            Assert.assertNotNull((Object)tag.getLastEditedTimestamp());
            Assert.assertNotNull((Object)tag.getEditor());
            Assert.assertNotNull((Object)tag.getCreator());
            Assert.assertNotNull((Object)tag.getTagFamily());
        }
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        BulkActionContext bac = this.createBulkContext();
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HibTag tag = this.tag("red");
            tagDao.delete((HibBaseElement)tag, bac);
        }
        Assert.assertEquals((long)2L, (long)bac.batch().size());
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            HibTag tag = this.tag("red");
            tag.setName("Blue");
            Assert.assertEquals((Object)"Blue", (Object)tag.getName());
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)this.tag("red"));
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)this.tag("red"));
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)this.tag("red"));
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)this.tag("red"));
        }
    }
}

