/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tagfamily;

import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.PersistingTagFamilyDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.tag.TagFamilyReference;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class TagEndpointTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            TagFamilyReference reference = tagFamily.transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)tagFamily.getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)tagFamily.getName(), (Object)reference.getName());
        }
    }

    @Test
    public void testTagFamilyProject() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            Assert.assertNotNull((Object)tagFamily.getProject());
            Assert.assertEquals((Object)this.project(), (Object)tagFamily.getProject());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            tx.tagFamilyDao().findAll(this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(10L)));
        }
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            PersistingTagFamilyDao tagFamilyDao = ctx.tagFamilyDao();
            List families = tagFamilyDao.findAll().list();
            Assert.assertNotNull((Object)families);
            Assert.assertEquals((long)2L, (long)families.size());
            HibTagFamily projectTagFamily = (HibTagFamily)tagFamilyDao.findByName((HibCoreElement)this.project(), "colors");
            Assert.assertNotNull((Object)projectTagFamily);
            Assert.assertNotNull((Object)tagFamilyDao.create(this.project(), "bogus", this.user()));
            Assert.assertEquals((long)3L, (long)ctx.count(tagFamilyDao.getPersistenceClass((HibCoreElement)this.project())));
            Assert.assertEquals((long)3L, (long)tx.tagFamilyDao().count());
        }
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            PersistingTagFamilyDao tagFamilyDao = ctx.tagFamilyDao();
            long nProjectsBefore = tagFamilyDao.count((HibCoreElement)this.project());
            Assert.assertNotNull((Object)tagFamilyDao.create(this.project(), "test1234556", this.user()));
            long nProjectsAfter = tagFamilyDao.count((HibCoreElement)this.project());
            Assert.assertEquals((long)(nProjectsBefore + 1L), (long)nProjectsAfter);
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            Assert.assertNotNull((Object)tagFamilyDao.findByName("colors"));
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = this.tagFamily("colors");
            HibTagFamily foundTagFamily = (HibTagFamily)tagFamilyDao.findByUuid(tagFamily.getUuid());
            Assert.assertNotNull((Object)foundTagFamily);
        }
    }

    @Override
    @Test
    public void testRead() throws IOException {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            Assert.assertNotNull((Object)tagFamily.getName());
            Assert.assertEquals((Object)"colors", (Object)tagFamily.getName());
            Assert.assertNotNull((Object)tagFamily.getEditor());
            Assert.assertNotNull((Object)tagFamily.getCreator());
        }
    }

    @Override
    @Test
    public void testCreate() throws IOException {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily family = tagFamilyDao.create(this.project(), "test", this.user());
            HibTagFamily family2 = (HibTagFamily)tagFamilyDao.findByName((HibCoreElement)this.project(), family.getName());
            Assert.assertNotNull((Object)family2);
            Assert.assertEquals((Object)"test", (Object)family2.getName());
            Assert.assertEquals((Object)family.getUuid(), (Object)family2.getUuid());
        }
    }

    @Override
    @Test
    public void testDelete() {
        BulkActionContext context = this.createBulkContext();
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = this.tagFamily("colors");
            tagFamilyDao.delete((HibBaseElement)tagFamily, context);
            tx.success();
        }
        Assert.assertEquals((String)"The batch should contain 6 entries.", (long)6L, (long)context.batch().size());
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            tagFamily.setName("new Name");
            Assert.assertEquals((Object)"new Name", (Object)tagFamily.getName());
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = tx.tagFamilyDao().create(this.project(), "newProject", this.user());
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)tagFamily);
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = tx.tagFamilyDao().create(this.project(), "newProject", this.user());
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)tagFamily);
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = tx.tagFamilyDao().create(this.project(), "newProject", this.user());
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)tagFamily);
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = tx.tagFamilyDao().create(this.project(), "newProject", this.user());
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)tagFamily);
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = this.tagFamily("colors");
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            TagFamilyResponse response = (TagFamilyResponse)tagFamilyDao.transformToRestSync((Object)tagFamily, (InternalActionContext)ac, 0, new String[0]);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)tagFamily.getName(), (Object)response.getName());
            Assert.assertEquals((Object)tagFamily.getUuid(), (Object)response.getUuid());
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = tagFamilyDao.create(this.project(), "test123", this.user());
            Assert.assertNotNull((Object)tagFamily);
            String uuid = tagFamily.getUuid();
            HibTagFamily foundTagFamily = (HibTagFamily)tagFamilyDao.findByUuid(uuid);
            Assert.assertNotNull((Object)foundTagFamily);
            BulkActionContext bac = this.createBulkContext();
            tagFamilyDao.delete((HibBaseElement)tagFamily, bac);
            HibProject project = (HibProject)tx.projectDao().findByUuid(uuid);
            Assert.assertNull((Object)project);
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = tagFamilyDao.create(this.project(), "test123", this.user());
            Assert.assertFalse((boolean)userDao.hasPermission(this.user(), (HibBaseElement)tagFamily, InternalPermission.CREATE_PERM));
            userDao.inheritRolePermissions(this.user(), this.project().getTagFamilyPermissionRoot(), (HibBaseElement)tagFamily);
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)tagFamily, InternalPermission.CREATE_PERM));
        }
    }
}

