/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tagfamily;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.TagFamilyMeshEventModelAssert;
import com.gentics.mesh.assertj.impl.TagMeshEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.RootDao;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.tag.TagMeshEventModel;
import com.gentics.mesh.core.rest.event.tagfamily.TagFamilyMeshEventModel;
import com.gentics.mesh.core.rest.tag.TagFamilyCreateRequest;
import com.gentics.mesh.core.rest.tag.TagFamilyListResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyResponse;
import com.gentics.mesh.core.rest.tag.TagFamilyUpdateRequest;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.test.util.MeshAssert;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class TagFamilyEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    @Test
    public void testReadByUUID() throws UnknownHostException, InterruptedException {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = (HibTagFamily)tagFamilyDao.findAll((HibCoreElement)this.project()).iterator().next();
            Assert.assertNotNull((Object)tagFamily);
            TagFamilyResponse response = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", tagFamily.getUuid(), new ParameterProvider[0]));
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)tagFamily.getUuid(), (Object)response.getUuid());
        }
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily tagFamily = (HibTagFamily)tagFamilyDao.findAll((HibCoreElement)this.project()).iterator().next();
            String uuid = tagFamily.getUuid();
            TagFamilyResponse response = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", uuid, new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.role().getUuid())}));
            Assert.assertNotNull((String)"The response did not contain the expected role permission field value", (Object)response.getRolePerms());
            MeshAssertions.assertThat((PermissionInfo)response.getRolePerms()).hasPerm(Permission.basicPermissions());
        }
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibRole role = this.role();
            HibTagFamily tagFamily = (HibTagFamily)tagFamilyDao.findAll((HibCoreElement)this.project()).iterator().next();
            uuid = tagFamily.getUuid();
            Assert.assertNotNull((Object)tagFamily);
            roleDao.revokePermissions(role, (HibBaseElement)tagFamily, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadMultiple2() {
        try (Tx tx = this.tx();){
            HibTagFamily tagFamily = this.tagFamily("colors");
            String uuid = tagFamily.getUuid();
            ClientHelper.call(() -> this.client().findTags("dummy", uuid, new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    public void testReadMultiple() throws UnknownHostException, InterruptedException {
        try (Tx tx = this.tx();){
            TagFamilyDao tagFamilyDao = tx.tagFamilyDao();
            HibTagFamily noPermTagFamily = tagFamilyDao.create(this.project(), "noPermTagFamily", this.user());
            String noPermTagUUID = noPermTagFamily.getUuid();
            Assert.assertNotNull((Object)noPermTagFamily.getUuid());
            TagFamilyListResponse restResponse = (TagFamilyListResponse)ClientHelper.call(() -> this.client().findTagFamilies("dummy", new ParameterProvider[0]));
            Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
            Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
            Assert.assertEquals((String)"The response did not contain the correct amount of items", (long)this.data().getTagFamilies().size(), (long)restResponse.getData().size());
            long perPage = 4L;
            long totalTagFamilies = this.data().getTagFamilies().size();
            long totalPages = (long)Math.ceil((double)totalTagFamilies / 4.0);
            ArrayList allTagFamilies = new ArrayList();
            int page = 1;
            while ((long)page <= totalPages) {
                int currentPage = page;
                restResponse = (TagFamilyListResponse)ClientHelper.call(() -> this.client().findTagFamilies("dummy", (PagingParameters)new PagingParametersImpl(currentPage, Long.valueOf(4L))));
                long expectedItemsCount = 4L;
                if (page == 1) {
                    expectedItemsCount = 2L;
                }
                Assert.assertEquals((String)("The expected item count for page {" + page + "} does not match"), (long)expectedItemsCount, (long)restResponse.getData().size());
                Assert.assertEquals((long)4L, (long)restResponse.getMetainfo().getPerPage());
                Assert.assertEquals((String)("We requested page {" + page + "} but got a metainfo with a different page back."), (long)page, (long)restResponse.getMetainfo().getCurrentPage());
                Assert.assertEquals((String)("The amount of total pages did not match the expected value. There are {" + totalTagFamilies + "} tags and {4} tags per page"), (long)totalPages, (long)restResponse.getMetainfo().getPageCount());
                Assert.assertEquals((String)"The total tag count does not match.", (long)totalTagFamilies, (long)restResponse.getMetainfo().getTotalCount());
                allTagFamilies.addAll(restResponse.getData());
                ++page;
            }
            Assert.assertEquals((String)"Somehow not all users were loaded when loading all pages.", (long)totalTagFamilies, (long)allTagFamilies.size());
            List filteredUserList = allTagFamilies.parallelStream().filter(restTag -> restTag.getUuid().equals(noPermTagUUID)).collect(Collectors.toList());
            Assert.assertTrue((String)"The no perm tag should not be part of the list since no permissions were added.", (filteredUserList.size() == 0 ? 1 : 0) != 0);
            ClientHelper.call(() -> this.client().findTagFamilies("dummy", (PagingParameters)new PagingParametersImpl(-1, Long.valueOf(4L))), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
            ClientHelper.call(() -> this.client().findTagFamilies("dummy", (PagingParameters)new PagingParametersImpl(0, Long.valueOf(4L))), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"0"});
            ClientHelper.call(() -> this.client().findTagFamilies("dummy", (PagingParameters)new PagingParametersImpl(1, Long.valueOf(-1L))), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
            long currentPerPage = 25L;
            totalPages = (int)Math.ceil((double)totalTagFamilies / (double)currentPerPage);
            TagFamilyListResponse tagList = (TagFamilyListResponse)ClientHelper.call(() -> this.client().findTagFamilies("dummy", (PagingParameters)new PagingParametersImpl(4242, Long.valueOf(currentPerPage))));
            Assert.assertEquals((long)0L, (long)tagList.getData().size());
            Assert.assertEquals((long)4242L, (long)tagList.getMetainfo().getCurrentPage());
            Assert.assertEquals((long)25L, (long)tagList.getMetainfo().getPerPage());
            Assert.assertEquals((long)totalTagFamilies, (long)tagList.getMetainfo().getTotalCount());
            Assert.assertEquals((long)totalPages, (long)tagList.getMetainfo().getPageCount());
        }
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findTagFamilies("dummy", new ParameterProvider[]{param})), TagFamilyResponse::getName, "name", "List of tag family names");
    }

    @Test
    public void testReadMetaCountOnly() {
        TagFamilyListResponse page = (TagFamilyListResponse)this.client().findTagFamilies("dummy", (PagingParameters)new PagingParametersImpl(1, Long.valueOf(0L))).toSingle().blockingGet();
        Assert.assertEquals((long)0L, (long)page.getData().size());
    }

    @Test
    public void testCreateWithConflictingName() {
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        request.setName("colors");
        ClientHelper.call(() -> this.client().createTagFamily("dummy", request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"tagfamily_conflicting_name", (String[])new String[]{"colors"});
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        request.setName("newTagFamily");
        this.expect(MeshEvent.TAG_FAMILY_CREATED).match(1, TagFamilyMeshEventModel.class, event -> ((TagFamilyMeshEventModelAssert)((TagFamilyMeshEventModelAssert)MeshAssertions.assertThat((TagFamilyMeshEventModel)event).hasName("newTagFamily")).uuidNotNull()).hasProject("dummy", this.projectUuid()));
        TagFamilyResponse response = (TagFamilyResponse)ClientHelper.call(() -> this.client().createTagFamily("dummy", request));
        Assert.assertEquals((Object)request.getName(), (Object)response.getName());
        this.awaitEvents();
    }

    @Override
    @Test
    public void testCreateWithNoPerm() {
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        request.setName("newTagFamily");
        String tagFamilyRootUuid = (String)this.tx(tx -> this.project().getTagFamilyPermissionRoot().getUuid());
        try (Tx tx2 = this.tx();){
            RoleDao roleDao = tx2.roleDao();
            roleDao.revokePermissions(this.role(), this.project().getTagFamilyPermissionRoot(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx2.success();
        }
        ClientHelper.call(() -> this.client().createTagFamily("dummy", request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{tagFamilyRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        request.setName("newTagFamily");
        String uuid = UUIDUtil.randomUUID();
        TagFamilyResponse response = (TagFamilyResponse)ClientHelper.call(() -> this.client().createTagFamily("dummy", uuid, request));
        MeshAssertions.assertThat((TagFamilyResponse)response).hasName("newTagFamily").hasUuid(uuid);
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName("newTagFamily");
        String uuid = (String)this.db().tx(() -> this.user().getUuid());
        ClientHelper.call(() -> this.client().updateTagFamily("dummy", uuid, request), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        request.setName("newTagFamily");
        TagFamilyResponse tagFamily = (TagFamilyResponse)ClientHelper.call(() -> this.client().createTagFamily("dummy", request));
        String tagFamilyUuid = tagFamily.getUuid();
        tagFamily = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", tagFamilyUuid, new ParameterProvider[0]));
        String tagFamilyUuid2 = tagFamily.getUuid();
        ClientHelper.call(() -> this.client().deleteTagFamily("dummy", tagFamilyUuid2));
    }

    @Test
    public void testCreateWithoutPerm() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), this.project().getTagFamilyPermissionRoot(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            TagFamilyCreateRequest request = new TagFamilyCreateRequest();
            request.setName("SuperDoll");
            ClientHelper.call(() -> this.client().createTagFamily("dummy", request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.project().getTagFamilyPermissionRoot().getUuid(), InternalPermission.CREATE_PERM.getRestPerm().getName()});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testCreateWithNoName() {
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        ClientHelper.call(() -> this.client().createTagFamily("dummy", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"tagfamily_name_not_set", (String[])new String[0]);
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        HibTagFamily basicTagFamily = this.tagFamily("basic");
        String tagFamilyUuid = (String)this.tx(() -> basicTagFamily.getUuid());
        try (Tx tx2 = this.tx();){
            Assert.assertNotNull((Object)((CommonTx)tx2.unwrap()).tagFamilyDao().findByUuid((HibCoreElement)this.project(), tagFamilyUuid));
        }
        this.expect(MeshEvent.TAG_FAMILY_DELETED).match(1, TagFamilyMeshEventModel.class, event -> ((TagFamilyMeshEventModelAssert)((TagFamilyMeshEventModelAssert)MeshAssertions.assertThat((TagFamilyMeshEventModel)event).hasName("basic")).hasUuid(tagFamilyUuid)).hasProject("dummy", this.projectUuid()));
        this.expect(MeshEvent.TAG_DELETED).match(1, TagMeshEventModel.class, event -> ((TagMeshEventModelAssert)((TagMeshEventModelAssert)MeshAssertions.assertThat((TagMeshEventModel)event).hasName("Vehicle")).uuidNotNull()).hasProject("dummy", this.projectUuid()).hasTagFamily("basic", tagFamilyUuid));
        List tags = (List)this.tx(tx -> tx.tagDao().findAll((HibCoreElement)basicTagFamily).list());
        List tagUuids = (List)this.tx(() -> tags.stream().map(HibElement::getUuid).collect(Collectors.toList()));
        HashSet taggedDraftContentUuids = new HashSet();
        HashSet taggedPublishedContentUuids = new HashSet();
        this.tx(tx -> {
            TagDao tagDao = tx.tagDao();
            tags.forEach(t -> tagDao.getNodes(t, this.initialBranch()).forEach(n -> {
                tx.contentDao().getFieldContainers(n, this.initialBranch(), ContainerType.DRAFT).forEach(c -> taggedDraftContentUuids.add(c.getUuid()));
                tx.contentDao().getFieldContainers(n, this.initialBranch(), ContainerType.PUBLISHED).forEach(c -> taggedPublishedContentUuids.add(c.getUuid()));
            }));
        });
        ClientHelper.call(() -> this.client().deleteTagFamily("dummy", tagFamilyUuid));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibTagFamily.composeIndexName((String)this.projectUuid()), HibTagFamily.composeDocumentId((String)tagFamilyUuid));
        for (String tagUuid : tagUuids) {
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibTag.composeIndexName((String)this.projectUuid()), HibTag.composeDocumentId((String)tagUuid));
        }
        int deleted = 1 + tagUuids.size();
        int stored = taggedPublishedContentUuids.size() + taggedDraftContentUuids.size();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents((long)stored, 0L, (long)deleted, 0L, 0L);
        try (Tx tx3 = this.tx();){
            MeshAssert.assertElement((RootDao)tx3.tagFamilyDao(), (HibCoreElement)this.project(), (String)tagFamilyUuid, (boolean)false);
        }
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        HibTagFamily basicTagFamily = this.tagFamily("basic");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibRole role = this.role();
            roleDao.revokePermissions(role, (HibBaseElement)basicTagFamily, new InternalPermission[]{InternalPermission.DELETE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            MeshAssert.assertElement((RootDao)tx.tagFamilyDao(), (HibCoreElement)this.project(), (String)basicTagFamily.getUuid(), (boolean)true);
            ClientHelper.call(() -> this.client().deleteTagFamily("dummy", basicTagFamily.getUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{basicTagFamily.getUuid(), InternalPermission.DELETE_PERM.getRestPerm().getName()});
            MeshAssert.assertElement((RootDao)tx.tagFamilyDao(), (HibCoreElement)this.project(), (String)basicTagFamily.getUuid(), (boolean)true);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testUpdateWithSameName() {
        String newName = "basic";
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName(newName);
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("basic").getUuid());
        this.expect(MeshEvent.TAG_FAMILY_UPDATED).none();
        this.expect(MeshEvent.TAG_UPDATED).none();
        ClientHelper.call(() -> this.client().updateTagFamily("dummy", tagFamilyUuid, request));
    }

    @Test
    public void testUpdateWithConflictingName() {
        String tagFamilyUuid = (String)this.tx(() -> this.tagFamily("basic").getUuid());
        String newName = "colors";
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName(newName);
        ClientHelper.call(() -> this.client().updateTagFamily("dummy", tagFamilyUuid, request), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"tagfamily_conflicting_name", (String[])new String[]{newName});
    }

    @Override
    @Test
    public void testUpdate() throws Exception {
        String name = (String)this.tx(() -> this.tagFamily("basic").getName());
        String uuid = (String)this.tx(() -> this.tagFamily("basic").getUuid());
        TagFamilyResponse readTagResponse = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", uuid, new ParameterProvider[0]));
        Assert.assertNotNull((String)"The name of the tag should be loaded.", (Object)name);
        String restName = readTagResponse.getName();
        Assert.assertNotNull((String)"The tag name must be set.", (Object)restName);
        Assert.assertEquals((Object)name, (Object)restName);
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName("new Name");
        this.expect(MeshEvent.TAG_FAMILY_UPDATED).match(1, TagFamilyMeshEventModel.class, event -> ((TagFamilyMeshEventModelAssert)((TagFamilyMeshEventModelAssert)MeshAssertions.assertThat((TagFamilyMeshEventModel)event).hasName("new Name")).hasUuid(uuid)).hasProject("dummy", this.projectUuid()));
        TagFamilyResponse tagFamily2 = (TagFamilyResponse)ClientHelper.call(() -> this.client().updateTagFamily("dummy", uuid, request));
        this.awaitEvents();
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((TagFamilyResponse)tagFamily2).matches(this.tagFamily("basic"));
            TagFamilyResponse reloadedTagFamily = (TagFamilyResponse)ClientHelper.call(() -> this.client().findTagFamilyByUuid("dummy", uuid, new ParameterProvider[0]));
            Assert.assertEquals((Object)request.getName(), (Object)reloadedTagFamily.getName());
            MeshAssertions.assertThat((TagFamilyResponse)reloadedTagFamily).matches(this.tagFamily("basic"));
        }
    }

    @Test
    public void testUpdateNodeIndex() {
        HibProject project = this.project();
        HibTagFamily tagfamily = this.tagFamily("basic");
        String tagFamilyUuid = (String)this.tx(() -> tagfamily.getUuid());
        HibBranch branch = (HibBranch)this.tx(() -> this.initialBranch());
        this.expect(MeshEvent.TAG_FAMILY_UPDATED).one();
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName("basicChanged");
        ClientHelper.call(() -> this.client().updateTagFamily("dummy", tagFamilyUuid, request));
        this.waitForSearchIdleEvent();
        this.awaitEvents();
        try (Tx tx = this.tx();){
            TagDao tagDao = tx.tagDao();
            HashSet<String> taggedNodes = new HashSet<String>();
            int storeCount = 0;
            for (HibTag tag : tagDao.findAll((HibCoreElement)tagfamily)) {
                ++storeCount;
                for (HibNode node : tagDao.getNodes(tag, branch)) {
                    if (taggedNodes.contains(node.getUuid())) continue;
                    taggedNodes.add(node.getUuid());
                    for (ContainerType containerType : Arrays.asList(ContainerType.DRAFT, ContainerType.PUBLISHED)) {
                        for (HibNodeFieldContainer fieldContainer : tx.contentDao().getFieldContainers(node, branch, containerType)) {
                            HibSchemaVersion schema = (HibSchemaVersion)node.getSchemaContainer().getLatestVersion();
                            ++storeCount;
                            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(ContentDao.composeIndexName((String)project.getUuid(), (String)branch.getUuid(), (String)schema.getUuid(), (ContainerType)containerType, null, null), ContentDao.composeDocumentId((String)node.getUuid(), (String)fieldContainer.getLanguageTag()));
                        }
                    }
                }
            }
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents((long)(storeCount + 1), 0L, 0L, 0L, 0L);
        }
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName("new Name");
        ClientHelper.call(() -> this.client().updateTagFamily("dummy", "bogus", request), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() {
        String name;
        String uuid;
        HibTagFamily tagFamily = this.tagFamily("basic");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            uuid = tagFamily.getUuid();
            name = tagFamily.getName();
            roleDao.revokePermissions(this.role(), (HibBaseElement)tagFamily, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
            request.setName("new Name");
            ClientHelper.call(() -> this.client().updateTagFamily("dummy", uuid, request), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
            Assert.assertEquals((Object)name, (Object)tagFamily.getName());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet supported")
    public void testUpdateMultithreaded() throws Exception {
        int nJobs = 5;
        TagFamilyUpdateRequest request = new TagFamilyUpdateRequest();
        request.setName("New Name");
        try (Tx tx = this.tx();){
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().updateTagFamily("dummy", this.tagFamily("colors").getUuid(), request));
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet supported")
    public void testReadByUuidMultithreaded() throws Exception {
        int nJobs = 10;
        try (Tx tx = this.tx();){
            String uuid = this.tagFamily("colors").getUuid();
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findTagFamilyByUuid("dummy", uuid, new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet supported")
    public void testDeleteByUUIDMultithreaded() throws Exception {
        int nJobs = 3;
        try (Tx tx = this.tx();){
            String uuid = this.project().getUuid();
            ClientHelper.validateDeletion(i -> this.client().deleteTagFamily("dummy", uuid), (int)nJobs);
        }
    }

    @Override
    @Test
    @Ignore(value="Not yet supported")
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 5;
        TagFamilyCreateRequest request = new TagFamilyCreateRequest();
        request.setName("test12345");
        MeshTestHelper.validateCreation(nJobs, i -> this.client().createTagFamily("dummy", request));
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws Exception {
        try (Tx tx = this.tx();){
            int nJobs = 200;
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findTagFamilyByUuid("dummy", this.tagFamily("colors").getUuid(), new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    public void testPermissionResponse() {
        TagFamilyResponse family = (TagFamilyResponse)((TagFamilyListResponse)this.client().findTagFamilies("dummy", new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)family.getPermissions()).hasNoPublishPermsSet();
    }
}

