/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.tagfamily;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.TagFamilyDao;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=false)
public class TagFamilyTest
extends AbstractMeshTest {
    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testDelete() {
        HibTagFamily tagFamily = this.tagFamily("colors");
        Long nTags = (Long)this.tx(tx -> tx.tagDao().findAll((HibCoreElement)tagFamily).count());
        int nExtraTags = 100;
        try (Tx tx2 = this.tx();){
            TagDao tagDao = tx2.tagDao();
            for (int i = 0; i < nExtraTags; ++i) {
                tagDao.create(tagFamily, "green" + i, this.project(), this.user());
            }
            tx2.success();
        }
        tx2 = this.tx();
        try {
            TagFamilyDao tagFamilyDao = tx2.tagFamilyDao();
            BulkActionContext bac = this.createBulkContext();
            tagFamilyDao.delete((HibBaseElement)tagFamily, bac);
            bac.process(true);
            tx2.success();
        }
        finally {
            if (tx2 != null) {
                tx2.close();
            }
        }
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).recordedDeleteEvents(nExtraTags + nTags.intValue() + 1);
    }
}

