/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class AnonymousAccessEndpointTest
extends AbstractMeshTest {
    @Test
    public void testAnonymousAccess() {
        this.client().logout().ignoreElement().blockingAwait();
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        Assert.assertEquals((Object)"anonymous", (Object)response.getUsername());
        MeshResponse rawResponse = (MeshResponse)this.client().me(new ParameterProvider[0]).getResponse().blockingGet();
        Assertions.assertThat((List)rawResponse.getCookies()).as("Anonymous access should not set any cookie", new Object[0]).isEmpty();
        String uuid = (String)this.db().tx(() -> this.content().getUuid());
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.anonymousRole(), (HibBaseElement)this.content(), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        this.options().getAuthenticationOptions().setEnableAnonymousAccess(false);
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
        this.options().getAuthenticationOptions().setEnableAnonymousAccess(true);
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        tx = this.tx();
        try {
            HibUser anonymousUser = (HibUser)tx.userDao().findByUuid(this.users().get("anonymous").getUuid());
            tx.groupDao().findAll().stream().forEach(g -> {
                g.setEditor(null);
                g.setCreator(null);
            });
            tx.roleDao().findAll().stream().forEach(r -> {
                r.setEditor(null);
                r.setCreator(null);
            });
            MeshElementEventModel event = anonymousUser.onDeleted();
            ((CommonTx)tx).userDao().deletePersisted((HibBaseElement)anonymousUser);
            this.mesh().vertx().eventBus().publish(MeshEvent.USER_DELETED.getAddress(), (Object)new JsonObject(JsonUtil.toJson((Object)event)));
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
    }

    @Test
    public void testReadPublishedNode() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.anonymousRole(), (HibBaseElement)this.content(), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        this.client().logout().ignoreElement().blockingAwait();
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.contentUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion("published")}));
    }
}

