/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=false)
public class AuthUserTest
extends AbstractMeshTest {
    @Test
    public void testAuthorization() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = Tx.get().userDao();
            InternalActionContext ac = this.mockActionContext();
            HibUser requestUser = ac.getUser();
            HibNode targetNode = this.folder("2015");
            Assert.assertTrue((boolean)userDao.hasPermission(requestUser, (HibBaseElement)targetNode, InternalPermission.READ_PERM));
            roleDao.revokePermissions(this.role(), (HibBaseElement)targetNode, new InternalPermission[]{InternalPermission.READ_PERM});
            Assert.assertFalse((boolean)userDao.hasPermission(requestUser, (HibBaseElement)targetNode, InternalPermission.READ_PERM));
        }
    }
}

