/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshResponse;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Single;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class AuthenticationEndpointTest
extends AbstractMeshTest {
    @Test
    public void testRestClient() throws Exception {
        try (Tx tx = this.tx();){
            HibUser user = this.user();
            String username = user.getUsername();
            String uuid = user.getUuid();
            MeshRestClient client = MeshRestClient.create((String)"localhost", (int)this.port(), (boolean)false);
            client.setLogin(username, this.data().getUserInfo().getPassword());
            Single future = client.login();
            GenericMessageResponse loginResponse = (GenericMessageResponse)future.blockingGet();
            Assert.assertNotNull((Object)loginResponse);
            Assert.assertEquals((Object)"OK", (Object)loginResponse.getMessage());
            UserResponse me = (UserResponse)this.client().me(new ParameterProvider[0]).blockingGet();
            Assert.assertNotNull((Object)me);
            Assert.assertEquals((Object)uuid, (Object)me.getUuid());
            this.disableAnonymousAccess();
            Single logoutFuture = client.logout();
            logoutFuture.blockingGet();
            ClientHelper.call(() -> client.me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
        }
    }

    @Test
    public void testDisableAnonymousAccess() {
        this.client().logout();
        UserResponse response = (UserResponse)this.client().me(new ParameterProvider[0]).toSingle().blockingGet();
        Assert.assertEquals((Object)"anonymous", (Object)response.getUsername());
        this.client().disableAnonymousAccess();
        ClientHelper.call(() -> this.client().me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
    }

    @Test
    @Ignore(value="It is currently not possible to disable users via REST.")
    public void testLoginAndDisableUser() {
        String username = (String)this.db().tx(() -> this.user().getUsername());
        MeshRestClient client = MeshRestClient.create((String)"localhost", (int)this.port(), (boolean)false);
        client.setLogin(username, this.data().getUserInfo().getPassword());
        Single future = client.login();
        GenericMessageResponse loginResponse = (GenericMessageResponse)future.blockingGet();
        Assert.assertNotNull((Object)loginResponse);
        Assert.assertEquals((Object)"OK", (Object)loginResponse.getMessage());
        try (Tx tx = this.tx();){
            HibUser user = this.user();
            user.disable();
            tx.success();
        }
        ClientHelper.call(() -> client.me(new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
    }

    @Test
    public void testAutomaticTokenRefresh() throws InterruptedException {
        try (Tx tx = this.tx();){
            HibUser user = this.user();
            String username = user.getUsername();
            MeshRestClient client = MeshRestClient.create((String)"localhost", (int)this.port(), (boolean)false);
            client.setLogin(username, this.data().getUserInfo().getPassword());
            Single future = client.login();
            GenericMessageResponse loginResponse = (GenericMessageResponse)future.blockingGet();
            Assert.assertNotNull((Object)loginResponse);
            Assert.assertEquals((Object)"OK", (Object)loginResponse.getMessage());
            String meshTokenCookie1 = ((MeshResponse)client.me(new ParameterProvider[0]).getResponse().blockingGet()).getHeader("Set-Cookie").orElse(null);
            Thread.sleep(2000L);
            String meshTokenCookie2 = ((MeshResponse)client.me(new ParameterProvider[0]).getResponse().blockingGet()).getHeader("Set-Cookie").orElse(null);
            Assert.assertNotEquals((String)"Both cookies should be different. Otherwise the token was not regenerated and the exp. date was not bumped.", (Object)meshTokenCookie1, (Object)meshTokenCookie2);
        }
    }

    @Test
    public void testBasicAuth() throws IOException {
        OkHttpClient client = this.httpClient().newBuilder().cookieJar((CookieJar)new TestCookieJar()).build();
        Response response = client.newCall(new Request.Builder().get().url(String.format("http://%s:%s/api/v2/auth/login", "localhost", this.port())).header("Authorization", "Basic " + this.base64("admin:admin")).build()).execute();
        Assertions.assertThat((int)response.code()).isEqualTo(200);
        response = client.newCall(new Request.Builder().get().url(String.format("http://%s:%s/api/v2/auth/me", "localhost", this.port())).build()).execute();
        JsonObject responseBody = new JsonObject(response.body().string());
        Assertions.assertThat((String)responseBody.getString("username")).isEqualTo((Object)"admin");
    }

    private String base64(String input) {
        return Base64.getEncoder().encodeToString(input.getBytes(StandardCharsets.UTF_8));
    }

    public static class TestCookieJar
    implements CookieJar {
        private List<Cookie> cookies;

        public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
            this.cookies = cookies;
        }

        public List<Cookie> loadForRequest(HttpUrl url) {
            if (this.cookies != null) {
                return this.cookies;
            }
            return new ArrayList<Cookie>();
        }
    }
}

