/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserResetTokenResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.UserParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Single;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.NONE, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class ForcePasswordChangeTest
extends AbstractMeshTest {
    public static final String USERNAME = "joe1";
    public static final String NEW_USERNAME = "john";
    public static final String TEMP_PASSWORD = "temppassword";
    public static final String PASSWORD = "test123";
    public static final String NEW_PASSWORD = "newpw";

    @Test
    public void testForcePasswordChange() {
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword();
        this.forcePasswordChange();
        MeshAssertions.assertThat((UserResponse)this.getUser()).hasToChangePassword();
        ClientHelper.call((Single)this.client().login(), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"auth_login_password_change_required", (String[])new String[0]);
        this.login(PASSWORD, NEW_PASSWORD);
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword();
        this.login(NEW_PASSWORD);
    }

    @Test
    public void testForcePasswordChangeNewUser() {
        UserResponse newUser = this.createUserWithForcedPasswordChange();
        MeshAssertions.assertThat((UserResponse)newUser).hasToChangePassword().hasName(NEW_USERNAME);
        this.client().logout();
        this.client().setLogin(NEW_USERNAME, PASSWORD);
        ClientHelper.call((Single)this.client().login(), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"auth_login_failed", (String[])new String[0]);
        this.loginWithUser(NEW_USERNAME, TEMP_PASSWORD, NEW_PASSWORD);
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword();
        this.loginWithUser(NEW_USERNAME, NEW_PASSWORD);
    }

    @Test
    public void testForcePasswordChangeWithLogout() {
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword();
        this.forcePasswordChange();
        MeshAssertions.assertThat((UserResponse)this.getUser()).hasToChangePassword();
        this.client().logout().blockingGet();
        MeshAssertions.assertThat((UserResponse)this.getUser()).isAnonymous();
        ClientHelper.call((Single)this.client().login(), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"auth_login_password_change_required", (String[])new String[0]);
        MeshAssertions.assertThat((UserResponse)this.getUser()).isAnonymous();
        this.login(PASSWORD, NEW_PASSWORD);
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword().hasName(USERNAME);
        this.login(NEW_PASSWORD);
    }

    @Test
    public void testPasswordChangeWithoutFlag() {
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword();
        ClientHelper.call(this.loginSingle(PASSWORD, NEW_PASSWORD), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"auth_login_newpassword_failed", (String[])new String[0]);
        ClientHelper.call(this.loginSingle(NEW_PASSWORD), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"auth_login_failed", (String[])new String[0]);
        this.login(PASSWORD);
    }

    @Test
    public void testWithResetToken() {
        this.forcePasswordChange();
        String resetToken = this.createResetToken();
        UserResponse user = this.getUser();
        this.client().logout();
        MeshAssertions.assertThat((UserResponse)this.getUser()).isAnonymous();
        this.updateUserPassword(user, resetToken);
        MeshAssertions.assertThat((UserResponse)this.getUser()).isAnonymous();
        this.login(NEW_PASSWORD);
        MeshAssertions.assertThat((UserResponse)this.getUser()).doesNotHaveToChangePassword().hasName(USERNAME);
    }

    private void updateUserPassword(UserResponse user, String resetToken) {
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword(NEW_PASSWORD);
        this.client().updateUser(user.getUuid(), request, new ParameterProvider[]{new UserParametersImpl().setToken(resetToken)}).blockingAwait();
    }

    private String createResetToken() {
        return ((UserResetTokenResponse)this.client().getUserResetToken(this.getUser().getUuid()).blockingGet()).getToken();
    }

    private Single<GenericMessageResponse> loginSingle(String password) {
        this.client().setLogin(USERNAME, password);
        return this.client().login();
    }

    private Single<GenericMessageResponse> loginSingle(String password, String newPassword) {
        this.client().setLogin(USERNAME, password, newPassword);
        return this.client().login();
    }

    private void login(String password) {
        this.loginSingle(password).blockingGet();
    }

    private void login(String password, String newPassword) {
        this.loginWithUser(USERNAME, password, newPassword);
    }

    private void loginWithUser(String username, String password) {
        this.client().setLogin(username, password);
        this.client().login().blockingGet();
    }

    private void loginWithUser(String username, String password, String newPassword) {
        this.client().setLogin(username, password, newPassword);
        this.client().login().blockingGet();
    }

    private void forcePasswordChange() {
        UserResponse user = this.getUser();
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setForcedPasswordChange(Boolean.valueOf(true));
        this.client().updateUser(user.getUuid(), updateRequest, new ParameterProvider[0]).blockingAwait();
    }

    private UserResponse getUser() {
        return (UserResponse)this.client().me(new ParameterProvider[0]).blockingGet();
    }

    private UserResponse createUserWithForcedPasswordChange() {
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(NEW_USERNAME);
        request.setPassword(TEMP_PASSWORD);
        request.setForcedPasswordChange(Boolean.valueOf(true));
        return (UserResponse)this.client().createUser(request, new ParameterProvider[0]).blockingGet();
    }
}

