/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class UserEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testReadMultiple() {
        try (Tx tx = this.tx();){
            String etag = ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]));
            ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl().setPage(2L)}), (String)etag, (boolean)true, (int)200);
        }
    }

    @Test
    public void testReadWithoutETag() {
        String etag = ClientHelper.callETagRaw(() -> this.client().findUsers(new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
        etag = ClientHelper.callETagRaw(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[]{new GenericParametersImpl().setETag(false)}));
        Assert.assertNull((String)"The etag should not have been generated.", (Object)etag);
    }

    @Test
    public void testEtagPermissionHandling() {
        String etag = ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]));
        String etag2 = ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]));
        ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
        Assert.assertEquals((Object)etag, (Object)etag2);
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.user(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
        String etag3 = ClientHelper.callETag(() -> this.client().findUsers(new ParameterProvider[0]));
        Assert.assertNotEquals((Object)etag, (Object)etag3);
    }

    @Test
    public void testReadOne() {
        String etag;
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
            etag = userDao.getETag((HibTransformableElement)this.user(), this.mockActionContext());
            ClientHelper.callETag(() -> this.client().findUserByUuid(user.getUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304);
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findUserByUuid(user.getUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)304));
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().findUserByUuid(user.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)etag, (boolean)true, (int)304));
            user.setReferencedNode(this.content());
            tx.success();
        }
        String newETag = ClientHelper.callETag(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[0]), (String)etag, (boolean)true, (int)200);
        ClientHelper.callETag(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(false)}), (String)newETag, (boolean)true, (int)304);
        ClientHelper.callETag(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true)}), (String)newETag, (boolean)true, (int)200);
    }
}

