/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MeshElementEventModelAssert;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ListResponse;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.event.MeshElementEventModel;
import com.gentics.mesh.core.rest.event.impl.MeshElementEventModelImpl;
import com.gentics.mesh.core.rest.group.GroupReference;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.user.ExpandableNode;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.core.rest.user.UserAPITokenResponse;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.core.rest.user.UserPermissionResponse;
import com.gentics.mesh.core.rest.user.UserResetTokenResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.GenericParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.RolePermissionParametersImpl;
import com.gentics.mesh.parameter.impl.UserParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.rest.client.MeshResponse;
import com.gentics.mesh.search.TrackingSearchProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.test.definition.BasicRestTestcases;
import com.gentics.mesh.util.UUIDUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class UserEndpointTest
extends AbstractMeshTest
implements BasicRestTestcases {
    @Override
    @Test
    public void testReadByUUID() throws Exception {
        String uuid = this.userUuid();
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((UserResponse)restUser).matches(this.user());
        }
    }

    @Test
    public void testReadByUUIDRaw() throws IOException {
        String uuid = this.userUuid();
        JsonObject json = this.httpGetNowJson("/api/v2/users/" + uuid, this.client().getAuthentication().getToken(), new ParameterProvider[]{new GenericParametersImpl().setFields(new String[]{"uuid"})});
        Assert.assertEquals((Object)uuid, (Object)json.getString("uuid"));
        Assert.assertFalse((boolean)json.containsKey("lastname"));
        Assert.assertFalse((boolean)json.containsKey("firstname"));
        Assert.assertFalse((boolean)json.containsKey("username"));
    }

    @Test
    public void testUpdateUsingExpiredToken() {
        String uuid = this.userUuid();
        String oldHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertNull((String)"Initially the token code should be null", this.tx(() -> this.user().getResetToken()));
        Assert.assertNull((String)"Initially the token issue timestamp should be null", this.tx(() -> this.user().getResetTokenIssueTimestamp()));
        UserResetTokenResponse response = (UserResetTokenResponse)ClientHelper.call(() -> this.client().getUserResetToken(uuid));
        Assert.assertNotNull((String)"The user token code should now be set to a non-null value but it was not.", this.tx(() -> ((UserResetTokenResponse)response).getToken()));
        Assert.assertNotNull((String)"The token code issue timestamp should be set.", this.tx(() -> ((UserResetTokenResponse)response).getCreated()));
        this.tx(tx -> {
            HibUser user1 = (HibUser)tx.userDao().findByUuid(uuid);
            user1.setResetTokenIssueTimestamp(Long.valueOf(System.currentTimeMillis() - 3600000L));
            return (HibUser)((CommonTx)tx.unwrap()).userDao().mergeIntoPersisted((HibBaseElement)user1);
        });
        this.client().logout().blockingGet();
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword("newPass");
        ClientHelper.call(() -> this.client().updateUser(uuid, request, new ParameterProvider[]{new UserParametersImpl(response.getToken())}), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"user_error_provided_token_invalid", (String[])new String[0]);
        String newHash = (String)this.tx(tx -> ((HibUser)tx.userDao().findByUuid(uuid)).getPasswordHash());
        Assert.assertEquals((String)"The password hash has not been updated.", (Object)oldHash, (Object)newHash);
        Assert.assertNull((String)"The token code should have been set to null since it has expired.", this.tx(() -> this.user().getResetToken()));
        Assert.assertNull((String)"The token issue timestamp should have been set to null since it has expired", this.tx(() -> this.user().getResetTokenIssueTimestamp()));
    }

    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testUpdateUsingToken() {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        String oldHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertNull((String)"Initially the token code should have been set to null", this.tx(() -> this.user().getResetToken()));
        UserResetTokenResponse response = (UserResetTokenResponse)ClientHelper.call(() -> this.client().getUserResetToken(uuid));
        Assert.assertNotNull((String)"The user token code should now be set to a non-null value but it was not", this.tx(() -> this.user().getResetToken()));
        this.client().logout().blockingGet();
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.user(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
        });
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword("newPass");
        ClientHelper.call(() -> this.client().updateUser(uuid, request, new ParameterProvider[]{new UserParametersImpl(response.getToken())}));
        HibUser updatedUser = (HibUser)this.tx(tx -> (HibUser)tx.userDao().findByUuid(uuid));
        String newHash = (String)this.tx(() -> ((HibUser)updatedUser).getPasswordHash());
        Assert.assertNull((String)"The token code should have been set to null since it is now used up", this.tx(() -> ((HibUser)updatedUser).getResetToken()));
        Assert.assertNotEquals((String)"The password hash has not been updated.", (Object)oldHash, (Object)newHash);
    }

    @Test
    @Ignore(value="Fails on CI pipeline. See https://github.com/gentics/mesh/issues/608")
    public void testUpdateUsingTokenWithoutLogout() {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        String oldHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertNull((String)"Initially the token code should have been set to null", this.tx(() -> this.user().getResetToken()));
        UserResetTokenResponse response = (UserResetTokenResponse)ClientHelper.call(() -> this.client().getUserResetToken(uuid));
        Assert.assertNotNull((String)"The user token code should now be set to a non-null value but it was not", this.tx(() -> this.user().getResetToken()));
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.user(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
        });
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword("newPass");
        ClientHelper.call(() -> this.client().updateUser(uuid, request, new ParameterProvider[]{new UserParametersImpl(response.getToken())}));
        String newHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertNull((String)"The token code should have been set to null since it is now used up", this.tx(() -> this.user().getResetToken()));
        Assert.assertNotEquals((String)"The password hash has not been updated.", (Object)oldHash, (Object)newHash);
    }

    @Test
    public void testUpdateUsingBogusToken() {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        String oldHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertNull((String)"Initially the token code should have been set to null", this.tx(() -> this.user().getResetToken()));
        ClientHelper.call(() -> this.client().getUserResetToken(uuid));
        this.client().logout().blockingGet();
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword("newPass");
        ClientHelper.call(() -> this.client().updateUser(uuid, request, new ParameterProvider[]{new UserParametersImpl("bogusToken")}), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"user_error_provided_token_invalid", (String[])new String[0]);
        String newHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertEquals((String)"The password hash should not have been updated.", (Object)oldHash, (Object)newHash);
    }

    @Test
    public void testUpdateWithNoToken() {
        this.disableAnonymousAccess();
        String uuid = (String)this.tx(() -> this.user().getUuid());
        String oldHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertNull((String)"Initially the token code should have been set to null", this.tx(() -> this.user().getResetToken()));
        ClientHelper.call(() -> this.client().getUserResetToken(uuid));
        this.client().logout().blockingGet();
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword("newPass");
        ClientHelper.call(() -> this.client().updateUser(uuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
        String newHash = (String)this.tx(() -> this.user().getPasswordHash());
        Assert.assertEquals((String)"The password hash should not have been updated.", (Object)oldHash, (Object)newHash);
    }

    @Test
    public void testFetchUserToken() {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        UserResetTokenResponse response = (UserResetTokenResponse)ClientHelper.call(() -> this.client().getUserResetToken(uuid));
        MeshAssertions.assertThat((String)response.getToken()).isNotEmpty();
        String storedToken = (String)this.tx(tx -> ((HibUser)tx.userDao().findByUuid(uuid)).getResetToken());
        Assert.assertEquals((String)"The token that is currently stored did not match up with the returned token by the API", (Object)storedToken, (Object)response.getToken());
    }

    @Test
    public void testAPIToken() {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        MeshResponse completeResponse = (MeshResponse)this.client().issueAPIToken(uuid).getResponse().blockingGet();
        MeshAssertions.assertThat((Optional)completeResponse.getHeader("Cache-Control")).hasValue((Object)"private");
        UserAPITokenResponse response = (UserAPITokenResponse)completeResponse.getBody();
        Assert.assertNull((String)"The key was previously not issued.", (Object)response.getPreviousIssueDate());
        MeshAssertions.assertThat((String)response.getToken()).isNotEmpty();
        Assert.assertNotNull(this.tx(tx -> ((HibUser)tx.userDao().findByUuid(uuid)).getAPIKeyTokenCode()));
        this.client().setLogin(null, null);
        this.client().setAPIKey(response.getToken());
        MeshRequest userRequest = this.client().findUserByUuid(uuid, new ParameterProvider[0]);
        MeshResponse userResponse = (MeshResponse)userRequest.getResponse().blockingGet();
        MeshAssertions.assertThat((List)userResponse.getCookies()).as("Requests using the api key should not yield a new cookie", new Object[0]).isEmpty();
        String oldKey = response.getToken();
        response = (UserAPITokenResponse)ClientHelper.call(() -> this.client().issueAPIToken(uuid));
        Assert.assertNotEquals((String)"Each key should be unique.", (Object)oldKey, (Object)response.getToken());
        Assert.assertNotNull((String)"The key was already requested once. Thus the date should be set.", (Object)response.getPreviousIssueDate());
        ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
        this.client().setAPIKey(response.getToken());
        ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().invalidateAPIToken(uuid));
        Assert.assertNull(this.tx(tx -> ((HibUser)tx.userDao().findByUuid(uuid)).getAPIKeyTokenCode()));
        Assert.assertNull(this.tx(tx -> ((HibUser)tx.userDao().findByUuid(uuid)).getAPITokenIssueTimestamp()));
        ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)"error_not_authorized", (String[])new String[0]);
    }

    @Test
    public void testIssueAPIKeyWithoutPerm() {
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.user(), new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        });
        ClientHelper.call(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().issueAPIToken(this.userUuid()), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.userUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testRevokeAPIKeyWithoutPerm() {
        String uuid = this.userUuid();
        ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().issueAPIToken(uuid));
        this.tx(tx -> {
            RoleDao roleDao = tx.roleDao();
            HibUser user = this.user();
            roleDao.revokePermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        });
        ClientHelper.call(() -> this.client().invalidateAPIToken(uuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadPermissions() {
        String pathToElement;
        HibTagFamily tagFamily;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            this.data().addTagFamilies();
            tagFamily = this.data().getTagFamily("colors");
            roleDao.grantPermissions(this.role(), (HibBaseElement)tagFamily, InternalPermission.values());
            roleDao.grantPermissions(this.role(), (HibBaseElement)tagFamily, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(this.role(), InternalPermission.UPDATE_PERM, (HibBaseElement)tagFamily));
            pathToElement = "projects/" + this.project().getUuid() + "/tagFamilies/" + tagFamily.getUuid();
            tx.success();
        }
        String userUuid = (String)this.tx(() -> this.user().getUuid());
        UserPermissionResponse response = (UserPermissionResponse)ClientHelper.call(() -> this.client().readUserPermissions(userUuid, pathToElement));
        Assert.assertNotNull((Object)response);
        MeshAssertions.assertThat((PermissionInfo)response).hasPerm(Permission.basicPermissions());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)tagFamily, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.UPDATE_PERM, (HibBaseElement)tagFamily));
            tx.success();
        }
        UserPermissionResponse permissionResponse = (UserPermissionResponse)ClientHelper.call(() -> this.client().readUserPermissions(userUuid, pathToElement));
        Assert.assertNotNull((Object)permissionResponse);
        MeshAssertions.assertThat((PermissionInfo)permissionResponse).hasPerm(new Permission[]{Permission.READ, Permission.CREATE, Permission.DELETE});
    }

    @Override
    @Test
    public void testReadByUuidWithRolePerms() {
        UserResponse userResponse = (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[]{new RolePermissionParametersImpl().setRoleUuid(this.roleUuid())}));
        Assert.assertNotNull((Object)userResponse.getRolePerms());
        MeshAssertions.assertThat((PermissionInfo)userResponse.getRolePerms()).hasPerm(new Permission[]{Permission.READ, Permission.CREATE, Permission.UPDATE, Permission.DELETE});
    }

    @Test
    public void testReadUserWithMultipleGroups() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            UserDao userDao = tx.userDao();
            HibUser user = this.user();
            Assert.assertEquals((long)1L, (long)userDao.getGroups(user).count());
            for (int i = 0; i < 10; ++i) {
                HibGroup extraGroup = groupDao.create("group_" + i, this.user());
                tx.groupDao().addUser(extraGroup, this.user());
            }
            Assert.assertEquals((long)11L, (long)userDao.getGroups(this.user()).count());
            tx.success();
        }
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[0]));
        Assert.assertEquals((long)11L, (long)response.getGroups().size());
    }

    @Override
    @Test
    public void testReadByUuidMultithreaded() throws InterruptedException {
        try (Tx tx = this.tx();){
            int nJobs = 10;
            MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[0]));
        }
    }

    @Override
    @Test
    public void testReadByUuidMultithreadedNonBlocking() throws InterruptedException {
        int nJobs = 200;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[0]));
    }

    @Override
    @Test
    public void testReadByUUIDWithMissingPermission() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibUser user = this.user();
            Assert.assertNotNull((String)"The username of the user must not be null.", (Object)user.getUsername());
            roleDao.revokePermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().findUserByUuid(this.userUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.userUuid(), InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testCreateAdmin() {
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername("test1234");
        request.setAdmin(Boolean.valueOf(true));
        request.setPassword("finger");
        UserResponse response = (UserResponse)this.adminCall(() -> this.client().createUser(request, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)response).isAdmin();
        request.setUsername("test4321");
        ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"user_error_admin_privilege_needed_for_admin_flag", (String[])new String[0]);
    }

    @Test
    public void testUpdateAdmin() {
        UserCreateRequest createRequest = new UserCreateRequest();
        createRequest.setUsername("test1234");
        createRequest.setAdmin(Boolean.valueOf(false));
        createRequest.setPassword("finger");
        UserResponse response = (UserResponse)this.adminCall(() -> this.client().createUser(createRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)response).isNotAdmin();
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setAdmin(Boolean.valueOf(true));
        UserResponse response2 = (UserResponse)this.adminCall(() -> this.client().updateUser(response.getUuid(), updateRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)response2).isAdmin();
        updateRequest.setAdmin(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateUser(response.getUuid(), updateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"user_error_admin_privilege_needed_for_admin_flag", (String[])new String[0]);
    }

    @Test
    public void testCreateAdminUserAsNonAdmin() {
        UserCreateRequest createRequest = new UserCreateRequest();
        createRequest.setUsername("test1234");
        createRequest.setAdmin(Boolean.valueOf(true));
        createRequest.setPassword("finger");
        this.runAsNonAdmin(() -> ClientHelper.call(() -> this.client().createUser(createRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"user_error_admin_privilege_needed_for_admin_flag", (String[])new String[0]));
    }

    @Test
    public void testCreateNonAdminUserAsNonAdmin() {
        UserCreateRequest createRequest = new UserCreateRequest();
        createRequest.setUsername("test1234");
        createRequest.setAdmin(Boolean.valueOf(false));
        createRequest.setPassword("finger");
        UserResponse response = (UserResponse)this.nonAdminCall(() -> this.client().createUser(createRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)response).isNotAdmin();
    }

    @Override
    @Test
    public void testReadMultiple() throws Exception {
        long foundUsers;
        int intialUserCount = this.users().size();
        int nUsers = 20;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            GroupDao groupDao = tx.groupDao();
            for (int i = 0; i < 20; ++i) {
                String username = "testuser_" + i;
                HibUser user = userDao.create(username, this.user());
                groupDao.addUser(this.group(), user);
                user.setLastname("should_be_listed");
                user.setFirstname("should_be_listed");
                user.setEmailAddress("should_be_listed");
                roleDao.grantPermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.READ_PERM});
            }
            HibUser invisibleUser = userDao.create("should_not_be_listed", this.user());
            invisibleUser.setLastname("should_not_be_listed");
            invisibleUser.setFirstname("should_not_be_listed");
            invisibleUser.setEmailAddress("should_not_be_listed");
            userDao.addGroup(invisibleUser, this.group());
            foundUsers = userDao.count();
            tx.success();
        }
        Assert.assertEquals((String)"We did not find the expected count of users attached to the user root vertex.", (long)(intialUserCount + 20 + 1), (long)foundUsers);
        ListResponse restResponse = (ListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[0]));
        Assert.assertNull((Object)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((long)1L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((long)(intialUserCount + 20), (long)restResponse.getMetainfo().getTotalCount());
        Assert.assertEquals((long)(intialUserCount + 20), (long)restResponse.getData().size());
        long perPage = 2L;
        int totalUsers = intialUserCount + 20;
        int totalPages = (int)Math.ceil((double)totalUsers / (double)perPage);
        long currentPerPage = 2L;
        restResponse = (ListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(3, Long.valueOf(2L))}));
        Assert.assertEquals((String)"The page did not contain the expected amount of items", (long)perPage, (long)restResponse.getData().size());
        Assert.assertEquals((String)"We did not find the expected page in the list response.", (long)3L, (long)restResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)("The amount of pages did not match. We have {" + totalUsers + "} users in the system and use a paging of {2}"), (long)totalPages, (long)restResponse.getMetainfo().getPageCount());
        Assert.assertEquals((long)2L, (long)restResponse.getMetainfo().getPerPage());
        Assert.assertEquals((String)"The total amount of items does not match the expected one", (long)totalUsers, (long)restResponse.getMetainfo().getTotalCount());
        perPage = 11L;
        ArrayList allUsers = new ArrayList();
        for (int page = 1; page < totalPages; ++page) {
            restResponse = (ListResponse)this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(page, Long.valueOf(perPage))}).blockingGet();
            allUsers.addAll(restResponse.getData());
        }
        Assert.assertEquals((String)"Somehow not all users were loaded when loading all pages.", (long)totalUsers, (long)allUsers.size());
        String extra3Username = "should_not_be_listed";
        List filteredUserList = allUsers.parallelStream().filter(restUser -> restUser.getUsername().equals("should_not_be_listed")).collect(Collectors.toList());
        Assert.assertTrue((String)"User 3 should not be part of the list since no permissions were added.", (filteredUserList.size() == 0 ? 1 : 0) != 0);
        ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(-1L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_pagesize_parameter", (String[])new String[]{"-1"});
        UserListResponse listResponse = (UserListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(4242, Long.valueOf(25L))}));
        Assert.assertEquals((String)"The result list should not contain any item since the page parameter is out of bounds", (long)0L, (long)listResponse.getData().size());
        Assert.assertEquals((String)"The requested page should be set in the response but it was not", (long)4242L, (long)listResponse.getMetainfo().getCurrentPage());
        Assert.assertEquals((String)"The page count value was not correct.", (long)1L, (long)listResponse.getMetainfo().getPageCount());
        Assert.assertEquals((String)"We did not find the correct total count value in the response", (long)(20 + intialUserCount), (long)listResponse.getMetainfo().getTotalCount());
        Assert.assertEquals((long)25L, (long)listResponse.getMetainfo().getPerPage());
        listResponse = (UserListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(4242)}));
        Assert.assertNull((Object)listResponse.getMetainfo().getPerPage());
        this.verifySorting(param -> (ListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{param})), UserResponse::getUsername, "username", "List of usernames");
    }

    @Test
    public void testInvalidPageParameter() {
        UserListResponse list = (UserListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(1, Long.valueOf(0L))}));
        Assert.assertEquals((long)0L, (long)list.getData().size());
        Assert.assertTrue((list.getMetainfo().getTotalCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidPageParameter2() {
        ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl(-1, Long.valueOf(25L))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_page_parameter_must_be_positive", (String[])new String[]{"-1"});
    }

    @Override
    @Test
    public void testUpdateMultithreaded() throws InterruptedException {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setEmailAddress("t.stark@stark-industries.com");
        updateRequest.setFirstname("Tony Awesome");
        updateRequest.setLastname("Epic Stark");
        int nJobs = 50;
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().updateUser(uuid, updateRequest, new ParameterProvider[0]));
    }

    @Override
    @Test
    public void testUpdate() throws Exception {
        String oldName = (String)this.tx(() -> this.user().getUsername());
        String newName = "dummy_user_changed";
        String uuid = (String)this.tx(() -> this.user().getUuid());
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setEmailAddress("t.stark@stark-industries.com");
        updateRequest.setFirstname("Tony Awesome");
        updateRequest.setLastname("Epic Stark");
        updateRequest.setUsername(newName);
        this.expect(MeshEvent.USER_UPDATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName(newName)).hasUuid(uuid)).total(1L);
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(uuid, updateRequest, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibUser.composeIndexName(), uuid);
        MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
        this.trackingSearchProvider().clear().blockingAwait();
        try (Tx tx = this.tx();){
            MeshAssertions.assertThat((UserResponse)restUser).matches(updateRequest);
            Assert.assertNull((String)"The user node should have been updated and thus no user should be found.", (Object)tx.userDao().findByUsername(oldName));
            HibUser reloadedUser = tx.userDao().findByUsername(newName);
            Assert.assertNotNull((Object)reloadedUser);
            Assert.assertEquals((Object)"Epic Stark", (Object)reloadedUser.getLastname());
            Assert.assertEquals((Object)"Tony Awesome", (Object)reloadedUser.getFirstname());
            Assert.assertEquals((Object)"t.stark@stark-industries.com", (Object)reloadedUser.getEmailAddress());
            Assert.assertEquals((Object)newName, (Object)reloadedUser.getUsername());
        }
    }

    @Test
    public void testUpdateWithSpecialCharacters() throws Exception {
        String uuid = (String)this.tx(() -> this.user().getUuid());
        String oldUsername = (String)this.tx(() -> this.user().getUsername());
        int c = 9829;
        String email = "t.stark@st\u00e4rk-industries.com\u2665";
        String firstname = "T\u00f6ny Awes\u00f6me\u2665";
        String lastname = "Epic St\u00e4rk\u2665";
        String username = "dummy_us\u00e4r_ch\u00e4nged\u2665";
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setEmailAddress(email);
        updateRequest.setFirstname(firstname);
        updateRequest.setLastname(lastname);
        updateRequest.setUsername(username);
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(uuid, updateRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)restUser).matches(updateRequest);
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertNull((String)"The user node should have been updated and thus no user should be found.", (Object)userDao.findByUsername(oldUsername));
            HibUser reloadedUser = userDao.findByUsername(username);
            Assert.assertNotNull((Object)reloadedUser);
            Assert.assertEquals((Object)lastname, (Object)reloadedUser.getLastname());
            Assert.assertEquals((Object)firstname, (Object)reloadedUser.getFirstname());
            Assert.assertEquals((Object)email, (Object)reloadedUser.getEmailAddress());
            Assert.assertEquals((Object)username, (Object)reloadedUser.getUsername());
        }
    }

    @Override
    @Test
    public void testUpdateWithBogusUuid() throws GenericRestException, Exception {
        UserUpdateRequest request = new UserUpdateRequest();
        request.setUsername("New Name");
        ClientHelper.call(() -> this.client().updateUser("bogus", request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_illegal_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testUpdateUserAndSetNodeReference() throws Exception {
        String nodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        String userUuid = this.userUuid();
        HibUser user = this.user();
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        String username = (String)this.tx(() -> user.getUsername());
        try (Tx tx = this.tx();){
            updateRequest.setEmailAddress("t.stark@stark-industries.com");
            updateRequest.setFirstname("Tony Awesome");
            updateRequest.setLastname("Epic Stark");
            updateRequest.setUsername("dummy_user_changed");
        }
        NodeReference userNodeReference = new NodeReference();
        userNodeReference.setProjectName("dummy");
        userNodeReference.setUuid(nodeUuid);
        updateRequest.setNodeReference((ExpandableNode)userNodeReference);
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(userUuid, updateRequest, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertNotNull((Object)((HibUser)tx.userDao().findByUuid(this.user().getUuid())).getReferencedNode());
            Assert.assertNotNull((Object)restUser.getNodeReference());
            Assert.assertEquals((Object)"dummy", (Object)((NodeReference)restUser.getNodeReference()).getProjectName());
            Assert.assertEquals((Object)nodeUuid, (Object)restUser.getNodeReference().getUuid());
            MeshAssertions.assertThat((UserResponse)restUser).matches(updateRequest);
            Assert.assertNull((String)"The user node should have been updated and thus no user should be found.", (Object)userDao.findByUsername(username));
            HibUser reloadedUser = userDao.findByUsername("dummy_user_changed");
            Assert.assertNotNull((Object)reloadedUser);
            Assert.assertEquals((Object)"Epic Stark", (Object)reloadedUser.getLastname());
            Assert.assertEquals((Object)"Tony Awesome", (Object)reloadedUser.getFirstname());
            Assert.assertEquals((Object)"t.stark@stark-industries.com", (Object)reloadedUser.getEmailAddress());
            Assert.assertEquals((Object)"dummy_user_changed", (Object)reloadedUser.getUsername());
            Assert.assertEquals((Object)nodeUuid, (Object)reloadedUser.getReferencedNode().getUuid());
        }
    }

    @Test
    public void testUpdateNodeReferenceTwice() throws Exception {
        String nodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        String nodeUuid2 = (String)this.tx(() -> this.folder("2015").getUuid());
        String userUuid = this.userUuid();
        HibUser user = this.user();
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        String username = (String)this.tx(() -> user.getUsername());
        try (Tx tx = this.tx();){
            updateRequest.setEmailAddress("t.stark@stark-industries.com");
            updateRequest.setFirstname("Tony Awesome");
            updateRequest.setLastname("Epic Stark");
            updateRequest.setUsername("dummy_user_changed");
        }
        NodeReference userNodeReference = new NodeReference();
        userNodeReference.setProjectName("dummy");
        userNodeReference.setUuid(nodeUuid2);
        updateRequest.setNodeReference((ExpandableNode)userNodeReference);
        ClientHelper.call(() -> this.client().updateUser(userUuid, updateRequest, new ParameterProvider[0]));
        userNodeReference.setUuid(nodeUuid);
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(userUuid, updateRequest, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertNotNull((Object)((HibUser)tx.userDao().findByUuid(this.user().getUuid())).getReferencedNode());
            Assert.assertNotNull((Object)restUser.getNodeReference());
            Assert.assertEquals((Object)"dummy", (Object)((NodeReference)restUser.getNodeReference()).getProjectName());
            Assert.assertEquals((Object)nodeUuid, (Object)restUser.getNodeReference().getUuid());
            MeshAssertions.assertThat((UserResponse)restUser).matches(updateRequest);
            Assert.assertNull((String)"The user node should have been updated and thus no user should be found.", (Object)userDao.findByUsername(username));
            HibUser reloadedUser = userDao.findByUsername("dummy_user_changed");
            Assert.assertNotNull((Object)reloadedUser);
            Assert.assertEquals((Object)"Epic Stark", (Object)reloadedUser.getLastname());
            Assert.assertEquals((Object)"Tony Awesome", (Object)reloadedUser.getFirstname());
            Assert.assertEquals((Object)"t.stark@stark-industries.com", (Object)reloadedUser.getEmailAddress());
            Assert.assertEquals((Object)"dummy_user_changed", (Object)reloadedUser.getUsername());
            Assert.assertEquals((Object)nodeUuid, (Object)reloadedUser.getReferencedNode().getUuid());
        }
    }

    @Test
    public void testUpdateUserAndSetNodeReferenceWithoutProjectName() throws Exception {
        String nodeUuid = (String)this.tx(() -> this.folder("news").getUuid());
        String userUuid = this.userUuid();
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        try (Tx tx = this.tx();){
            updateRequest.setEmailAddress("t.stark@stark-industries.com");
            updateRequest.setFirstname("Tony Awesome");
            updateRequest.setLastname("Epic Stark");
            updateRequest.setUsername("dummy_user_changed");
        }
        NodeReference userNodeReference = new NodeReference();
        userNodeReference.setUuid(nodeUuid);
        updateRequest.setNodeReference((ExpandableNode)userNodeReference);
        ClientHelper.call(() -> this.client().updateUser(userUuid, updateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"user_incomplete_node_reference", (String[])new String[0]);
    }

    @Test
    public void testCreateUser() throws Exception {
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setUsername("new_user");
        newUser.setGroupUuid(this.groupUuid());
        newUser.setPassword("test1234");
        this.expect(MeshEvent.USER_CREATED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("new_user")).uuidNotNull());
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]));
        this.awaitEvents();
        Assert.assertEquals((Object)"new_user", (Object)response.getUsername());
        Assert.assertNotNull((Object)response.getUuid());
        MeshAssertions.assertThat((List)response.getGroups()).hasSize(1);
        Assert.assertEquals((Object)this.groupUuid(), (Object)((GroupReference)response.getGroups().get(0)).getUuid());
    }

    @Test
    public void testCreateUserWithNodeReference() {
        String nodeUuid;
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibNode node = this.folder("news");
            nodeUuid = node.getUuid();
            Assert.assertTrue((boolean)userDao.hasPermission(this.user(), (HibBaseElement)node, InternalPermission.READ_PERM));
            tx.success();
        }
        NodeReference reference = new NodeReference();
        reference.setProjectName("dummy");
        reference.setUuid(nodeUuid);
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setUsername("new_user");
        newUser.setGroupUuid(this.groupUuid());
        newUser.setPassword("test1234");
        newUser.setNodeReference((ExpandableNode)reference);
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]));
        Assert.assertTrue((boolean)response.isReference());
        Assert.assertNotNull((Object)response.getNodeReference());
        Assert.assertNotNull((Object)response.getReferencedNodeReference().getProjectName());
        Assert.assertNotNull((Object)response.getNodeReference().getUuid());
    }

    @Test
    public void testReadUserListWithExpandedNodeReference() {
        UserResponse userCreateResponse = (UserResponse)this.tx(() -> {
            HibNode node = this.folder("news");
            NodeReference reference = new NodeReference();
            reference.setUuid(node.getUuid());
            reference.setProjectName("dummy");
            UserCreateRequest newUser = new UserCreateRequest();
            newUser.setUsername("new_user");
            newUser.setGroupUuid(this.group().getUuid());
            newUser.setPassword("test1234");
            newUser.setNodeReference((ExpandableNode)reference);
            UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]));
            return response;
        });
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            UserListResponse userResponse = (UserListResponse)ClientHelper.call(() -> this.client().findUsers(new ParameterProvider[]{new PagingParametersImpl().setPerPage(Long.valueOf(100L)), new NodeParametersImpl().setExpandedFieldNames(new String[]{"nodeReference"}).setLanguages(new String[]{"en"})}));
            Assert.assertNotNull((Object)userResponse);
            UserResponse foundUser = userResponse.getData().stream().filter(u -> u.getUuid().equals(userCreateResponse.getUuid())).findFirst().get();
            Assert.assertNotNull((Object)foundUser.getNodeReference());
            Assert.assertEquals((Object)node.getUuid(), (Object)foundUser.getNodeReference().getUuid());
            Assert.assertEquals(NodeResponse.class, foundUser.getNodeReference().getClass());
        }
    }

    @Test
    public void testReadUserWithExpandedNodeReference() {
        UserCreateRequest newUser;
        String folderUuid;
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            folderUuid = node.getUuid();
            NodeReference reference = new NodeReference();
            reference.setUuid(node.getUuid());
            reference.setProjectName("dummy");
            UserCreateRequest request = new UserCreateRequest();
            request.setUsername("new_user");
            request.setGroupUuid(this.group().getUuid());
            request.setPassword("test1234");
            request.setNodeReference((ExpandableNode)reference);
            newUser = request;
        }
        UserResponse userResponse = (UserResponse)ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]));
        UserResponse userResponse2 = (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(userResponse.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandedFieldNames(new String[]{"nodeReference"}).setLanguages(new String[]{"en"})}));
        Assert.assertNotNull((Object)userResponse2);
        Assert.assertNotNull((Object)userResponse2.getNodeReference());
        Assert.assertEquals((Object)folderUuid, (Object)userResponse2.getNodeReference().getUuid());
        Assert.assertEquals(NodeResponse.class, userResponse2.getNodeReference().getClass());
    }

    @Test
    public void testCreateUserWithBogusProjectNameInNodeReference() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            NodeReference reference = new NodeReference();
            reference.setProjectName("bogus_name");
            reference.setUuid(node.getUuid());
            UserCreateRequest newUser = new UserCreateRequest();
            newUser.setUsername("new_user");
            newUser.setGroupUuid(this.group().getUuid());
            newUser.setPassword("test1234");
            newUser.setNodeReference((ExpandableNode)reference);
            ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"project_not_found", (String[])new String[]{"bogus_name"});
        }
    }

    @Test
    public void testCreateUserWithBogusUuidInNodeReference() {
        try (Tx tx = this.tx();){
            NodeReference reference = new NodeReference();
            reference.setProjectName("dummy");
            reference.setUuid("bogus_uuid");
            UserCreateRequest newUser = new UserCreateRequest();
            newUser.setUsername("new_user");
            newUser.setGroupUuid(this.group().getUuid());
            newUser.setPassword("test1234");
            newUser.setNodeReference((ExpandableNode)reference);
            ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus_uuid"});
        }
    }

    @Test
    public void testCreateUserWithMissingProjectNameInNodeReference() {
        try (Tx tx = this.tx();){
            NodeReference reference = new NodeReference();
            reference.setUuid("bogus_uuid");
            UserCreateRequest newUser = new UserCreateRequest();
            newUser.setUsername("new_user");
            newUser.setGroupUuid(this.group().getUuid());
            newUser.setPassword("test1234");
            newUser.setNodeReference((ExpandableNode)reference);
            ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"user_creation_full_node_reference_not_implemented", (String[])new String[0]);
        }
    }

    @Test
    public void testCreateUserWithMissingUuidNameInNodeReference() {
        try (Tx tx = this.tx();){
            NodeReference reference = new NodeReference();
            reference.setProjectName("dummy");
            UserCreateRequest newUser = new UserCreateRequest();
            newUser.setUsername("new_user");
            newUser.setGroupUuid(this.group().getUuid());
            newUser.setPassword("test1234");
            newUser.setNodeReference((ExpandableNode)reference);
            ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"user_incomplete_node_reference", (String[])new String[0]);
        }
    }

    @Test
    public void testUpdatePasswordWithNoOldPassword() {
        String oldHash;
        String uuid;
        try (Tx tx = this.tx();){
            tx.userDao().updatePasswordHash(this.user(), null);
            uuid = this.user().getUuid();
            oldHash = this.user().getPasswordHash();
        }
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setPassword("new_password");
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(uuid, updateRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)restUser).matches(updateRequest);
        try (Tx tx = this.tx();){
            HibUser reloadedUser = (HibUser)tx.userDao().findByUuid(uuid);
            Assert.assertNotEquals((String)"The hash should be different and thus the password updated.", (Object)oldHash, (Object)reloadedUser.getPasswordHash());
        }
    }

    @Test
    public void testUpdatePassword() throws JsonGenerationException, JsonMappingException, IOException, Exception {
        String oldHash;
        String uuid;
        String username;
        try (Tx tx = this.tx();){
            HibUser user = this.user();
            username = user.getUsername();
            uuid = user.getUuid();
            oldHash = user.getPasswordHash();
        }
        UserUpdateRequest updateRequest = new UserUpdateRequest();
        updateRequest.setPassword("new_password");
        updateRequest.setOldPassword("test123");
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(uuid, updateRequest, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)restUser).matches(updateRequest);
        try (Tx tx = this.tx();){
            HibUser reloadedUser = tx.userDao().findByUsername(username);
            Assert.assertNotEquals((String)"The hash should be different and thus the password updated.", (Object)oldHash, (Object)reloadedUser.getPasswordHash());
        }
    }

    @Test
    public void testUpdatePasswordWithNoPermission() throws JsonGenerationException, JsonMappingException, IOException, Exception {
        String oldHash;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibUser user = this.user();
            oldHash = user.getPasswordHash();
            roleDao.revokePermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        UserUpdateRequest request = new UserUpdateRequest();
        request.setPassword("new_password");
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.userUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        try (Tx tx = this.tx();){
            HibUser reloadedUser = (HibUser)tx.userDao().findByUuid(this.userUuid());
            Assert.assertTrue((String)"The hash should not be updated.", (boolean)oldHash.equals(reloadedUser.getPasswordHash()));
        }
    }

    @Override
    @Test
    public void testUpdateByUUIDWithoutPerm() throws Exception {
        String oldHash;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibUser user = this.user();
            oldHash = user.getPasswordHash();
            roleDao.revokePermissions(this.role(), (HibBaseElement)user, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        UserUpdateRequest updatedUser = new UserUpdateRequest();
        updatedUser.setEmailAddress("n.user@spam.gentics.com");
        updatedUser.setFirstname("Joe");
        updatedUser.setLastname("Doe");
        updatedUser.setUsername("new_user");
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), updatedUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{this.userUuid(), InternalPermission.UPDATE_PERM.getRestPerm().getName()});
        try (Tx tx = this.tx();){
            HibUser reloadedUser = (HibUser)tx.userDao().findByUuid(this.userUuid());
            Assert.assertTrue((String)"The hash should not be updated.", (boolean)oldHash.equals(reloadedUser.getPasswordHash()));
            Assert.assertEquals((String)"The firstname should not be updated.", (Object)this.user().getFirstname(), (Object)reloadedUser.getFirstname());
            Assert.assertEquals((String)"The firstname should not be updated.", (Object)this.user().getLastname(), (Object)reloadedUser.getLastname());
        }
    }

    @Test
    public void testUpdateUserWithConflictingUsername() throws Exception {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("existing_username", this.user());
            userDao.addGroup(user, this.group());
            tx.success();
        }
        UserUpdateRequest request = new UserUpdateRequest();
        request.setUsername("existing_username");
        ClientHelper.call(() -> this.client().updateUser(this.userUuid(), request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"user_conflicting_username", (String[])new String[0]);
    }

    @Test
    public void testUpdateUserWithSameUsername() throws Exception {
        try (Tx tx = this.tx();){
            UserUpdateRequest request = new UserUpdateRequest();
            request.setUsername(this.user().getUsername());
            ClientHelper.call(() -> this.client().updateUser(this.userUuid(), request, new ParameterProvider[0]));
        }
    }

    @Test
    public void testCreateUserWithConflictingUsername() throws Exception {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("existing_username", this.user());
            userDao.addGroup(user, this.group());
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.group(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setUsername("existing_username");
        newUser.setGroupUuid(this.groupUuid());
        newUser.setPassword("test1234");
        ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"user_conflicting_username", (String[])new String[0]);
    }

    @Test
    public void testCreateUserWithNoPassword() throws Exception {
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setEmailAddress("n.user@spam.gentics.com");
        newUser.setFirstname("Joe");
        newUser.setLastname("Doe");
        newUser.setUsername("new_user_test123");
        newUser.setGroupUuid(this.groupUuid());
        ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"user_missing_password", (String[])new String[0]);
    }

    @Test
    public void testCreateUserWithNoUsername() throws Exception {
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setEmailAddress("n.user@spam.gentics.com");
        newUser.setFirstname("Joe");
        newUser.setLastname("Doe");
        newUser.setPassword("test123456");
        ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"user_missing_username", (String[])new String[0]);
    }

    @Test
    public void testCreateUserWithNoParentGroup() throws Exception {
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setEmailAddress("n.user@spam.gentics.com");
        newUser.setFirstname("Joe");
        newUser.setLastname("Doe");
        newUser.setUsername("new_user");
        newUser.setPassword("test123456");
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]));
        Assert.assertEquals((long)0L, (long)response.getGroups().size());
    }

    @Test
    public void testCreateUserWithBogusParentGroup() throws Exception {
        UserCreateRequest newUser = new UserCreateRequest();
        newUser.setEmailAddress("n.user@spam.gentics.com");
        newUser.setFirstname("Joe");
        newUser.setLastname("Doe");
        newUser.setUsername("new_user");
        newUser.setPassword("test123456");
        newUser.setGroupUuid("bogus");
        ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"bogus"});
    }

    @Test
    public void testCreateUpdate() {
        try (Tx tx = this.tx();){
            UserCreateRequest request = new UserCreateRequest();
            request.setEmailAddress("n.user@spam.gentics.com");
            request.setUsername("new_user");
            request.setPassword("test123456");
            request.setGroupUuid(this.group().getUuid());
            UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
            MeshAssertions.assertThat((UserResponse)restUser).matches(request);
            UserUpdateRequest updateRequest = new UserUpdateRequest();
            String LASTNAME = "Epic Stark";
            String FIRSTNAME = "Tony Awesome";
            String USERNAME = "dummy_user_changed";
            String EMAIL = "t.stark@stark-industries.com";
            updateRequest.setEmailAddress("t.stark@stark-industries.com");
            updateRequest.setFirstname("Tony Awesome");
            updateRequest.setLastname("Epic Stark");
            updateRequest.setUsername("dummy_user_changed");
            updateRequest.setPassword("newPassword");
            updateRequest.setOldPassword("test123456");
            String uuid = restUser.getUuid();
            restUser = (UserResponse)ClientHelper.call(() -> this.client().updateUser(uuid, updateRequest, new ParameterProvider[0]));
            Assert.assertEquals((Object)"Epic Stark", (Object)restUser.getLastname());
            Assert.assertEquals((Object)"Tony Awesome", (Object)restUser.getFirstname());
            Assert.assertEquals((Object)"t.stark@stark-industries.com", (Object)restUser.getEmailAddress());
            Assert.assertEquals((Object)"dummy_user_changed", (Object)restUser.getUsername());
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        String groupUuid = (String)this.tx(() -> this.group().getUuid());
        UserCreateRequest request = new UserCreateRequest();
        request.setEmailAddress("n.user@spam.gentics.com");
        request.setFirstname("Joe");
        request.setLastname("Doe");
        request.setUsername("new_user");
        request.setPassword("test123456");
        request.setGroupUuid(groupUuid);
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        try (Tx tx2 = this.tx();){
            MeshAssertions.assertThat((UserResponse)restUser).matches(request);
            HibUser user = (HibUser)tx2.userDao().findByUuid(restUser.getUuid());
            MeshAssertions.assertThat((UserResponse)restUser).matches(user);
        }
    }

    @Override
    @Test
    public void testCreateWithNoPerm() throws Exception {
        UserCreateRequest request = new UserCreateRequest();
        request.setEmailAddress("n.user@spam.gentics.com");
        request.setFirstname("Joe");
        request.setLastname("Doe");
        request.setUsername("new_user");
        request.setPassword("test123456");
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), tx.data().permissionRoots().user(), new InternalPermission[]{InternalPermission.CREATE_PERM});
            tx.success();
        }
        String userRootUuid = (String)this.tx(() -> Tx.get().data().permissionRoots().user().getUuid());
        ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{userRootUuid, InternalPermission.CREATE_PERM.getRestPerm().getName()});
    }

    @Override
    @Test
    public void testCreateWithUuid() throws Exception {
        String groupUuid = this.groupUuid();
        UserCreateRequest request = new UserCreateRequest();
        request.setEmailAddress("n.user@spam.gentics.com");
        request.setFirstname("Joe");
        request.setLastname("Doe");
        request.setUsername("new_user");
        request.setPassword("test123456");
        request.setGroupUuid(groupUuid);
        String uuid = UUIDUtil.randomUUID();
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().createUser(uuid, request, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)restUser).matches(request).hasUuid(uuid);
    }

    @Override
    @Test
    @Ignore(value="Not valid over dup UUIDs being allowed globally")
    public void testCreateWithDuplicateUuid() throws Exception {
        String groupUuid = this.groupUuid();
        UserCreateRequest request = new UserCreateRequest();
        request.setEmailAddress("n.user@spam.gentics.com");
        request.setFirstname("Joe");
        request.setLastname("Doe");
        request.setUsername("new_user");
        request.setPassword("test123456");
        request.setGroupUuid(groupUuid);
        String uuid = this.projectUuid();
        ClientHelper.call(() -> this.client().createUser(uuid, request, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"error_internal", (String[])new String[0]);
    }

    @Override
    @Test
    public void testPermissionResponse() {
        UserResponse user = (UserResponse)((UserListResponse)this.client().findUsers(new ParameterProvider[0]).blockingGet()).getData().get(0);
        MeshAssertions.assertThat((PermissionInfo)user.getPermissions()).hasNoPublishPermsSet();
    }

    @Override
    @Test
    @Ignore(value="not yet supported")
    public void testCreateMultithreaded() throws Exception {
        int nJobs = 5;
        MeshTestHelper.validateCreation(nJobs, i -> {
            UserCreateRequest request = new UserCreateRequest();
            request.setEmailAddress("n.user@spam.gentics.com");
            request.setFirstname("Joe");
            request.setLastname("Doe");
            request.setUsername("new_user_" + i);
            request.setPassword("test123456");
            request.setGroupUuid(this.group().getUuid());
            return this.client().createUser(request, new ParameterProvider[0]);
        });
    }

    @Override
    @Test
    public void testCreateReadDelete() throws Exception {
        String groupUuid = (String)this.tx(() -> this.group().getUuid());
        UserCreateRequest request = new UserCreateRequest();
        request.setEmailAddress("n.user@spam.gentics.com");
        request.setFirstname("Joe");
        request.setLastname("Doe");
        request.setUsername("new_user");
        request.setPassword("test123456");
        request.setGroupUuid(groupUuid);
        UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().createUser(request, new ParameterProvider[0]));
        MeshAssertions.assertThat((UserResponse)restUser).matches(request);
        ClientHelper.call(() -> this.client().findUserByUuid(restUser.getUuid(), new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteUser(restUser.getUuid()));
    }

    @Test
    @Ignore(value="this can't be tested using the rest client")
    public void testCreateUserWithBogusJson() throws Exception {
    }

    @Override
    @Test
    public void testDeleteByUUID() throws Exception {
        try (Tx tx = this.tx();){
            this.waitForSearchIdleEvent();
            this.trackingSearchProvider().reset();
            UserCreateRequest newUser = new UserCreateRequest();
            newUser.setEmailAddress("n.user@spam.gentics.com");
            newUser.setFirstname("Joe");
            newUser.setLastname("Doe");
            newUser.setUsername("new_user");
            newUser.setPassword("test123456");
            newUser.setGroupUuid(this.group().getUuid());
            UserResponse restUser = (UserResponse)ClientHelper.call(() -> this.client().createUser(newUser, new ParameterProvider[0]));
            this.waitForSearchIdleEvent();
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasStore(HibUser.composeIndexName(), restUser.getUuid());
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(1L, 0L, 0L, 0L, 0L);
            this.trackingSearchProvider().reset();
            Assert.assertTrue((boolean)restUser.getEnabled());
            String uuid = restUser.getUuid();
            this.expect(MeshEvent.USER_DELETED).match(1, MeshElementEventModelImpl.class, event -> ((MeshElementEventModelAssert)MeshAssertions.assertThat((MeshElementEventModel)event).hasName("new_user")).hasUuid(uuid));
            ClientHelper.call(() -> this.client().deleteUser(uuid));
            this.awaitEvents();
            this.waitForSearchIdleEvent();
            try (Tx tx2 = this.tx();){
                HibUser loadedUser = (HibUser)tx2.userDao().findByUuid(uuid);
                Assert.assertNull((String)"The user should have been deleted.", (Object)loadedUser);
            }
            ClientHelper.call(() -> this.client().findUserByUuid(uuid, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{uuid});
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasDelete(HibUser.composeIndexName(), uuid);
            MeshAssertions.assertThat((TrackingSearchProvider)this.trackingSearchProvider()).hasEvents(0L, 0L, 1L, 0L, 0L);
        }
    }

    @Override
    @Test
    @Ignore(value="not yet supported")
    public void testDeleteByUUIDMultithreaded() throws InterruptedException {
        int nJobs = 3;
        String uuid = this.user().getUuid();
        ClientHelper.validateDeletion(i -> this.client().deleteUser(uuid), (int)nJobs);
    }

    @Override
    @Test
    public void testDeleteByUUIDWithNoPermission() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("extraUser", this.user());
            userDao.addGroup(user, this.group());
            uuid = user.getUuid();
            Assert.assertNotNull((Object)uuid);
            HibRole role = (HibRole)this.tx(() -> (HibRole)tx.roleDao().findByUuid(this.role().getUuid()));
            roleDao.grantPermissions(role, (HibBaseElement)user, new InternalPermission[]{InternalPermission.UPDATE_PERM, InternalPermission.CREATE_PERM, InternalPermission.READ_PERM});
            tx.success();
        }
        tx = this.tx();
        try {
            ClientHelper.call(() -> this.client().deleteUser(uuid), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.DELETE_PERM.getRestPerm().getName()});
            Assert.assertNotNull((String)"The user should not have been deleted", (Object)tx.userDao().findByUuid(uuid));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testDeleteWithUuidNull() throws Exception {
        ClientHelper.call(() -> this.client().deleteUser(null), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"object_not_found_for_uuid", (String[])new String[]{"null"});
    }

    @Test
    @Ignore
    public void testReadOwnCreatedUser() {
    }

    @Test
    public void testDeleteByUUID2() throws Exception {
        String uuid;
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            HibRole role = (HibRole)roleDao.findByUuid(this.role().getUuid());
            String name = "extraUser";
            HibUser extraUser = userDao.create(name, this.user());
            userDao.addGroup(extraUser, this.group());
            uuid = extraUser.getUuid();
            roleDao.grantPermissions(role, (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.DELETE_PERM});
            Assert.assertTrue((boolean)roleDao.hasPermission(role, InternalPermission.DELETE_PERM, (HibBaseElement)extraUser));
            HibUser user = (HibUser)userDao.findByUuid(uuid);
            Assert.assertEquals((long)1L, (long)userDao.getGroups(user).count());
            Assert.assertTrue((String)"The user should be enabled", (boolean)user.isEnabled());
            tx.success();
        }
        ClientHelper.call(() -> this.client().deleteUser(uuid));
        tx = this.tx();
        try {
            Assert.assertNull((String)"The user was not deleted.", (Object)tx.userDao().findByUuid(uuid));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    @Ignore(value="Not yet implemented")
    public void testDeleteOwnUser() {
    }

    @Test
    public void testLocationHeader() {
        String name = "someUser";
        UserCreateRequest request = new UserCreateRequest();
        request.setUsername(name);
        request.setPassword("bla");
        MeshResponse response = (MeshResponse)this.client().createUser(request, new ParameterProvider[0]).getResponse().blockingGet();
        try (Tx tx = this.tx();){
            HibUser user = tx.userDao().findByUsername(name);
            Assert.assertNotNull((String)"User should have been created.", (Object)user);
            Assert.assertEquals((long)HttpResponseStatus.CREATED.code(), (long)response.getStatusCode());
            String location = response.getHeader(HttpHeaders.LOCATION.toString()).orElse(null);
            Assert.assertEquals((String)"Location header value did not match", (Object)("http://localhost:" + this.port() + "/api/v2/users/" + user.getUuid()), (Object)location);
        }
    }

    @Test
    public void testLocationWithHostHeader() {
        String name = "someUser";
        UserCreateRequest userRequest = new UserCreateRequest();
        userRequest.setUsername(name);
        userRequest.setPassword("bla");
        MeshRequest request = this.client().createUser(userRequest, new ParameterProvider[0]);
        request.setHeader(HttpHeaders.HOST.toString(), "jotschi.de:" + this.port());
        MeshResponse response = (MeshResponse)request.getResponse().blockingGet();
        try (Tx tx = this.tx();){
            HibUser user = tx.userDao().findByUsername(name);
            Assert.assertNotNull((String)"User should have been created.", (Object)user);
            Assert.assertEquals((long)HttpResponseStatus.CREATED.code(), (long)response.getStatusCode());
            String location = response.getHeader(HttpHeaders.LOCATION.toString()).orElse(null);
            Assert.assertEquals((String)"Location header value did not match", (Object)("http://jotschi.de:" + this.port() + "/api/v2/users/" + user.getUuid()), (Object)location);
        }
    }

    @Test
    public void testUserRolesHash() {
        UserResponse response = (UserResponse)ClientHelper.call(() -> this.client().findUserByUuid(this.user().getUuid(), new ParameterProvider[0]));
        Assert.assertTrue((String)"Roles hash should be in response", (!StringUtils.isBlank((CharSequence)response.getRolesHash()) ? 1 : 0) != 0);
    }
}

