/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.user.ExpandableNode;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.core.rest.user.UserReference;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.rest.ClientSchemaStorage;
import com.gentics.mesh.util.UUIDUtil;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class UserRestTest {
    @Test
    public void testUserJson() throws JsonParseException, JsonMappingException, IOException {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("content");
        ClientSchemaStorage clientSchemaStorage = new ClientSchemaStorage();
        clientSchemaStorage.addSchema((SchemaVersionModel)schema);
        UserResponse response = new UserResponse();
        response.setCreator(new UserReference().setFirstName("Joe").setLastName("Doe").setUuid(UUIDUtil.randomUUID()));
        NodeResponse nodeResponse = new NodeResponse();
        nodeResponse.setUuid(UUIDUtil.randomUUID());
        nodeResponse.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        response.setNodeResponse(nodeResponse);
        String json = response.toJson();
        Assert.assertNotNull((Object)json);
        UserResponse deserializedResponse = (UserResponse)JsonUtil.readValue((String)json, UserResponse.class);
        Assert.assertNotNull((Object)deserializedResponse);
        Assert.assertNotNull((String)"The node reference field could not be found.", (Object)deserializedResponse.getNodeReference());
        Assert.assertEquals(NodeResponse.class, deserializedResponse.getNodeReference().getClass());
        Assert.assertEquals((Object)nodeResponse.getUuid(), (Object)deserializedResponse.getNodeReference().getUuid());
        NodeReference reference = new NodeReference();
        reference.setUuid(UUIDUtil.randomUUID());
        reference.setProjectName("project123");
        reference.setDisplayName("123");
        response.setNodeReference((ExpandableNode)reference);
        json = response.toJson();
        Assert.assertNotNull((Object)json);
        deserializedResponse = (UserResponse)JsonUtil.readValue((String)json, UserResponse.class);
        Assert.assertNotNull((Object)deserializedResponse);
        Assert.assertNotNull((String)"The node reference field could not be found.", (Object)deserializedResponse.getNodeReference());
        Assert.assertEquals((Object)reference.getUuid(), (Object)deserializedResponse.getNodeReference().getUuid());
        Assert.assertEquals(NodeReference.class, deserializedResponse.getNodeReference().getClass());
    }
}

