/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.GroupDao;
import com.gentics.mesh.core.data.dao.PersistingGroupDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.group.HibGroup;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.role.HibRole;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.data.user.MeshAuthUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.Permission;
import com.gentics.mesh.core.rest.common.PermissionInfo;
import com.gentics.mesh.core.rest.user.UserReference;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import com.google.common.collect.Iterables;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class UserTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Test
    public void testCreatedUser() {
        try (Tx tx = this.tx();){
            Assert.assertNotNull((String)"The uuid of the user should not be null since the entity was reloaded.", (Object)this.user().getUuid());
        }
    }

    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibUser user = this.user();
            UserReference reference = user.transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)user.getUuid(), (Object)reference.getUuid());
            Assert.assertEquals((Object)user.getFirstname(), (Object)reference.getFirstName());
            Assert.assertEquals((Object)user.getLastname(), (Object)reference.getLastName());
        }
    }

    @Test
    public void testLoadPrincipalWithoutTx() {
        MeshAuthUser user = (MeshAuthUser)this.tx(() -> this.getRequestMeshAuthUser());
        JsonObject json = user.principal();
        Assert.assertNotNull((Object)json);
        Assert.assertEquals((Object)this.userUuid(), (Object)json.getString("uuid"));
        Assert.assertEquals(this.tx(() -> user.getDelegate().getEmailAddress()), (Object)json.getString("emailAddress"));
        Assert.assertEquals(this.tx(() -> user.getDelegate().getLastname()), (Object)json.getString("lastname"));
        Assert.assertEquals(this.tx(() -> user.getDelegate().getFirstname()), (Object)json.getString("firstname"));
        Assert.assertEquals(this.tx(() -> user.getDelegate().getUsername()), (Object)json.getString("username"));
        JsonArray roles = json.getJsonArray("roles");
        for (int i = 0; i < roles.size(); ++i) {
            JsonObject role = roles.getJsonObject(i);
            Assert.assertNotNull((Object)role.getString("uuid"));
            Assert.assertNotNull((Object)role.getString("name"));
        }
        Assert.assertEquals((String)"The principal should contain two roles.", (long)1L, (long)roles.size());
        JsonArray groups = json.getJsonArray("groups");
        for (int i = 0; i < roles.size(); ++i) {
            JsonObject group = groups.getJsonObject(i);
            Assert.assertNotNull((Object)group.getString("uuid"));
            Assert.assertNotNull((Object)group.getString("name"));
        }
        Assert.assertEquals((String)"The principal should contain two groups.", (long)1L, (long)groups.size());
    }

    @Test
    public void testETag() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            InternalActionContext ac = this.mockActionContext();
            String eTag = userDao.getETag((HibTransformableElement)this.user(), ac);
            System.out.println(eTag);
        }
    }

    @Override
    @Test
    public void testRootNode() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            int nUserBefore = Iterables.size((Iterable)userDao.findAll());
            Assert.assertNotNull((Object)userDao.create("dummy12345", this.user()));
            int nUserAfter = Iterables.size((Iterable)userDao.findAll());
            Assert.assertEquals((String)"The root node should now list one more user", (long)(nUserBefore + 1), (long)nUserAfter);
        }
    }

    @Test
    public void testHasPermission() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = this.user();
            long start = System.currentTimeMillis();
            int nChecks = 9000;
            int runs = 90;
            HibNode content = this.content();
            for (int e = 0; e < runs; ++e) {
                for (int i = 0; i < nChecks; ++i) {
                    Assert.assertTrue((boolean)userDao.hasPermission(user, (HibBaseElement)content, InternalPermission.READ_PERM));
                }
            }
            long duration = System.currentTimeMillis() - start;
            System.out.println("Duration: " + duration);
            System.out.println("Duration per check: \t" + (double)duration / (double)(nChecks * runs));
        }
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            UserDao userDao = tx.userDao();
            Page page = userDao.findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(6L)));
            Assert.assertEquals((long)this.users().size(), (long)page.getTotalElements());
            Assert.assertEquals((long)this.users().size(), (long)page.getSize());
            page = userDao.findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(15L)));
            Assert.assertEquals((long)this.users().size(), (long)page.getTotalElements());
            Assert.assertEquals((long)this.users().size(), (long)page.getSize());
        }
    }

    @Override
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            Page page = tx.userDao().findAll(this.mockActionContext(), (PagingParameters)new PagingParametersImpl(1, Long.valueOf(25L)));
            Assert.assertNotNull((Object)page);
            Assert.assertEquals((long)this.users().size(), (long)page.getTotalElements());
        }
    }

    @Test
    public void testGetPrincipal() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            RoutingContext rc = this.mockRoutingContext();
            User user = rc.user();
            Assert.assertNotNull((Object)user);
            JsonObject json = user.principal();
            Assert.assertNotNull((Object)json);
            try (Tx tx2 = this.tx();){
                Assert.assertEquals((Object)this.user().getUuid(), (Object)json.getString("uuid"));
                Assert.assertEquals((Object)this.user().getUsername(), (Object)json.getString("username"));
                Assert.assertEquals((Object)this.user().getFirstname(), (Object)json.getString("firstname"));
                Assert.assertEquals((Object)this.user().getLastname(), (Object)json.getString("lastname"));
                Assert.assertEquals((Object)this.user().getEmailAddress(), (Object)json.getString("emailAddress"));
                Assert.assertNotNull((Object)json.getJsonArray("roles"));
                Assert.assertEquals((long)TestUtils.size((Iterable)userDao.getRoles(this.user())), (long)json.getJsonArray("roles").size());
                Assert.assertNotNull((Object)json.getJsonArray("groups"));
                Assert.assertEquals((long)userDao.getGroups(this.user()).count(), (long)json.getJsonArray("groups").size());
            }
        }
    }

    @Test
    public void testGetPermissions() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Permission[] perms = new Permission[]{Permission.CREATE, Permission.UPDATE, Permission.DELETE, Permission.READ, Permission.READ_PUBLISHED, Permission.PUBLISH};
            long start = System.currentTimeMillis();
            int nChecks = 10000;
            for (int i = 0; i < nChecks; ++i) {
                PermissionInfo loadedPermInfo = userDao.getPermissionInfo(this.user(), (HibBaseElement)this.content());
                MeshAssertions.assertThat((PermissionInfo)loadedPermInfo).hasPerm(perms);
            }
            System.out.println("Duration: " + (System.currentTimeMillis() - start));
            System.out.println("Duration per Check: " + (double)(System.currentTimeMillis() - start) / (double)nChecks);
        }
    }

    @Test
    public void testFindUsersOfGroup() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            RoleDao roleDao = tx.roleDao();
            PersistingGroupDao groupDao = ((CommonTx)tx.unwrap()).groupDao();
            HibUser extraUser = userDao.create("extraUser", this.user());
            groupDao.addUser(this.group(), extraUser);
            groupDao.mergeIntoPersisted((HibBaseElement)this.group());
            roleDao.grantPermissions(this.role(), (HibBaseElement)extraUser, new InternalPermission[]{InternalPermission.READ_PERM});
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            HibUser requestUser = ac.getUser();
            Page userPage = groupDao.getVisibleUsers(this.group(), requestUser, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(10L)));
            Assert.assertEquals((long)2L, (long)userPage.getTotalElements());
        }
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertNull((Object)userDao.findByUsername("bogus"));
            userDao.findByUsername(this.user().getUsername());
        }
    }

    @Override
    @Test
    public void testFindByUUID() throws Exception {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            String uuid = this.user().getUuid();
            HibUser foundUser = (HibUser)userDao.findByUuid(uuid);
            Assert.assertNotNull((Object)foundUser);
            Assert.assertEquals((Object)uuid, (Object)foundUser.getUuid());
        }
    }

    @Override
    @Test
    public void testTransformation() throws Exception {
        try (Tx tx = this.tx();){
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            UserDao userDao = tx.userDao();
            UserResponse restUser = (UserResponse)userDao.transformToRestSync((Object)this.user(), (InternalActionContext)ac, 0, new String[0]);
            Assert.assertNotNull((Object)restUser);
            Assert.assertEquals((Object)this.user().getUsername(), (Object)restUser.getUsername());
            Assert.assertEquals((Object)this.user().getUuid(), (Object)restUser.getUuid());
            Assert.assertEquals((Object)this.user().getLastname(), (Object)restUser.getLastname());
            Assert.assertEquals((Object)this.user().getFirstname(), (Object)restUser.getFirstname());
            Assert.assertEquals((Object)this.user().getEmailAddress(), (Object)restUser.getEmailAddress());
            Assert.assertEquals((long)1L, (long)restUser.getGroups().size());
        }
    }

    @Override
    @Test
    public void testCreateDelete() throws Exception {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("Anton", this.user());
            Assert.assertTrue((boolean)user.isEnabled());
            Assert.assertNotNull((Object)user);
            String uuid = user.getUuid();
            BulkActionContext bac = this.createBulkContext();
            userDao.delete((HibBaseElement)user, bac);
            HibUser foundUser = (HibUser)userDao.findByUuid(uuid);
            Assert.assertNull((Object)foundUser);
        }
    }

    @Override
    @Test
    public void testCRUDPermissions() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = this.user();
            HibUser newUser = userDao.create("Anton", this.user());
            Assert.assertFalse((boolean)userDao.hasPermission(user, (HibBaseElement)newUser, InternalPermission.CREATE_PERM));
            userDao.inheritRolePermissions(user, tx.data().permissionRoots().user(), (HibBaseElement)newUser);
            Assert.assertTrue((boolean)userDao.hasPermission(user, (HibBaseElement)newUser, InternalPermission.CREATE_PERM));
        }
    }

    @Test
    public void testInheritPermissions() {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            GroupDao groupDao = tx.groupDao();
            HibNode sourceNode = this.folder("news");
            HibNode targetNode = this.folder("2015");
            InternalActionContext ac = this.mockActionContext();
            HibGroup newGroup = groupDao.create("extraGroup", this.user());
            HibUser newUser = userDao.create("Anton", this.user());
            groupDao.addUser(newGroup, newUser);
            HibRole roleWithDeletePerm = roleDao.create("roleWithDeletePerm", newUser);
            groupDao.addRole(newGroup, roleWithDeletePerm);
            roleDao.grantPermissions(roleWithDeletePerm, (HibBaseElement)sourceNode, new InternalPermission[]{InternalPermission.DELETE_PERM});
            HibRole roleWithReadPerm = roleDao.create("roleWithReadPerm", newUser);
            groupDao.addRole(newGroup, roleWithReadPerm);
            roleDao.grantPermissions(roleWithReadPerm, (HibBaseElement)sourceNode, new InternalPermission[]{InternalPermission.READ_PERM});
            HibRole roleWithUpdatePerm = roleDao.create("roleWithUpdatePerm", newUser);
            groupDao.addRole(newGroup, roleWithUpdatePerm);
            roleDao.grantPermissions(roleWithUpdatePerm, (HibBaseElement)sourceNode, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            HibRole roleWithAllPerm = roleDao.create("roleWithAllPerm", newUser);
            groupDao.addRole(newGroup, roleWithAllPerm);
            roleDao.grantPermissions(roleWithAllPerm, (HibBaseElement)sourceNode, new InternalPermission[]{InternalPermission.CREATE_PERM, InternalPermission.UPDATE_PERM, InternalPermission.DELETE_PERM, InternalPermission.READ_PERM, InternalPermission.READ_PUBLISHED_PERM, InternalPermission.PUBLISH_PERM});
            HibRole roleWithCreatePerm = roleDao.create("roleWithCreatePerm", newUser);
            groupDao.addRole(newGroup, roleWithCreatePerm);
            roleDao.grantPermissions(roleWithCreatePerm, (HibBaseElement)sourceNode, new InternalPermission[]{InternalPermission.CREATE_PERM});
            HibRole roleWithNoPerm = roleDao.create("roleWithNoPerm", newUser);
            groupDao.addRole(newGroup, roleWithNoPerm);
            userDao.inheritRolePermissions(this.user(), (HibBaseElement)sourceNode, (HibBaseElement)targetNode);
            ac.data().clear();
            for (InternalPermission perm : InternalPermission.values()) {
                Assert.assertTrue((String)("The new user should have all permissions to CRUD the target node since he is member of a group that has been assigned to roles with various permissions that cover CRUD. Failed for permission {" + perm.name() + "}"), (boolean)userDao.hasPermission(newUser, (HibBaseElement)targetNode, perm));
            }
            for (InternalPermission perm : InternalPermission.values()) {
                Assert.assertTrue((String)("The role should grant all permissions to the target node. Failed for permission {" + perm.name() + "}"), (boolean)roleDao.hasPermission(roleWithAllPerm, perm, (HibBaseElement)targetNode));
            }
            for (InternalPermission perm : InternalPermission.values()) {
                Assert.assertFalse((String)("No extra permissions should be assigned to the role that did not have any permissions on the source element. Failed for permission {" + perm.name() + "}"), (boolean)roleDao.hasPermission(roleWithNoPerm, perm, (HibBaseElement)targetNode));
            }
            Assert.assertFalse((String)"The role should only have delete permissions on the object", (boolean)roleDao.hasPermission(roleWithDeletePerm, InternalPermission.CREATE_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have delete permissions on the object", (boolean)roleDao.hasPermission(roleWithDeletePerm, InternalPermission.READ_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have delete permissions on the object", (boolean)roleDao.hasPermission(roleWithDeletePerm, InternalPermission.UPDATE_PERM, (HibBaseElement)targetNode));
            Assert.assertTrue((String)"The role should only have delete permissions on the object", (boolean)roleDao.hasPermission(roleWithDeletePerm, InternalPermission.DELETE_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have read permissions on the object", (boolean)roleDao.hasPermission(roleWithReadPerm, InternalPermission.CREATE_PERM, (HibBaseElement)targetNode));
            Assert.assertTrue((String)"The role should only have read permissions on the object", (boolean)roleDao.hasPermission(roleWithReadPerm, InternalPermission.READ_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have read permissions on the object", (boolean)roleDao.hasPermission(roleWithReadPerm, InternalPermission.UPDATE_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have read permissions on the object", (boolean)roleDao.hasPermission(roleWithReadPerm, InternalPermission.DELETE_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have update permissions on the object", (boolean)roleDao.hasPermission(roleWithUpdatePerm, InternalPermission.CREATE_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have update permissions on the object", (boolean)roleDao.hasPermission(roleWithUpdatePerm, InternalPermission.READ_PERM, (HibBaseElement)targetNode));
            Assert.assertTrue((String)"The role should only have update permissions on the object", (boolean)roleDao.hasPermission(roleWithUpdatePerm, InternalPermission.UPDATE_PERM, (HibBaseElement)targetNode));
            Assert.assertFalse((String)"The role should only have update permissions on the object", (boolean)roleDao.hasPermission(roleWithUpdatePerm, InternalPermission.DELETE_PERM, (HibBaseElement)targetNode));
        }
    }

    @Override
    @Test
    public void testRead() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = this.user();
            Assert.assertEquals((Object)"joe1", (Object)user.getUsername());
            Assert.assertNotNull((Object)user.getPasswordHash());
            Assert.assertEquals((Object)"Joe", (Object)user.getFirstname());
            Assert.assertEquals((Object)"Doe", (Object)user.getLastname());
            Assert.assertEquals((Object)"j.doe@spam.gentics.com", (Object)user.getEmailAddress());
            Assert.assertNotNull((Object)user.getLastEditedTimestamp());
            Assert.assertNotNull((Object)user.getCreator());
            Assert.assertNotNull((Object)user.getEditor());
            Assert.assertNotNull((Object)user.getCreationTimestamp());
            Assert.assertEquals((long)1L, (long)userDao.getGroups(user).count());
            Assert.assertNotNull((Object)user);
        }
    }

    @Test
    public void testUserGroup() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            UserDao userDao = tx.userDao();
            HibUser user = this.user();
            Assert.assertEquals((long)1L, (long)userDao.getGroups(user).count());
            for (int i = 0; i < 10; ++i) {
                HibGroup extraGroup = groupDao.create("group_" + i, this.user());
                groupDao.addUser(extraGroup, user);
                groupDao.addUser(extraGroup, user);
                groupDao.addUser(extraGroup, user);
                groupDao.addUser(extraGroup, user);
            }
            Assert.assertEquals((long)11L, (long)userDao.getGroups(this.user()).count());
        }
    }

    @Override
    @Test
    public void testCreate() throws Exception {
        try (Tx tx = this.tx();){
            String USERNAME = "test";
            String EMAIL = "joe@nowhere.org";
            String FIRSTNAME = "joe";
            String LASTNAME = "doe";
            String PASSWDHASH = "RANDOM";
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("test", this.user());
            user.setEmailAddress("joe@nowhere.org");
            user.setFirstname("joe");
            user.setLastname("doe");
            tx.userDao().updatePasswordHash(user, "RANDOM");
            Assert.assertTrue((boolean)user.isEnabled());
            HibUser reloadedUser = (HibUser)userDao.findByUuid(user.getUuid());
            Assert.assertEquals((String)"The username did not match.", (Object)"test", (Object)reloadedUser.getUsername());
            Assert.assertEquals((String)"The lastname did not match.", (Object)"doe", (Object)reloadedUser.getLastname());
            Assert.assertEquals((String)"The firstname did not match.", (Object)"joe", (Object)reloadedUser.getFirstname());
            Assert.assertEquals((String)"The email address did not match.", (Object)"joe@nowhere.org", (Object)reloadedUser.getEmailAddress());
            Assert.assertEquals((String)"The password did not match.", (Object)"RANDOM", (Object)reloadedUser.getPasswordHash());
        }
    }

    @Override
    @Test
    public void testDelete() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = (HibUser)userDao.findByUuid(this.user().getUuid());
            Assert.assertEquals((long)1L, (long)userDao.getGroups(user).count());
            Assert.assertTrue((boolean)user.isEnabled());
            BulkActionContext bac = this.createBulkContext();
            HibUser userToDelete = userDao.create("username", user);
            HibUser foundUser = (HibUser)userDao.findByUuid(userToDelete.getUuid());
            Assert.assertNotNull((Object)foundUser);
            userDao.delete((HibBaseElement)userToDelete, bac);
            foundUser = (HibUser)userDao.findByUuid(userToDelete.getUuid());
            Assert.assertNull((Object)foundUser);
        }
    }

    @Test
    public void testOwnRolePerm() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertTrue((String)"The user should have update permissions on his role", (boolean)userDao.hasPermission(this.user(), (HibBaseElement)this.role(), InternalPermission.UPDATE_PERM));
        }
    }

    @Override
    @Test
    public void testUpdate() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser newUser = userDao.create("newUser", this.user());
            HibUser user = this.user();
            user.setEmailAddress("changed");
            Assert.assertEquals((Object)"changed", (Object)user.getEmailAddress());
            user.setFirstname("changed_firstname");
            Assert.assertEquals((Object)"changed_firstname", (Object)user.getFirstname());
            user.setLastname("changed_lastname");
            Assert.assertEquals((Object)"changed_lastname", (Object)user.getLastname());
            user.setEditor(newUser);
            Assert.assertNotNull((Object)user.getEditor());
            Assert.assertEquals((Object)newUser.getUuid(), (Object)user.getEditor().getUuid());
            user.setLastEditedTimestamp(1L);
            Assert.assertEquals((long)1L, (long)user.getLastEditedTimestamp());
            user.setCreator(newUser);
            Assert.assertNotNull((Object)user.getCreator());
            Assert.assertEquals((Object)newUser.getUuid(), (Object)user.getCreator().getUuid());
            user.setCreationTimestamp(0L);
            Assert.assertEquals((long)0L, (long)user.getCreationTimestamp());
            Assert.assertTrue((boolean)user.isEnabled());
            user.disable();
            Assert.assertFalse((boolean)user.isEnabled());
            Assert.assertNotNull((Object)user.getPasswordHash());
        }
    }

    @Override
    @Test
    public void testReadPermission() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("Anton", this.user());
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)user);
        }
    }

    @Override
    @Test
    public void testDeletePermission() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("Anton", this.user());
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)user);
        }
    }

    @Override
    @Test
    public void testUpdatePermission() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("Anton", this.user());
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)user);
        }
    }

    @Override
    @Test
    public void testCreatePermission() {
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            HibUser user = userDao.create("Anton", this.user());
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)user);
        }
    }

    @Test
    public void testUserRolesHashes() {
        try (Tx tx = this.tx();){
            GroupDao groupDao = tx.groupDao();
            UserDao userDao = tx.userDao();
            HibUser oldUser = this.user();
            HibUser newUser = userDao.create("newuser", oldUser);
            HibGroup newGroup = groupDao.create("newgroup", oldUser);
            groupDao.getRoles(this.group()).forEach(role -> groupDao.addRole(newGroup, role));
            groupDao.addUser(newGroup, newUser);
            Assert.assertEquals((Object)userDao.getRolesHash(oldUser), (Object)userDao.getRolesHash(newUser));
            String hash = userDao.getRolesHash(oldUser);
            this.grantAdmin();
            oldUser = (HibUser)userDao.findByUuid(oldUser.getUuid());
            newUser = (HibUser)userDao.findByUuid(newUser.getUuid());
            Assert.assertNotEquals((Object)hash, (Object)userDao.getRolesHash(oldUser));
            Assert.assertEquals((Object)hash, (Object)userDao.getRolesHash(newUser));
        }
    }
}

