/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.user;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.user.UserCreateRequest;
import com.gentics.mesh.core.rest.user.UserListResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import java.util.List;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class UsernameEnumerationTest
extends AbstractMeshTest {
    @Before
    public void setUp() throws Exception {
        this.client().logout().blockingGet();
    }

    @Test
    public void testNoUserAccess() {
        UserListResponse userListResponse = (UserListResponse)this.client().findUsers(new ParameterProvider[0]).blockingGet();
        MeshAssertions.assertThat((List)userListResponse.getData()).isEmpty();
    }

    @Test
    public void testNoGraphQlUserAccess() {
        GraphQLResponse graphQLResponse = (GraphQLResponse)this.client().graphqlQuery("dummy", "{\n  users {\n    elements {\n      username\n    }\n  }\n}", new ParameterProvider[0]).blockingGet();
        MeshAssertions.assertThat((int)graphQLResponse.getData().getJsonObject("users").getJsonArray("elements").size()).isEqualTo(0);
    }

    @Test
    public void testLogin() {
        this.tryLogin("nonExistingUser", "wrongPassword", HttpResponseStatus.UNAUTHORIZED, "Login failed.");
        this.tryLogin("admin", "wrongPassword", HttpResponseStatus.UNAUTHORIZED, "Login failed.");
    }

    @Test
    public void testCreateUser() {
        UserCreateRequest userCreateRequest = new UserCreateRequest().setUsername("nonExistingUser").setPassword("somePassword");
        ClientHelper.call(() -> this.client().createUser(userCreateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN);
        userCreateRequest.setUsername("admin");
        ClientHelper.call(() -> this.client().createUser(userCreateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN);
    }

    @Test
    public void testGraphQl() {
        GraphQLResponse graphQLResponse = (GraphQLResponse)this.client().graphqlQuery("dummy", "{user(name:\"nonExistingUser\") { username }}", new ParameterProvider[0]).blockingGet();
        MeshAssertions.assertThat((List)graphQLResponse.getErrors()).isNullOrEmpty();
        MeshAssertions.assertThat((JsonObject)graphQLResponse.getData().getJsonObject("user")).isNull();
        graphQLResponse = (GraphQLResponse)this.client().graphqlQuery("dummy", "{user(name:\"admin\") { username }}", new ParameterProvider[0]).blockingGet();
        MeshAssertions.assertThat((List)graphQLResponse.getErrors()).isNullOrEmpty();
        MeshAssertions.assertThat((JsonObject)graphQLResponse.getData().getJsonObject("user")).isNull();
    }

    private void tryLogin(String username, String password, HttpResponseStatus expectedStatusCode, String expectedMessage) {
        this.client().setLogin(username, password);
        try {
            this.client().login().blockingGet();
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MeshRestClientMessageException) {
                MeshAssertions.assertThat((MeshRestClientMessageException)((MeshRestClientMessageException)cause)).hasStatusCode(expectedStatusCode.code()).hasMessage(expectedMessage);
            }
            throw e;
        }
    }
}

