/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.utilities;

import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.handler.HttpException;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.Response;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractValidateSchemaTest
extends AbstractMeshTest {
    public static final String INVALID_NAME_EMPTY = "";
    public static final String INVALID_NAME_NUMBER = "123";
    public static final String INVALID_NAME_SPACE = "t e s t";
    public static final String INVALID_NAME_UMLAUTE = "test\u00e4\u00f6\u00fc";
    public static final String INVALID_NAME_SPECIAL = "test:?*#+-.,;<>|!\"'\u00a7$%&/()=\u00b4`~\u00b2\u00b3{}[]\\\u00df\u00b5^\u00b0@\u20ac";
    public static final JsonObject DUMMY_OBJ = new JsonObject().put("test", (Object)"hello");
    private final String path;
    private final boolean isNode;
    private final JsonArray types;

    public AbstractValidateSchemaTest(String path, boolean isNode) {
        this.path = path;
        this.isNode = isNode;
        this.types = this.isNode ? new JsonArray().add((Object)"string").add((Object)"number").add((Object)"date").add((Object)"boolean").add((Object)"html").add((Object)"micronode").add((Object)"node").add((Object)"list").add((Object)"binary") : new JsonArray().add((Object)"string").add((Object)"number").add((Object)"date").add((Object)"boolean").add((Object)"html").add((Object)"node").add((Object)"list").add((Object)"binary");
    }

    @Test
    public void testInvalidSchemas() {
        ArrayList<JsonObject> schemas = new ArrayList<JsonObject>();
        schemas.add(new JsonObject());
        schemas.add(new JsonObject().put("bla", (Object)"foo"));
        schemas.add(new JsonObject().put("fields", (Object)new JsonArray()));
        schemas.add(new JsonObject().put("name", (Object)"test"));
        new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)INVALID_NAME_EMPTY).add((Object)INVALID_NAME_NUMBER).add((Object)INVALID_NAME_SPACE).add((Object)INVALID_NAME_UMLAUTE).add((Object)INVALID_NAME_SPECIAL).add((Object)new JsonArray().add((Object)"test")).add((Object)DUMMY_OBJ).forEach(value -> schemas.add(new JsonObject().put("name", value).put("fields", (Object)new JsonArray())));
        new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)"test").add((Object)DUMMY_OBJ).add((Object)new JsonArray().add((Object)true)).add((Object)new JsonArray().add((Object)false)).add((Object)new JsonArray().add((Object)123)).add((Object)new JsonArray().add((Object)-123)).add((Object)new JsonArray().add((Object)123.456)).add((Object)new JsonArray().add((Object)"test")).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", value)));
        new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)new JsonArray().add((Object)"test")).add((Object)DUMMY_OBJ).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray()).put("description", value)));
        JsonObject minimalField = new JsonObject().put("name", (Object)"test").put("type", (Object)"string");
        JsonObject listField = new JsonObject().put("name", (Object)"test").put("type", (Object)"list");
        new JsonArray().add((Object)new JsonObject().put("something", (Object)"no name")).add((Object)new JsonObject().put("name", (Object)"test")).add((Object)new JsonObject().put("type", (Object)"string")).add((Object)minimalField.copy().put("name", (Object)true)).add((Object)minimalField.copy().put("name", (Object)false)).add((Object)minimalField.copy().put("name", (Object)123)).add((Object)minimalField.copy().put("name", (Object)-123)).add((Object)minimalField.copy().put("name", (Object)123.456)).add((Object)minimalField.copy().put("name", (Object)INVALID_NAME_EMPTY)).add((Object)minimalField.copy().put("name", (Object)INVALID_NAME_NUMBER)).add((Object)minimalField.copy().put("name", (Object)INVALID_NAME_SPACE)).add((Object)minimalField.copy().put("name", (Object)INVALID_NAME_UMLAUTE)).add((Object)minimalField.copy().put("name", (Object)INVALID_NAME_SPECIAL)).add((Object)minimalField.copy().put("name", (Object)new JsonArray().add((Object)"test"))).add((Object)minimalField.copy().put("name", (Object)DUMMY_OBJ)).add((Object)minimalField.copy().put("label", (Object)true)).add((Object)minimalField.copy().put("label", (Object)false)).add((Object)minimalField.copy().put("label", (Object)123)).add((Object)minimalField.copy().put("label", (Object)-123)).add((Object)minimalField.copy().put("label", (Object)123.456)).add((Object)minimalField.copy().put("label", (Object)new JsonArray().add((Object)"test"))).add((Object)minimalField.copy().put("label", (Object)DUMMY_OBJ)).add((Object)minimalField.copy().put("allow", (Object)true)).add((Object)minimalField.copy().put("allow", (Object)false)).add((Object)minimalField.copy().put("allow", (Object)123)).add((Object)minimalField.copy().put("allow", (Object)-123)).add((Object)minimalField.copy().put("allow", (Object)123.456)).add((Object)minimalField.copy().put("allow", (Object)"test")).add((Object)minimalField.copy().put("allow", (Object)DUMMY_OBJ)).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)true))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)false))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)123))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)-123))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)123.456))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)"test"))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)DUMMY_OBJ))).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)new JsonArray().add((Object)"test")))).add((Object)minimalField.copy().put("type", (Object)true)).add((Object)minimalField.copy().put("type", (Object)false)).add((Object)minimalField.copy().put("type", (Object)123)).add((Object)minimalField.copy().put("type", (Object)-123)).add((Object)minimalField.copy().put("type", (Object)123.456)).add((Object)minimalField.copy().put("type", (Object)INVALID_NAME_EMPTY)).add((Object)minimalField.copy().put("type", (Object)"invalid")).add((Object)minimalField.copy().put("type", (Object)new JsonArray().add((Object)"string"))).add((Object)minimalField.copy().put("type", (Object)new JsonObject().put("type", (Object)"string"))).add((Object)listField.copy().put("listType", (Object)true)).add((Object)listField.copy().put("listType", (Object)false)).add((Object)listField.copy().put("listType", (Object)123)).add((Object)listField.copy().put("listType", (Object)-123)).add((Object)listField.copy().put("listType", (Object)123.456)).add((Object)listField.copy().put("listType", (Object)INVALID_NAME_EMPTY)).add((Object)listField.copy().put("listType", (Object)"invalid")).add((Object)listField.copy().put("listType", (Object)new JsonArray().add((Object)"string"))).add((Object)listField.copy().put("listType", (Object)DUMMY_OBJ)).add((Object)minimalField.copy().put("required", (Object)true)).add((Object)minimalField.copy().put("required", (Object)false)).add((Object)minimalField.copy().put("required", (Object)123)).add((Object)minimalField.copy().put("required", (Object)-123)).add((Object)minimalField.copy().put("required", (Object)123.456)).add((Object)minimalField.copy().put("required", (Object)"test")).add((Object)minimalField.copy().put("required", (Object)DUMMY_OBJ)).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)true))).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)false))).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)123))).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)-123))).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)123.456))).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)new JsonArray().add((Object)"something")))).add((Object)minimalField.copy().put("required", (Object)new JsonArray().add((Object)DUMMY_OBJ))).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray().add(value))));
        schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray().add((Object)new JsonObject().put("name", (Object)"test").put("type", (Object)"string")).add((Object)new JsonObject().put("name", (Object)"test").put("type", (Object)"number"))));
        if (this.isNode) {
            new JsonArray().add((Object)new JsonArray()).add((Object)DUMMY_OBJ).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)"test").add((Object)new JsonArray().add((Object)"test")).add((Object)DUMMY_OBJ).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray()).put("container", value)));
            new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)INVALID_NAME_EMPTY).add((Object)INVALID_NAME_NUMBER).add((Object)INVALID_NAME_SPACE).add((Object)INVALID_NAME_UMLAUTE).add((Object)INVALID_NAME_SPECIAL).add((Object)"something").add((Object)new JsonArray().add((Object)"test")).add((Object)DUMMY_OBJ).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray().add((Object)minimalField.copy())).put("displayField", value)));
            new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)INVALID_NAME_EMPTY).add((Object)INVALID_NAME_NUMBER).add((Object)INVALID_NAME_SPACE).add((Object)INVALID_NAME_UMLAUTE).add((Object)INVALID_NAME_SPECIAL).add((Object)"something").add((Object)new JsonArray().add((Object)"test")).add((Object)DUMMY_OBJ).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray().add((Object)minimalField.copy())).put("segmentField", value)));
            new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)INVALID_NAME_EMPTY).add((Object)INVALID_NAME_NUMBER).add((Object)INVALID_NAME_SPACE).add((Object)INVALID_NAME_UMLAUTE).add((Object)INVALID_NAME_SPECIAL).add((Object)"something").add((Object)new JsonArray().add((Object)"something")).add((Object)DUMMY_OBJ).add((Object)new JsonArray().add((Object)true)).add((Object)new JsonArray().add((Object)false)).add((Object)new JsonArray().add((Object)123)).add((Object)new JsonArray().add((Object)-123)).add((Object)new JsonArray().add((Object)123.456)).add((Object)new JsonArray().add((Object)INVALID_NAME_EMPTY)).add((Object)new JsonArray().add((Object)INVALID_NAME_NUMBER)).add((Object)new JsonArray().add((Object)INVALID_NAME_SPACE)).add((Object)new JsonArray().add((Object)INVALID_NAME_UMLAUTE)).add((Object)new JsonArray().add((Object)INVALID_NAME_SPECIAL)).add((Object)new JsonArray().add((Object)"something")).add((Object)new JsonArray().add((Object)new JsonArray().add((Object)"something"))).add((Object)new JsonArray().add((Object)DUMMY_OBJ)).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray().add((Object)minimalField.copy())).put("urlFields", value)));
        }
        new JsonArray().add((Object)true).add((Object)false).add((Object)123).add((Object)-123).add((Object)123.456).add((Object)INVALID_NAME_EMPTY).add((Object)"hello").add((Object)"-1.0").add((Object)"1").add((Object)"1.0.0").add((Object)"1.#").add((Object)"1,0").add((Object)"1.-1").add((Object)new JsonArray().add((Object)"1.0")).add((Object)DUMMY_OBJ).forEach(value -> schemas.add(new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray()).put("version", value)));
        for (JsonObject schema : schemas) {
            try {
                Response r = this.httpPost(this.path, schema, new ParameterProvider[0]).execute();
                if (r.code() != 200) {
                    throw new HttpException(r.code());
                }
                JsonObject obj = new JsonObject(r.body().string());
                Assert.assertEquals((String)"Status should be invalid", (Object)obj.getString("status"), (Object)"INVALID");
                Assert.assertNotNull((Object)obj.getJsonObject("message"));
            }
            catch (IOException e) {
                Assert.fail((String)("Error during Request: " + e.getMessage()));
            }
        }
    }

    @Test
    public void testValidSchemas() {
        ArrayList<JsonObject> schemas = new ArrayList<JsonObject>();
        JsonObject minimal = new JsonObject().put("name", (Object)"test").put("fields", (Object)new JsonArray());
        JsonObject minimalField = new JsonObject().put("name", (Object)"test").put("type", (Object)"string");
        JsonObject base = minimal.copy().put("fields", (Object)new JsonArray().add((Object)minimalField));
        schemas.add(minimal.copy());
        schemas.add(minimal.copy().put("name", (Object)"very_long_schema_name_with_underscores"));
        schemas.add(minimal.copy().put("name", (Object)"veryLongSchemaNameWithoutUnderscores"));
        schemas.add(minimal.copy().put("name", (Object)"nameWithNumbers1234567890"));
        this.types.forEach(type -> {
            schemas.add(minimal.copy().put("fields", (Object)new JsonArray().add((Object)new JsonObject().put("name", (Object)"test").put("type", type))));
            if (!type.equals("list")) {
                schemas.add(minimal.copy().put("fields", (Object)new JsonArray().add((Object)new JsonObject().put("name", (Object)"test").put("type", (Object)"list").put("listType", type))));
            }
        });
        new JsonArray().add((Object)minimalField.copy().put("label", (Object)"hello world")).add((Object)minimalField.copy().put("required", (Object)true)).add((Object)minimalField.copy().put("required", (Object)false)).add((Object)minimalField.copy().put("allow", (Object)new JsonArray())).add((Object)minimalField.copy().put("allow", (Object)new JsonArray().add((Object)"something"))).forEach(field -> schemas.add(minimal.copy().put("fields", (Object)new JsonArray().add(field))));
        schemas.add(minimal.copy().put("description", (Object)"literally anything 1234567890!\"\\\u00a7$%&/()=?`\u00b4\u00df\u00b2\u00b3@\u20ac,.-+/;:*'\u00e4\u00f6\u00fc\n\t~\u00b5<>|"));
        if (this.isNode) {
            schemas.add(minimal.copy().put("container", (Object)true));
            schemas.add(minimal.copy().put("container", (Object)false));
            schemas.add(base.copy().put("displayField", (Object)"test"));
            schemas.add(base.copy().put("segmentField", (Object)"test"));
            schemas.add(base.copy().put("urlFields", (Object)new JsonArray().add((Object)"test")));
        }
        schemas.add(base.copy().put("version", (Object)"0.1"));
        schemas.add(base.copy().put("version", (Object)"1.0"));
        schemas.add(base.copy().put("version", (Object)"1.1"));
        for (JsonObject schema : schemas) {
            try {
                Response r = this.httpPost(this.path, schema, new ParameterProvider[0]).execute();
                if (r.code() != 200) {
                    throw new HttpException(r.code());
                }
                JsonObject obj = new JsonObject(r.body().string());
                Assert.assertEquals((String)"Status should be valid", (Object)obj.getString("status"), (Object)"VALID");
                Assert.assertNotNull((Object)obj.getJsonObject("message"));
            }
            catch (IOException e) {
                Assert.fail((String)("Error during Request: " + e.getMessage()));
            }
        }
    }
}

