/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webroot;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, clusterMode=true)
public class WebRootClusteredEndpointTest
extends AbstractMeshTest {
    @Test
    public void testNodeCreateUpdate() {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootCreate("dummy", "/new-page.html", nodeCreateRequest, new ParameterProvider[0]));
        Assert.assertEquals((Object)"0.1", (Object)response.getVersion());
        NodeCreateRequest nodeUpdateRequest = new NodeCreateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setSchemaName("content");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeUpdateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again 2!"));
        ClientHelper.call(() -> this.client().webrootCreate("dummy", "/new-page.html", nodeUpdateRequest, new ParameterProvider[0]));
    }
}

