/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webroot;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, optionChanger=MeshCoreOptionChanger.NO_PATH_CACHE)
public class WebRootEndpointNoCacheTest
extends AbstractMeshTest {
    @Test
    public void testReadBinaryNode() throws IOException {
        String path = "/News/2015/News_2015.en.html";
        for (int i = 0; i < 10; ++i) {
            MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
            try (Tx tx = this.tx();){
                HibNode node = this.content("news_2015");
                MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(node).hasLanguage("en");
                continue;
            }
        }
    }
}

