/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webroot;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibField;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.s3binary.S3BinaryUploadRequest;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.S3BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.path.Path;
import com.gentics.mesh.path.PathSegment;
import com.gentics.mesh.path.impl.PathSegmentImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshResponse;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.URIUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(awsContainer=AWSTestMode.MINIO, testSize=TestSize.FULL, startServer=true)
public class WebRootEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadBinaryNode() throws IOException {
        HibNode node = this.content("news_2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "image/*", "binary");
            tx.success();
        }
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        ClientHelper.call(() -> this.uploadRandomData(this.content("news_2015"), "en", "binary", binaryLen, contentType, fileName));
        String path = "/News/2015/somefile.dat";
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
        MeshBinaryResponse downloadResponse = response.getBinaryResponse();
        Assert.assertEquals((String)"Webroot response node uuid header value did not match", (Object)nodeUuid, (Object)response.getNodeUuid());
        Assert.assertTrue((boolean)response.isBinary());
        Assert.assertNotNull((Object)downloadResponse);
    }

    @Test
    public void testReadS3BinaryNode() throws IOException {
        HibNode node = this.content("news_2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx = this.tx();){
            this.prepareTypedSchema(node, new S3BinaryFieldSchemaImpl().setAllowedMimeTypes(new String[]{"image/*"}).setName("s3").setLabel("Binary content"), true);
            tx.success();
        }
        S3BinaryUploadRequest request = new S3BinaryUploadRequest().setFilename("test.jpg").setLanguage("en").setVersion("1.0");
        ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", nodeUuid, "s3", request, new ParameterProvider[0]));
        String s3Bucket = this.getTestContext().getOptions().getS3Options().getBucket();
        File tempFile = this.createTempFile();
        this.s3BinaryStorage().createBucket(s3Bucket).flatMap(unused -> this.s3BinaryStorage().uploadFile(s3Bucket, nodeUuid + "/s3", tempFile, false)).blockingGet();
        String path = "/News/2015/test.jpg";
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.isBinary());
        MeshBinaryResponse downloadResponse = response.getBinaryResponse();
        Assert.assertNotNull((Object)downloadResponse);
        Assert.assertEquals((Object)"image/jpeg", (Object)downloadResponse.getContentType());
        try (InputStream is = downloadResponse.getStream();){
            byte[] downloadBytes = IOUtils.toByteArray((InputStream)is);
            ByteArrayInputStream in = new ByteArrayInputStream(downloadBytes);
            BufferedImage buf = ImageIO.read(in);
            Assert.assertEquals((long)1160L, (long)buf.getWidth());
            Assert.assertEquals((long)1376L, (long)buf.getHeight());
        }
        catch (IOException ioException) {
            Assert.fail((String)ioException.getLocalizedMessage());
        }
    }

    @Test
    public void testReadFolderByPath() throws Exception {
        HibNode node = this.folder("2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String path = "/News/2015";
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        MeshAssertions.assertThat((NodeResponse)response.getNodeResponse()).is(node).hasLanguage("en");
        Assert.assertFalse((boolean)response.isBinary());
        Assert.assertEquals((String)"Webroot response node uuid header value did not match", (Object)nodeUuid, (Object)response.getNodeUuid());
    }

    @Test
    public void testInvalidWebrootPath() {
        HibNode node = this.folder("2015");
        String path = "/News/2015";
        ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        this.tx(tx -> {
            HibNodeFieldContainer bogusContainer = CoreTestUtils.createContainer();
            HibStringField bogusField = bogusContainer.createString("name");
            Path entry = this.mesh().pathCache().getPath(this.project(), this.initialBranch(), ContainerType.DRAFT, path);
            entry.addSegment((PathSegment)new PathSegmentImpl(bogusContainer, (HibField)bogusField, "en", "bogus"));
            tx.rollback();
        });
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        MeshAssertions.assertThat((NodeResponse)response.getNodeResponse()).is(node).hasLanguage("en");
    }

    @Test
    public void testReadFolderByPathAndResolveLinks() {
        HibNode content = this.content("news_2015");
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), content.getUuid(), new ParameterProvider[0]));
            NodeUpdateRequest request = response.toRequest();
            request.getFields().put("content", (Field)new HtmlFieldImpl().setHTML("<a href=\"{{mesh.link('" + content.getUuid() + "', 'en')}}\">somelink</a>"));
            ClientHelper.call(() -> this.client().updateNode(this.projectName(), content.getUuid(), request, new ParameterProvider[0]));
            tx.success();
        }
        tx = this.tx();
        try {
            String path = "/News/2015/News_2015.en.html";
            MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL).setLanguages(new String[]{"en"})}));
            HtmlFieldImpl contentField = restNode.getNodeResponse().getFields().getHtmlField("content");
            Assert.assertNotNull((Object)contentField);
            Assert.assertEquals((String)"Check rendered content", (Object)"<a href=\"/api/v2/dummy/webroot/News/2015/News_2015.en.html\">somelink</a>", (Object)contentField.getHTML());
            MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(content).hasLanguage("en");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadContentByPath() throws Exception {
        String path = "/News/2015/News_2015.en.html";
        MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
        try (Tx tx = this.tx();){
            HibNode node = this.content("news_2015");
            MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(node).hasLanguage("en");
        }
    }

    @Test
    public void testReadContentWithNodeRefByPath() throws Exception {
        String json = (String)this.tx(() -> ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getJson());
        String uuid = (String)this.tx(() -> this.schemaContainer("folder").getUuid());
        this.waitForJob(() -> {
            SchemaUpdateRequest schema = (SchemaUpdateRequest)JsonUtil.readValue((String)json, SchemaUpdateRequest.class);
            schema.getFields().add(FieldUtil.createNodeFieldSchema((String)"nodeRef"));
            ClientHelper.call(() -> this.client().updateSchema(uuid, schema, new ParameterProvider[0]));
        });
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            HibNode parentNode = this.folder("2015");
            HibSchema contentSchema = this.schemaContainer("content");
            HibNode node = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)contentSchema.getLatestVersion(), this.project());
            roleDao.grantPermissions(this.role(), (HibBaseElement)node, InternalPermission.values());
            HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(node, this.german(), this.project().getLatestBranch(), this.user());
            englishContainer.createString("teaser").setString("german teaser");
            englishContainer.createString("title").setString("german title");
            englishContainer.createString("slug").setString("test.de.html");
            HibNodeFieldContainer original = contentDao.getLatestDraftFieldContainer(parentNode, this.english());
            HibNodeFieldContainer container = contentDao.createFieldContainer(parentNode, this.english(), this.project().getLatestBranch(), this.user(), original, true);
            container.createNode("nodeRef", node);
            contentDao.updateWebrootPathInfo(container, this.project().getLatestBranch().getUuid(), "");
            tx.success();
        }
        String path = "/News/2015";
        MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.MEDIUM).setLanguages(new String[]{"en", "de"})}));
        Assert.assertEquals((String)"The node reference did not point to the german node.", (Object)"/dummy/News/2015/test.de.html", (Object)restNode.getNodeResponse().getFields().getNodeField("nodeRef").getPath());
        Assert.assertEquals((String)"The name of the node did not match", (Object)"2015", (Object)restNode.getNodeResponse().getFields().getStringField("name").getString());
        restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.MEDIUM).setLanguages(new String[]{"en"})}));
        Assert.assertEquals((String)"The node reference did not point to the 404 path.", (Object)"/dummy/error/404", (Object)restNode.getNodeResponse().getFields().getNodeField("nodeRef").getPath());
        Assert.assertEquals((String)"The name of the node did not match", (Object)"2015", (Object)restNode.getNodeResponse().getFields().getStringField("name").getString());
    }

    @Test
    public void testReadMultithreaded() {
        int nJobs = 200;
        String path = "/News/2015/News_2015.en.html";
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
    }

    @Test
    public void testPathWithSpaces() throws Exception {
        String[] path = new String[]{"News", "2015", "Special News_2014.en.html"};
        ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
    }

    @Test(timeout=2000L)
    public void testPathWithSpacesTimeout() throws Exception {
        String path = "/path with spaces";
        ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
    }

    @Test
    public void testPathWithPlus() throws Exception {
        String newName = "20!$&'()*+,;=%3F? 15";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse before = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        NodeUpdateRequest nodeUpdateRequest = before.toRequest();
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeResponse after = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> this.folder("2015").getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)after.getPath());
        String[] path = new String[]{"News", newName};
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}).setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)uuid, (Object)response.getNodeResponse().getUuid());
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)response.getNodeResponse().getPath());
    }

    @Test
    public void testPathWithSlash() throws Exception {
        String newName = "2015/2016";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse before = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        NodeUpdateRequest nodeUpdateRequest = before.toRequest();
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeResponse after = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> this.folder("2015").getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)after.getPath());
        String[] path = new String[]{"News", newName};
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}).setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)uuid, (Object)response.getNodeResponse().getUuid());
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)response.getNodeResponse().getPath());
    }

    @Test
    public void testReadFolderWithBogusPath() throws Exception {
        String path = "/blub";
        ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
    }

    @Test(expected=RuntimeException.class)
    public void testReadWithEmptyPath() {
        MeshWebrootResponse response = (MeshWebrootResponse)this.client().webroot("dummy", "", new ParameterProvider[0]).blockingGet();
        Assert.assertEquals((Object)this.project().getBaseNode().getUuid(), (Object)response.getNodeResponse().getUuid());
    }

    @Test
    public void testReadProjectBaseNode() {
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "/", new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertFalse((boolean)response.isBinary());
        try (Tx tx = this.tx();){
            Assert.assertEquals((String)"We expected the project basenode.", (Object)this.project().getBaseNode().getUuid(), (Object)response.getNodeResponse().getUuid());
        }
    }

    @Test
    public void testReadDoubleSlashes() {
        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "//", new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertFalse((boolean)response.isBinary());
        try (Tx tx = this.tx();){
            Assert.assertEquals((String)"We expected the project basenode.", (Object)this.project().getBaseNode().getUuid(), (Object)response.getNodeResponse().getUuid());
        }
    }

    @Test
    public void testReadFolderWithLanguageFallbackInPath() {
        String name = "New_in_March_2014";
        for (String path1 : Arrays.asList("News", "Neuigkeiten")) {
            for (String path2 : Arrays.asList("2014")) {
                for (String path3 : Arrays.asList("March", "M\u00e4rz")) {
                    for (String language : Arrays.asList("en", "de")) {
                        MeshWebrootResponse response = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", new String[]{path1, path2, path3, name + "." + language + ".html"}, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
                        Assert.assertEquals((String)"Check response language", (Object)language, (Object)response.getNodeResponse().getLanguage());
                    }
                }
            }
        }
    }

    @Test
    public void testReadFolderByPathWithoutPerm() throws Exception {
        String uuid;
        String englishPath = "/News/2015";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibNode newsFolder = this.folder("2015");
            uuid = newsFolder.getUuid();
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().webroot("dummy", englishPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadContentByInvalidPath() throws Exception {
        String invalidPath = "/News/2015/no-valid-content.html";
        ClientHelper.call(() -> this.client().webroot("dummy", invalidPath, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{invalidPath});
    }

    @Test
    public void testReadContentByInvalidPath2() throws Exception {
        String invalidPath = "/News/no-valid-folder/no-valid-content.html";
        ClientHelper.call(() -> this.client().webroot("dummy", invalidPath, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{invalidPath});
    }

    @Test
    public void testRead404Page() {
        String notFoundPath = "/error/404";
        ClientHelper.call(() -> this.client().webroot("dummy", notFoundPath, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{notFoundPath});
    }

    @Test
    public void testRead404Node() {
        String notFoundPath = "/error/404";
        try (Tx tx = this.tx();){
            NodeCreateRequest createErrorFolder = new NodeCreateRequest();
            createErrorFolder.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            createErrorFolder.setParentNodeUuid(this.project().getBaseNode().getUuid());
            createErrorFolder.getFields().put("slug", (Field)FieldUtil.createStringField((String)"error"));
            createErrorFolder.setLanguage("en");
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", createErrorFolder, new ParameterProvider[0]));
            String errorNodeUuid = response.getUuid();
            NodeCreateRequest create404Node = new NodeCreateRequest();
            create404Node.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            create404Node.setParentNodeUuid(errorNodeUuid);
            create404Node.getFields().put("slug", (Field)FieldUtil.createStringField((String)"404"));
            create404Node.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"Error Content"));
            create404Node.getFields().put("content", (Field)FieldUtil.createStringField((String)"An error happened"));
            create404Node.setLanguage("en");
            ClientHelper.call(() -> this.client().createNode("dummy", create404Node, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().webroot("dummy", notFoundPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
        }
    }

    @Test
    public void testWebrootCacheControlPrivateNode() {
        String path = "/News/2015";
        MeshResponse response = (MeshResponse)this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().published()}).getResponse().blockingGet();
        String cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"private", (Object)cacheControl);
    }

    @Test
    public void testWebrootCacheControlPublicNode() {
        String path = "/News/2015";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.anonymousRole(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        MeshResponse response = (MeshResponse)this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().published()}).getResponse().blockingGet();
        String cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"public", (Object)cacheControl);
    }

    @Test
    public void testWebrootCacheControlPublicPublishedNode() {
        String path = "/News/2015";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.anonymousRole(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        MeshResponse response = (MeshResponse)this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().published()}).getResponse().blockingGet();
        String cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"public", (Object)cacheControl);
        response = (MeshResponse)this.client().webroot("dummy", path, new ParameterProvider[0]).getResponse().blockingGet();
        cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"private", (Object)cacheControl);
    }

    @Test
    public void testReadPublished() {
        String path = "/News/2015";
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(this.folder("news"), this.mockActionContext(), bac);
            nodeDao.publish(this.folder("2015"), this.mockActionContext(), bac);
            tx.success();
        }
        tx = this.tx();
        try {
            MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new NodeParametersImpl()}));
            MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(this.folder("2015")).hasVersion("2.0").hasLanguage("en");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadPublishedWithNoReadPerm() {
        String path = "/News/2015";
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().publishNode("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        }
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", path, new ParameterProvider[]{new NodeParametersImpl(), new VersioningParametersImpl().published()}));
            MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(this.folder("2015")).hasVersion("1.0").hasLanguage("en");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadPublishedDifferentFromDraft() {
        String publishedPath = "/News/2015";
        String draftPath = "/News_draft/2015_draft";
        this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(this.folder("news"), this.mockActionContext(), bac);
            nodeDao.publish(this.folder("2015"), this.mockActionContext(), bac);
        });
        String newsUuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.updateSlug(newsUuid, "en", "News_draft", this.initialBranchUuid());
        String folder2015Uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        this.updateSlug(folder2015Uuid, "en", "2015_draft", this.initialBranchUuid());
        this.tx(() -> {
            MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", publishedPath, new ParameterProvider[]{new VersioningParametersImpl().published()}));
            MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(this.folder("2015")).hasVersion("1.0").hasLanguage("en");
        });
        this.tx(tx -> ClientHelper.call(() -> this.client().webroot("dummy", publishedPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{publishedPath}));
        this.tx(() -> {
            MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", draftPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).is(this.folder("2015")).hasVersion("1.1").hasLanguage("en");
        });
        this.tx(() -> ClientHelper.call(() -> this.client().webroot("dummy", draftPath, new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{draftPath}));
    }

    @Test
    public void testReadForBranch() {
        String newBranchName = "newbranch";
        String initialPath = "/News/2015";
        String newPath = "/News_new/2015_new";
        String folder2015Uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String newsUuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.grantAdmin();
        this.waitForJobs(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setName(newBranchName);
            ClientHelper.call(() -> this.client().createBranch("dummy", branchCreateRequest, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        MeshWebrootResponse restNode2 = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        MeshAssertions.assertThat((NodeResponse)restNode2.getNodeResponse()).hasUuid(folder2015Uuid).hasVersion("1.0").hasLanguage("en");
        MeshWebrootResponse restNode3 = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranchName)}));
        MeshAssertions.assertThat((NodeResponse)restNode3.getNodeResponse()).hasUuid(folder2015Uuid).hasVersion("1.0").hasLanguage("en");
        this.updateSlug(newsUuid, "en", "News_new", newBranchName);
        this.updateSlug(folder2015Uuid, "en", "2015_new", newBranchName);
        MeshWebrootResponse restNode = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", newPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranchName)}));
        MeshAssertions.assertThat((NodeResponse)restNode.getNodeResponse()).hasUuid(folder2015Uuid).hasVersion("1.1").hasLanguage("en");
        ClientHelper.call(() -> this.client().webroot("dummy", newPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{newPath});
        MeshWebrootResponse restNode4 = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        MeshAssertions.assertThat((NodeResponse)restNode4.getNodeResponse()).hasUuid(folder2015Uuid).hasVersion("1.0").hasLanguage("en");
        ClientHelper.call(() -> this.client().webroot("dummy", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{initialPath});
    }

    protected void updateSlug(String uuid, String language, String newName, String branch) {
        NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        NodeUpdateRequest update = node.toRequest();
        update.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch)}));
    }

    protected void updateName(HibNode node, HibBranch branch, String language, String newName) {
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage(language);
        update.getFields().put("name", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch.getUuid())}));
    }
}

