/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webroot;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class WebRootEndpointUpdateTest
extends AbstractMeshTest {
    @Test
    public void testCreateNodeViaPath() {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootCreate("dummy", "/new-page.html", nodeCreateRequest, new ParameterProvider[0]));
        Assert.assertEquals((Object)"0.1", (Object)response.getVersion());
    }

    @Test
    public void testCreateNodeViaPathAndPrefix() {
        String prefix = "some/prefix";
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setPathPrefix(prefix);
        ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootCreate("dummy", "/" + prefix + "/new-page.html", nodeCreateRequest, new ParameterProvider[0]));
        Assert.assertEquals((Object)"0.1", (Object)response.getVersion());
    }

    @Test
    public void testCreateNodeWithMissingPrefix() {
        String prefix = "some/prefix";
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setPathPrefix(prefix);
        ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/2015/new-page.html";
        ClientHelper.call(() -> this.client().webrootCreate("dummy", path, nodeCreateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"webroot_error_prefix_invalid", (String[])new String[]{path, prefix});
    }

    @Test
    public void testCreateNodeViaSubPath() {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"newContent.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/2015/newContent.html";
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootCreate("dummy", path, nodeCreateRequest, new ParameterProvider[0]));
        Assert.assertEquals((Object)"0.1", (Object)response.getVersion());
    }

    @Test
    public void testCreateNodeViaSubPathSegmentMismatch() {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/2015/newContent.html";
        ClientHelper.call(() -> this.client().webrootCreate("dummy", path, nodeCreateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"webroot_error_segment_field_mismatch", (String[])new String[]{"newContent.html", "new-page.html"});
    }

    @Test
    public void testMissingParentSegmentOnUpdate() {
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("1.0");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeUpdateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/missing/News_2015.en.html";
        ClientHelper.call(() -> this.client().webrootUpdate("dummy", path, nodeUpdateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"webroot_error_parent_not_found", (String[])new String[]{"/News"});
    }

    @Test
    public void testMissingParentSegmentOnCreate() {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/missing/News_2015.en.html";
        String errorPath = "/News";
        ClientHelper.call(() -> this.client().webrootCreate("dummy", path, nodeCreateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"webroot_error_parent_not_found", (String[])new String[]{errorPath});
    }

    @Test
    public void testUpdateNodeViaPath() {
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("1.0");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeUpdateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/2015/News_2015.en.html";
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootUpdate("dummy", path, nodeUpdateRequest, new ParameterProvider[0]));
        System.out.println(response.toJson());
    }

    @Test
    public void testUpdateNodeViaPathAndPrefix() {
        String prefix = "some/prefix";
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setPathPrefix(prefix);
        ClientHelper.call(() -> this.client().updateBranch("dummy", this.initialBranchUuid(), request));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("1.0");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeUpdateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        ClientHelper.call(() -> this.client().webrootUpdate("dummy", "/" + prefix + "/News/2015/News_2015.en.html", nodeUpdateRequest, new ParameterProvider[0]));
        String withoutPrefix = "/News/2015/News_2015.en.html";
        ClientHelper.call(() -> this.client().webrootUpdate("dummy", withoutPrefix, nodeUpdateRequest, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"webroot_error_prefix_invalid", (String[])new String[]{withoutPrefix, prefix});
    }

    @Test
    public void testUpdateNodeSegmentViaPath() {
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("1.0");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeUpdateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        String path = "/News/2015/News_2015.en.html";
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootUpdate("dummy", path, nodeUpdateRequest, new ParameterProvider[0]));
        System.out.println(response.toJson());
        MeshWebrootResponse checkResponse = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "/News/2015/new-page.html", new ParameterProvider[0]));
        Assert.assertEquals((String)"The same node (uuid) should have been renamed", (Object)response.getUuid(), (Object)checkResponse.getNodeResponse().getUuid());
        Assert.assertEquals((String)"The same node (lang) should have been renamed", (Object)response.getLanguage(), (Object)checkResponse.getNodeResponse().getLanguage());
    }

    @Test
    public void testAddLanguageContentViaPath() {
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("nl");
        nodeUpdateRequest.setVersion("1.0");
        nodeUpdateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser nl"));
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.nl.html"));
        nodeUpdateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime in nl!"));
        String path = "/News/2015/News_2015.en.html";
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().webrootUpdate("dummy", path, nodeUpdateRequest, new ParameterProvider[0]));
        System.out.println(response.toJson());
        MeshWebrootResponse checkResponse = (MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "/News/2015/new-page.nl.html", new ParameterProvider[0]));
        Assert.assertEquals((String)"The same node (uuid) should have been renamed", (Object)response.getUuid(), (Object)checkResponse.getNodeResponse().getUuid());
        Assert.assertEquals((Object)"nl", (Object)checkResponse.getNodeResponse().getLanguage());
    }
}

