/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webroot.node;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.navigation.NavigationResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NavigationParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class NavRootEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadMultithreaded() {
        try (Tx tx = this.tx();){
            int nJobs = 200;
            String path = "/";
            Observable.range((int)0, (int)200).flatMapSingle(i -> this.client().navroot("dummy", path, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}).toSingle()).blockingForEach(result -> MeshAssertions.assertThat((NavigationResponse)result).isValid(7).hasDepth(3));
        }
    }

    @Test
    public void testReadNavWithValidPath() {
        try (Tx tx = this.tx();){
            String path = "/News/2015";
            NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().navroot("dummy", path, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(10))}));
            MeshAssertions.assertThat((NavigationResponse)response).hasDepth(0).isValid(1);
        }
    }

    @Test
    public void testReadNavWithValidPath2() {
        String path = "/News/2015/";
        NavigationResponse response = (NavigationResponse)ClientHelper.call(() -> this.client().navroot("dummy", path, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(10))}));
        MeshAssertions.assertThat((NavigationResponse)response).isValid(1).hasDepth(0);
    }

    @Test
    public void testReadNavForBasenode() {
        try (Tx tx = this.tx();){
            String path = "/";
            NavigationResponse response = (NavigationResponse)this.client().navroot("dummy", path, new ParameterProvider[]{new NavigationParametersImpl().setMaxDepth(Integer.valueOf(10))}).blockingGet();
            MeshAssertions.assertThat((NavigationResponse)response).isValid(7).hasDepth(3);
            Assert.assertEquals((String)"The root element of the navigation did not contain the project basenode uuid.", (Object)this.project().getBaseNode().getUuid(), (Object)response.getUuid());
        }
    }

    @Test
    public void testReadNavWithInvalidPath() {
        try (Tx tx = this.tx();){
            String path = "/blub";
            ClientHelper.call(() -> this.client().navroot("dummy", path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/blub"});
        }
    }

    @Test
    public void testReadNavWithPathToContent() {
        try (Tx tx = this.tx();){
            String path = "/News/2015/News_2015.en.html";
            ClientHelper.call(() -> this.client().navroot("dummy", path, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"navigation_error_no_container", (String[])new String[0]);
        }
    }
}

