/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webrootfield;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibTransformableElement;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.parameter.ImageManipulationParameters;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.ImageManipulationParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class WebRootFieldEndpointETagTest
extends AbstractMeshTest {
    @Test
    public void testResizeImage() throws IOException {
        HibNode node;
        String path = "/News/2015/blume.jpg";
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            node = this.content("news_2015");
            this.prepareSchema(node, "image/*", "binary");
            tx.success();
        }
        this.uploadImage(node, "en", "binary");
        ImageManipulationParameters params = new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100)).setHeight(Integer.valueOf(102));
        String etag = ClientHelper.callETag(() -> this.client().webrootField("dummy", "binary", path, new ParameterProvider[]{params, new VersioningParametersImpl().setVersion("draft")}));
        ClientHelper.callETag(() -> this.client().webrootField("dummy", "binary", path, new ParameterProvider[]{params, new VersioningParametersImpl().setVersion("draft")}), (String)etag, (boolean)false, (int)304);
        params.setHeight(Integer.valueOf(103));
        String newETag = ClientHelper.callETag(() -> this.client().webrootField("dummy", "binary", path, new ParameterProvider[]{params, new VersioningParametersImpl().setVersion("draft")}), (String)etag, (boolean)false, (int)200);
        ClientHelper.callETag(() -> this.client().webrootField("dummy", "binary", path, new ParameterProvider[]{params, new VersioningParametersImpl().setVersion("draft")}), (String)newETag, (boolean)false, (int)304);
    }

    @Test
    public void testReadBinaryNode() throws IOException {
        HibNode node = this.content("news_2015");
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            this.prepareSchema(node, "image/*", "binary");
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        String path = "/News/2015/somefile.dat";
        String etag = ClientHelper.callETag(() -> this.client().webrootField("dummy", "binary", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
        Assert.assertNotNull((Object)etag);
        Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().webrootField("dummy", "binary", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL)}), (String)etag, (boolean)false, (int)304));
    }

    @Test
    public void testReadOne() {
        String path = "/News/2015/News_2015.en.html";
        this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.content("news_2015");
            HibSchemaVersion schemaVersion = contentDao.getSchemaContainerVersion(contentDao.getFieldContainer(node, "en"));
            SchemaVersionModel schema = schemaVersion.getSchema();
            schema.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"reference"));
            schemaVersion.setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)schemaVersion);
        });
        try (Tx tx2 = this.tx();){
            HibNode node = this.content("news_2015");
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[0]));
            NodeUpdateRequest request = response.toRequest();
            request.getFields().put("reference", (Field)new NodeFieldImpl().setUuid(this.folder("2015").getUuid()));
            ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), request, new ParameterProvider[0]));
            tx2.success();
        }
        String responseTag = ClientHelper.callETag(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
        try (Tx tx3 = this.tx();){
            NodeDao nodeDao = tx3.nodeDao();
            HibNode node = this.content("news_2015");
            String etag = nodeDao.getETag((HibTransformableElement)node, this.mockActionContext());
            Assert.assertEquals((Object)etag, (Object)responseTag);
            Assert.assertEquals((Object)etag, (Object)ClientHelper.callETag(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}), (String)etag, (boolean)true, (int)304));
        }
    }
}

