/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webrootfield;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshWebrootFieldResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class WebRootFieldEndpointPathPrefixTest
extends AbstractMeshTest {
    private void setupSchema(boolean addSegmentField) {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setUrlFields(new String[]{"shortUrl", "shortUrlList"});
        request.setName("dummySchema");
        if (addSegmentField) {
            request.setSegmentField("slug");
        }
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"slug"));
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"shortUrl"));
        request.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"shortUrlList", (String)"string"));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
    }

    @Test
    public void testPathPrefixWebroot() {
        String niceUrlPath = "/some/wonderful/short/url";
        String prefix = "my/prefix";
        this.setupSchema(true);
        String branchUuid = (String)this.tx(() -> this.latestBranch().getUuid());
        BranchUpdateRequest request = new BranchUpdateRequest();
        request.setPathPrefix("my/prefix");
        ClientHelper.call(() -> this.client().updateBranch("dummy", branchUuid, request));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/wonderful/short/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/last/segment"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/slugValue", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/slugValue"});
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/wonderful/short/url", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/some/wonderful/short/url"});
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/not_found", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/not_found"});
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/my/prefix/slugValue", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/my/prefix/some/wonderful/short/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/my/prefix/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/my/prefix/middle", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/my/prefix/last/segment", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
    }
}

