/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webrootfield;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshResponse;
import com.gentics.mesh.rest.client.MeshWebrootFieldResponse;
import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.util.URIUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(awsContainer=AWSTestMode.MINIO, testSize=TestSize.FULL, startServer=true)
public class WebRootFieldEndpointTest
extends AbstractMeshTest {
    @Test
    public void testReadFolderByPath() throws Exception {
        HibNode node = this.folder("2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String path = "/News/2015";
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "name", path, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertFalse((boolean)response.isBinary());
        Assert.assertEquals((String)"Webroot response node uuid header value did not match", (Object)nodeUuid, (Object)response.getNodeUuid());
    }

    @Test
    public void testReadFolderContentFieldByPathAndResolveLinks() throws Exception {
        HibNode content = this.content("news_2015");
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), content.getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest updateRequest = response.toRequest();
        updateRequest.getFields().put("content", (Field)new StringFieldImpl().setString("<a href=\"{{mesh.link('" + content.getUuid() + "', 'en')}}\">somelink</a>"));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), content.getUuid(), updateRequest, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            String path = "/News/2015/News_2015.en.html";
            MeshWebrootFieldResponse restField = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL).setLanguages(new String[]{"en"})}));
            Assert.assertNotNull((Object)restField.getResponseAsPlainText());
            Assert.assertFalse((boolean)restField.isBinary());
            String contentField = restField.getResponseAsPlainText();
            Assert.assertNotNull((Object)contentField);
            Assert.assertEquals((String)"Check rendered content", (Object)"<a href=\"/api/v2/dummy/webroot/News/2015/News_2015.en.html\">somelink</a>", (Object)contentField);
            Assert.assertEquals((Object)restField.getNodeUuid(), (Object)content.getUuid());
        }
    }

    @Test
    public void testReadContentFieldByPath() throws Exception {
        String path = "/News/2015/News_2015.en.html";
        MeshWebrootFieldResponse restField = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.content("news_2015");
            String contentField = restField.getResponseAsPlainText();
            Assert.assertEquals((Object)contentDao.getFieldContainer(node, "en").getHtml("content").getHTML(), (Object)contentField);
        }
    }

    @Test
    public void testReadContentWithNodeRefByPath() throws Exception {
        HibNode nodeRef = null;
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            RoleDao roleDao = tx.roleDao();
            HibNode parentNode = this.folder("2015");
            HibSchema folderSchema = this.schemaContainer("folder");
            SchemaVersionModel schema = ((HibSchemaVersion)folderSchema.getLatestVersion()).getSchema();
            schema.getFields().add(FieldUtil.createNodeFieldSchema((String)"nodeRef"));
            this.prepareTypedSchema(folderSchema, (List<FieldSchema>)schema.getFields(), Optional.empty());
            tx.commit();
            ((HibSchemaVersion)folderSchema.getLatestVersion()).setSchema(schema);
            this.mesh().serverSchemaStorage().addSchema(schema);
            HibSchema contentSchema = this.schemaContainer("content");
            nodeRef = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)contentSchema.getLatestVersion(), this.project());
            roleDao.grantPermissions(this.role(), (HibBaseElement)nodeRef, InternalPermission.values());
            HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(nodeRef, this.german(), this.project().getLatestBranch(), this.user());
            englishContainer.createString("teaser").setString("german teaser");
            englishContainer.createString("title").setString("german title");
            englishContainer.createString("slug").setString("test.de.html");
            tx.success();
        }
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), this.folder("2015").getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest request = response.toRequest();
        request.getFields().put("nodeRef", (Field)new NodeFieldImpl().setUuid(nodeRef.getUuid()));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), this.folder("2015").getUuid(), request, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            String path = "/News/2015";
            MeshWebrootFieldResponse restNode = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "nodeRef", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.MEDIUM).setLanguages(new String[]{"en", "de"})}));
            NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", restNode.getNodeUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.MEDIUM).setLanguages(new String[]{"en", "de"})}));
            Assert.assertEquals((Object)JsonUtil.toJson((Object)node.getFields().getNodeField("nodeRef")), (Object)restNode.getResponseAsJsonString());
        }
    }

    @Test
    public void testReadMultithreaded() {
        int nJobs = 200;
        String path = "/News/2015/News_2015.en.html";
        MeshTestHelper.awaitConcurrentRequests(nJobs, i -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
    }

    @Test
    public void testPathWithSpaces() throws Exception {
        String[] path = new String[]{"News", "2015", "Special News_2014.en.html"};
        ClientHelper.call(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}));
    }

    @Test(timeout=2000L)
    public void testPathWithSpacesTimeout() throws Exception {
        String path = "/path with spaces";
        ClientHelper.call(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"})}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
    }

    @Test
    public void testPathWithPlus() throws Exception {
        String newName = "20!$&'()*+,;=%3F? 15";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse before = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        NodeUpdateRequest nodeUpdateRequest = before.toRequest();
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeResponse after = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> this.folder("2015").getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)after.getPath());
        String[] path = new String[]{"News", newName};
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}).setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)uuid, (Object)response.getNodeUuid());
        Assert.assertEquals((Object)newName, (Object)response.getResponseAsPlainText());
    }

    @Test
    public void testPathWithSlash() throws Exception {
        String newName = "2015/2016";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse before = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        NodeUpdateRequest nodeUpdateRequest = before.toRequest();
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeResponse after = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> this.folder("2015").getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)after.getPath());
        String[] path = new String[]{"News", newName};
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}).setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)uuid, (Object)response.getNodeUuid());
        Assert.assertEquals((Object)newName, (Object)response.getResponseAsPlainText());
    }

    @Test
    public void testReadFolderWithBogusPath() throws Exception {
        String path = "/blub";
        ClientHelper.call(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
    }

    @Test(expected=RuntimeException.class)
    public void testReadWithEmptyPath() {
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)this.client().webrootField("dummy", "content", "", new ParameterProvider[0]).blockingGet();
        Assert.assertEquals((Object)this.project().getBaseNode().getUuid(), (Object)response.getNodeUuid());
    }

    @Test(expected=RuntimeException.class)
    public void testReadWithEmptyField() {
        String newName = "2020";
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse before = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        NodeUpdateRequest nodeUpdateRequest = before.toRequest();
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeResponse after = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> this.folder("2015").getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)("/News/" + URIUtils.encodeSegment((String)newName)), (Object)after.getPath());
        String[] path = new String[]{"News", newName};
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "", path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setLanguages(new String[]{"en", "de"}).setResolveLinks(LinkType.SHORT)}));
        Assert.assertEquals((Object)uuid, (Object)response.getNodeUuid());
    }

    @Test
    public void testReadFolderWithLanguageFallbackInPath() {
        String name = "New_in_March_2014";
        for (String path1 : Arrays.asList("News", "Neuigkeiten")) {
            for (String path2 : Arrays.asList("2014")) {
                for (String path3 : Arrays.asList("March", "M\u00e4rz")) {
                    HashMap<String, String> languages = new HashMap<String, String>();
                    languages.put("en", "english");
                    languages.put("de", "german");
                    for (Map.Entry language : languages.entrySet()) {
                        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "title", new String[]{path1, path2, path3, name + "." + (String)language.getKey() + ".html"}, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
                        Assert.assertEquals((String)"Check response language", (Object)(name + " " + (String)language.getValue() + " title"), (Object)response.getResponseAsPlainText());
                    }
                }
            }
        }
    }

    @Test
    public void testReadFolderByPathWithoutPerm() throws Exception {
        String uuid;
        String englishPath = "/News/2015";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            HibNode newsFolder = this.folder("2015");
            uuid = newsFolder.getUuid();
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.revokePermissions(this.role(), (HibBaseElement)newsFolder, new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.client().webrootField("dummy", "name", englishPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.READ_PERM.getRestPerm().getName()});
    }

    @Test
    public void testReadContentByInvalidPath() throws Exception {
        String invalidPath = "/News/2015/no-valid-content.html";
        ClientHelper.call(() -> this.client().webrootField("dummy", "name", invalidPath, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{invalidPath});
    }

    @Test
    public void testReadContentByInvalidPath2() throws Exception {
        String invalidPath = "/News/no-valid-folder/no-valid-content.html";
        ClientHelper.call(() -> this.client().webrootField("dummy", "name", invalidPath, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{invalidPath});
    }

    @Test
    public void testRead404Page() {
        String notFoundPath = "/error/404";
        ClientHelper.call(() -> this.client().webrootField("dummy", "name", notFoundPath, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{notFoundPath});
    }

    @Test
    public void testRead404Node() {
        String notFoundPath = "/error/404";
        try (Tx tx = this.tx();){
            NodeCreateRequest createErrorFolder = new NodeCreateRequest();
            createErrorFolder.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
            createErrorFolder.setParentNodeUuid(this.project().getBaseNode().getUuid());
            createErrorFolder.getFields().put("slug", (Field)FieldUtil.createStringField((String)"error"));
            createErrorFolder.setLanguage("en");
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", createErrorFolder, new ParameterProvider[0]));
            String errorNodeUuid = response.getUuid();
            NodeCreateRequest create404Node = new NodeCreateRequest();
            create404Node.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
            create404Node.setParentNodeUuid(errorNodeUuid);
            create404Node.getFields().put("slug", (Field)FieldUtil.createStringField((String)"404"));
            create404Node.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"Error Content"));
            create404Node.getFields().put("content", (Field)FieldUtil.createStringField((String)"An error happened"));
            create404Node.setLanguage("en");
            ClientHelper.call(() -> this.client().createNode("dummy", create404Node, new ParameterProvider[0]));
            ClientHelper.call(() -> this.client().webrootField("dummy", "name", notFoundPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
        }
    }

    @Test
    public void testWebrootCacheControlPrivateNode() {
        String path = "/News/2015";
        MeshResponse response = (MeshResponse)this.client().webrootField("dummy", "name", path, new ParameterProvider[]{new VersioningParametersImpl().published()}).getResponse().blockingGet();
        String cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"private", (Object)cacheControl);
    }

    @Test
    public void testWebrootCacheControlPublicNode() {
        String path = "/News/2015";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.anonymousRole(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PERM});
            tx.success();
        }
        MeshResponse response = (MeshResponse)this.client().webrootField("dummy", "name", path, new ParameterProvider[]{new VersioningParametersImpl().published()}).getResponse().blockingGet();
        String cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"public", (Object)cacheControl);
    }

    @Test
    public void testWebrootCacheControlPublicPublishedNode() {
        String path = "/News/2015";
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            roleDao.grantPermissions(this.anonymousRole(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        MeshResponse response = (MeshResponse)this.client().webrootField("dummy", "name", path, new ParameterProvider[]{new VersioningParametersImpl().published()}).getResponse().blockingGet();
        String cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"public", (Object)cacheControl);
        response = (MeshResponse)this.client().webrootField("dummy", "name", path, new ParameterProvider[0]).getResponse().blockingGet();
        cacheControl = (String)response.getHeader("Cache-Control").get();
        Assert.assertEquals((Object)"private", (Object)cacheControl);
    }

    @Test
    public void testReadPublished() {
        String path = "/News/2015";
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().webrootField("dummy", "content", path, new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(this.folder("news"), this.mockActionContext(), bac);
            nodeDao.publish(this.folder("2015"), this.mockActionContext(), bac);
            tx.success();
        }
        tx = this.tx();
        try {
            MeshWebrootFieldResponse restNode = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "name", path, new ParameterProvider[]{new NodeParametersImpl()}));
            Assert.assertEquals((Object)restNode.getResponseAsPlainText(), (Object)"2015");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadPublishedWithNoReadPerm() {
        String path = "/News/2015";
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().publishNode("dummy", this.project().getBaseNode().getUuid(), new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        }
        tx = this.tx();
        try {
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PERM});
            roleDao.grantPermissions(this.role(), (HibBaseElement)this.folder("2015"), new InternalPermission[]{InternalPermission.READ_PUBLISHED_PERM});
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            MeshWebrootFieldResponse restNode = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "name", path, new ParameterProvider[]{new NodeParametersImpl(), new VersioningParametersImpl().published()}));
            Assert.assertEquals((Object)restNode.getResponseAsPlainText(), (Object)"2015");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testReadPublishedDifferentFromDraft() {
        String publishedPath = "/News/2015";
        String draftPath = "/News_draft/2015_draft";
        this.tx(tx -> {
            NodeDao nodeDao = tx.nodeDao();
            BulkActionContext bac = this.createBulkContext();
            nodeDao.publish(this.folder("news"), this.mockActionContext(), bac);
            nodeDao.publish(this.folder("2015"), this.mockActionContext(), bac);
        });
        String newsUuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.updateSlug(newsUuid, "en", "News_draft", this.initialBranchUuid());
        String folder2015Uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        this.updateSlug(folder2015Uuid, "en", "2015_draft", this.initialBranchUuid());
        this.tx(() -> {
            MeshWebrootFieldResponse restNode = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", publishedPath, new ParameterProvider[]{new VersioningParametersImpl().published()}));
            Assert.assertEquals((Object)restNode.getResponseAsPlainText(), (Object)"2015");
        });
        this.tx(() -> ClientHelper.call(() -> this.client().webrootField("dummy", "slug", publishedPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{publishedPath}));
        this.tx(() -> {
            MeshWebrootFieldResponse restNode = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", draftPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            Assert.assertEquals((Object)restNode.getResponseAsPlainText(), (Object)"2015_draft");
        });
        this.tx(() -> ClientHelper.call(() -> this.client().webrootField("dummy", "slug", draftPath, new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{draftPath}));
    }

    @Test
    public void testReadForBranch() {
        String newBranchName = "newbranch";
        String initialPath = "/News/2015";
        String newPath = "/News_new/2015_new";
        String folder2015Uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String newsUuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.grantAdmin();
        this.waitForJobs(() -> {
            BranchCreateRequest branchCreateRequest = new BranchCreateRequest();
            branchCreateRequest.setName(newBranchName);
            ClientHelper.call(() -> this.client().createBranch("dummy", branchCreateRequest, new ParameterProvider[0]));
        }, JobStatus.COMPLETED, 1);
        MeshWebrootFieldResponse restNode2 = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        Assert.assertEquals((Object)restNode2.getResponseAsPlainText(), (Object)"2015");
        MeshWebrootFieldResponse restNode3 = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranchName)}));
        Assert.assertEquals((Object)restNode3.getResponseAsPlainText(), (Object)"2015");
        this.updateSlug(newsUuid, "en", "News_new", newBranchName);
        this.updateSlug(folder2015Uuid, "en", "2015_new", newBranchName);
        MeshWebrootFieldResponse restNode = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", newPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(newBranchName)}));
        Assert.assertEquals((Object)restNode.getResponseAsPlainText(), (Object)"2015_new");
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", newPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{newPath});
        MeshWebrootFieldResponse restNode4 = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft().setBranch(this.initialBranchUuid())}));
        Assert.assertEquals((Object)restNode4.getResponseAsPlainText(), (Object)"2015");
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", initialPath, new ParameterProvider[]{new VersioningParametersImpl().draft()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{initialPath});
    }

    protected void updateSlug(String uuid, String language, String newName, String branch) {
        NodeResponse node = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        NodeUpdateRequest update = node.toRequest();
        update.getFields().put("slug", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch)}));
    }

    protected void updateName(HibNode node, HibBranch branch, String language, String newName) {
        NodeUpdateRequest update = new NodeUpdateRequest();
        update.setLanguage(language);
        update.getFields().put("name", (Field)FieldUtil.createStringField((String)newName));
        ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), update, new ParameterProvider[]{new VersioningParametersImpl().setBranch(branch.getUuid())}));
    }
}

