/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webrootfield;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshWebrootFieldResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class WebRootFieldEndpointUrlPathTest
extends AbstractMeshTest {
    private void setupSchema(boolean addSegmentField) {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setUrlFields(new String[]{"shortUrl", "shortUrlList"});
        request.setName("dummySchema");
        if (addSegmentField) {
            request.setSegmentField("slug");
        }
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"slug"));
        request.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"shortUrl"));
        request.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"shortUrlList", (String)"string"));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
    }

    @Test
    public void testUrlPathResolving() {
        String niceUrlPath = "/some/wonderful/short/url";
        this.setupSchema(true);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/wonderful/short/url"));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/wonderful/short/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/wonderful/short/url", new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/some/wonderful/short/url"});
    }

    @Test
    public void testUrlPathListResolving() {
        String niceUrlPath = "/some/wonderful/short/url";
        this.setupSchema(true);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/wonderful/short/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/last/segment"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/wonderful/short/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/middle", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/last/segment", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/slugValue", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/not_found", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/not_found"});
    }

    @Test
    public void testDuplicateFieldValueInSameNode() {
        this.setupSchema(true);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/some/other/url"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
    }

    @Test
    public void testConflictWithExistingNode() {
        this.setupSchema(true);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/some/other/url"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        NodeCreateRequest nodeCreateRequest2 = new NodeCreateRequest();
        nodeCreateRequest2.setSchemaName("dummySchema");
        nodeCreateRequest2.setLanguage("en");
        nodeCreateRequest2.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest2.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue2"));
        nodeCreateRequest2.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest2.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url2", "/middle3", "/some/other/url4"}));
        ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest2, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_urlfield_update", (String[])new String[]{"/some/other/url", uuid, "en"});
    }

    @Test
    public void testConflictDuringPublish() {
        this.setupSchema(true);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/some/other/url"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion(nodeResponse.getVersion());
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue2"));
        nodeUpdateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url2"));
        nodeUpdateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url2", "/middle2", "/some/other/url2"}));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        NodeCreateRequest nodeCreateRequest2 = new NodeCreateRequest();
        nodeCreateRequest2.setSchemaName("dummySchema");
        nodeCreateRequest2.setLanguage("en");
        nodeCreateRequest2.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest2.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue1"));
        nodeCreateRequest2.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url1"));
        nodeCreateRequest2.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url1", "/middle", "/some/other/url"}));
        NodeResponse secondNode = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest2, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", secondNode.getUuid(), new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_urlfield_update", (String[])new String[]{"/some/other/url,/middle", uuid, "en"});
    }

    @Test
    public void testNodeWithOnlyUrlField() {
        this.setupSchema(false);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/some/other/url"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
    }

    @Test
    public void testPublishUrlFieldNode() {
        this.setupSchema(false);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/some/other/url"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[]{new VersioningParametersImpl().published()}))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().takeNodeLanguageOffline("dummy", uuid, "en", new ParameterProvider[0]));
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/some/other/url"});
        ClientHelper.call(() -> this.client().publishNode("dummy", uuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[]{new VersioningParametersImpl().published()}))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", uuid, new ParameterProvider[0]));
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[]{new VersioningParametersImpl().published()}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{"/some/other/url"});
    }

    @Test
    public void testMultiLanguageFieldHandling() {
        this.setupSchema(false);
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setSchemaName("dummySchema");
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeCreateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url"));
        nodeCreateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url", "/middle", "/some/other/url"}));
        NodeResponse nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        String uuid = nodeResponse.getUuid();
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("de");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeUpdateRequest.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url2"));
        nodeUpdateRequest.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url2", "/middle2", "/some/other/url2"}));
        NodeResponse updateResponse = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[0]));
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url2", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        Assert.assertEquals((Object)((MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", "slug", "/some/other/url", new ParameterProvider[0]))).getResponseAsPlainText(), (Object)"slugValue");
        NodeUpdateRequest nodeUpdateRequest2 = new NodeUpdateRequest();
        nodeUpdateRequest2.setLanguage("de");
        nodeUpdateRequest2.setVersion(updateResponse.getVersion());
        nodeUpdateRequest2.getFields().put("slug", (Field)FieldUtil.createStringField((String)"slugValue"));
        nodeUpdateRequest2.getFields().put("shortUrl", (Field)FieldUtil.createStringField((String)"/some/other/url2"));
        nodeUpdateRequest2.getFields().put("shortUrlList", (Field)FieldUtil.createStringListField((String[])new String[]{"/some/other/url2", "/middle", "/some/other/url2"}));
        ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest2, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_urlfield_update", (String[])new String[]{"/middle", uuid, "en"});
    }
}

