/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.webrootfield;

import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.FieldTypes;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.impl.BooleanFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.DateFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.FieldList;
import com.gentics.mesh.core.rest.node.field.list.impl.BooleanFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.DateFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NumberFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.node.field.s3binary.S3BinaryUploadRequest;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.S3BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshWebrootFieldResponse;
import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.DateUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(awsContainer=AWSTestMode.MINIO, testSize=TestSize.FULL, startServer=true)
public class WebRootFieldTypeTest
extends AbstractMeshTest {
    @Test
    public void testBinaryExists() throws IOException {
        this.testBinary(true, true);
    }

    @Test
    public void testBinaryNotExists() throws IOException {
        this.testBinary(true, false);
    }

    @Test
    public void testBinaryFieldNotExists() throws IOException {
        this.testBinary(false, false);
    }

    @Test
    public void testS3BinaryExists() throws IOException {
        this.testS3Binary(true, true);
    }

    @Test
    public void testS3BinaryNotExists() throws IOException {
        this.testS3Binary(true, false);
    }

    @Test
    public void testS3BinaryFieldNotExists() throws IOException {
        this.testS3Binary(false, false);
    }

    public void testS3Binary(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        String fileName = "somefile.jpg";
        Optional maybeS3BinaryField = fieldShouldExist ? Optional.of(new S3BinaryFieldSchemaImpl().setAllowedMimeTypes(new String[]{"image/*"}).setName("s3binary").setLabel("S3 Binary content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeS3BinaryContentSupplier = contentShouldExist ? Optional.of(node -> {
            String nodeUuid = (String)this.tx(() -> node.getUuid());
            ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", nodeUuid, "s3binary", new S3BinaryUploadRequest().setFilename(fileName).setLanguage("en").setVersion("1.0"), new ParameterProvider[0]));
            String s3Bucket = this.getTestContext().getOptions().getS3Options().getBucket();
            File tempFile = this.createTempFile();
            this.s3BinaryStorage().createBucket(s3Bucket).flatMap(unused -> this.s3BinaryStorage().uploadFile(s3Bucket, nodeUuid + "/s3binary", tempFile, false)).blockingGet();
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> Assert.assertFalse((boolean)response.isRedirected());
        this.testField("/News/2015/" + fileName, maybeS3BinaryField, maybeS3BinaryContentSupplier, resultsConsumer, true);
    }

    private void testBinary(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        String fileName = "somefile.dat";
        Optional maybeBinaryField = fieldShouldExist ? Optional.of(new BinaryFieldSchemaImpl().setAllowedMimeTypes(new String[]{"image/*"}).setName("binary").setLabel("Binary content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeBinaryContentSupplier = contentShouldExist ? Optional.of(node -> {
            String contentType = "application/octet-stream";
            int binaryLen = 8000;
            ClientHelper.call(() -> this.uploadRandomData((HibNode)node, "en", "binary", binaryLen, contentType, fileName));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            MeshBinaryResponse downloadResponse = response.getBinaryResponse();
            Assert.assertTrue((boolean)response.isBinary());
            Assert.assertFalse((boolean)response.isPlainText());
            Assert.assertNotNull((Object)downloadResponse);
        };
        this.testField("/News/2015/" + fileName, maybeBinaryField, maybeBinaryContentSupplier, resultsConsumer, true);
    }

    @Test
    public void testHtmlExists() throws IOException {
        this.testString(true, true);
    }

    @Test
    public void testHtmlNotExists() throws IOException {
        this.testHtml(true, false);
    }

    @Test
    public void testHtmlFieldNotExists() throws IOException {
        this.testHtml(false, false);
    }

    private void testHtml(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        String value = "<div>This is a hypertext <a href=\"/\">Field Value</a></div>";
        Optional maybeField = fieldShouldExist ? Optional.of(new HtmlFieldSchemaImpl().setName("html_content").setLabel("HTML content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            HtmlFieldImpl html = new HtmlFieldImpl();
            html.setHTML(value);
            request.getFields().put("html_content", (Field)html);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertTrue((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            Assert.assertEquals((Object)response.getResponseAsPlainText(), (Object)value);
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testStringExists() throws IOException {
        this.testString(true, true);
    }

    @Test
    public void testStringNotExists() throws IOException {
        this.testString(true, false);
    }

    @Test
    public void testStringFieldNotExists() throws IOException {
        this.testString(false, false);
    }

    private void testString(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        String value = "String Field Value";
        Optional maybeField = fieldShouldExist ? Optional.of(new StringFieldSchemaImpl().setName("string_content").setLabel("String content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            request.getFields().put("string_content", (Field)StringField.of((String)value));
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertTrue((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            Assert.assertEquals((Object)response.getResponseAsPlainText(), (Object)value);
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testStringListExists() throws IOException {
        this.testStringList(true, true);
    }

    @Test
    public void testStringListNotExists() throws IOException {
        this.testStringList(true, false);
    }

    @Test
    public void testStringListFieldNotExists() throws IOException {
        this.testStringList(false, false);
    }

    private void testStringList(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        this.testList(fieldShouldExist, contentShouldExist, FieldTypes.STRING, "val=1", "2val", "val3", "val 4");
    }

    @Test
    public void testBooleanExists() throws IOException {
        this.testBoolean(true, true);
    }

    @Test
    public void testBooleanNotExists() throws IOException {
        this.testBoolean(true, false);
    }

    @Test
    public void testBooleanFieldNotExists() throws IOException {
        this.testBoolean(false, false);
    }

    private void testBoolean(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        boolean value = true;
        Optional maybeField = fieldShouldExist ? Optional.of(new BooleanFieldSchemaImpl().setName("boolean_content").setLabel("Boolean content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            BooleanFieldImpl field = new BooleanFieldImpl();
            field.setValue(Boolean.valueOf(value));
            request.getFields().put("boolean_content", (Field)field);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertTrue((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            Assert.assertEquals((Object)response.getResponseAsPlainText(), (Object)Boolean.toString(value));
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testBooleanListExists() throws IOException {
        this.testBooleanList(true, true);
    }

    @Test
    public void testBooleanListNotExists() throws IOException {
        this.testBooleanList(true, false);
    }

    @Test
    public void testBooleanListFieldNotExists() throws IOException {
        this.testBooleanList(false, false);
    }

    private void testBooleanList(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        this.testList(fieldShouldExist, contentShouldExist, FieldTypes.BOOLEAN, false, true, false, true, false);
    }

    @Test
    public void testDateExists() throws IOException {
        this.testDate(true, true);
    }

    @Test
    public void testDateNotExists() throws IOException {
        this.testDate(true, false);
    }

    @Test
    public void testDateFieldNotExists() throws IOException {
        this.testDate(false, false);
    }

    private void testDate(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        Calendar now = Calendar.getInstance();
        String nowAsISO = DateUtils.toISO8601((long)now.getTimeInMillis());
        Optional maybeField = fieldShouldExist ? Optional.of(new DateFieldSchemaImpl().setName("date_content").setLabel("Date content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            DateFieldImpl field = new DateFieldImpl();
            field.setDate(nowAsISO);
            request.getFields().put("date_content", (Field)field);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertTrue((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            Calendar parsed = Calendar.getInstance();
            parsed.setTimeInMillis(DateUtils.fromISO8601((String)response.getResponseAsPlainText()));
            Assert.assertEquals((Object)now, (Object)parsed);
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testDateListExists() throws IOException {
        this.testDateList(true, true);
    }

    @Test
    public void testDateListNotExists() throws IOException {
        this.testDateList(true, false);
    }

    @Test
    public void testDateListFieldNotExists() throws IOException {
        this.testDateList(false, false);
    }

    private void testDateList(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        Calendar now = Calendar.getInstance();
        String nowAsISO = DateUtils.toISO8601((long)now.getTimeInMillis());
        this.testList(fieldShouldExist, contentShouldExist, FieldTypes.DATE, nowAsISO, nowAsISO, nowAsISO, nowAsISO);
    }

    @Test
    public void testNumberExists() throws IOException {
        this.testNumber(true, true);
    }

    @Test
    public void testNumberNotExists() throws IOException {
        this.testNumber(true, false);
    }

    @Test
    public void testNumberFieldNotExists() throws IOException {
        this.testNumber(false, false);
    }

    private void testNumber(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        float value = 12345.679f;
        Optional maybeField = fieldShouldExist ? Optional.of(new NumberFieldSchemaImpl().setName("number_content").setLabel("Float number content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            NumberFieldImpl field = new NumberFieldImpl();
            field.setNumber((Number)Float.valueOf(value));
            request.getFields().put("number_content", (Field)field);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertTrue((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            Assert.assertEquals((double)value, (double)Float.parseFloat(response.getResponseAsPlainText()), (double)1.0E-5);
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testNumberListExists() throws IOException {
        this.testNumberList(true, true);
    }

    @Test
    public void testNumberListNotExists() throws IOException {
        this.testNumberList(true, false);
    }

    @Test
    public void testNumberListFieldNotExists() throws IOException {
        this.testNumberList(false, false);
    }

    private void testNumberList(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        List<Double> values = List.of(Integer.valueOf(1234), Integer.valueOf(5678), Double.valueOf(9.1011), Double.valueOf(-1213.1415));
        this.testList(fieldShouldExist, contentShouldExist, FieldTypes.NUMBER, values, Optional.of(response -> {
            Assert.assertFalse((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            JsonArray json = new JsonArray(response.getResponseAsJsonString());
            Assert.assertTrue((boolean)Arrays.equals((Object[])json.stream().map(Number.class::cast).map(Number::doubleValue).collect(Collectors.toList()).toArray(new Double[values.size()]), (Object[])values.stream().map(Number::doubleValue).collect(Collectors.toList()).toArray(new Double[values.size()])));
        }));
    }

    @Test
    public void testMicronodeFieldExists() throws IOException {
        this.testMicronode(true, true);
    }

    @Test
    public void testMicronodeNotExists() throws IOException {
        this.testMicronode(true, false);
    }

    @Test
    public void testMicronodeFieldNotExists() throws IOException {
        this.testMicronode(false, false);
    }

    private void testMicronode(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        HibMicroschema container = this.microschemaContainers().get("vcard");
        MicronodeResponse micronode = new MicronodeResponse();
        MicroschemaReferenceImpl reference = new MicroschemaReferenceImpl();
        reference.setUuid(container.getUuid());
        micronode.getFields().put("firstName", (Field)StringField.of((String)"Mickey"));
        micronode.getFields().put("lastName", (Field)StringField.of((String)"Mouse"));
        micronode.setMicroschema((MicroschemaReference)reference);
        Optional maybeField = fieldShouldExist ? Optional.of(new MicronodeFieldSchemaImpl().setAllowedMicroSchemas(new String[]{"vcard"}).setName("micronode_content").setLabel("Micronode VCARD content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            request.getFields().put("micronode_content", (Field)micronode);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertFalse((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            MicronodeResponse micronodeResponse = (MicronodeResponse)JsonUtil.readValue((String)response.getResponseAsJsonString(), MicronodeResponse.class);
            Assert.assertEquals((Object)reference.getUuid(), (Object)micronodeResponse.getMicroschema().getUuid());
            Assert.assertEquals((Object)"Mickey", (Object)micronodeResponse.getFields().getStringField("firstName").getString());
            Assert.assertEquals((Object)"Mouse", (Object)micronodeResponse.getFields().getStringField("lastName").getString());
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testMicronodeListExists() throws IOException {
        this.testMicronodeList(true, true);
    }

    @Test
    public void testMicronodeListNotExists() throws IOException {
        this.testMicronodeList(true, false);
    }

    @Test
    public void testMicronodeListFieldNotExists() throws IOException {
        this.testMicronodeList(false, false);
    }

    private void testMicronodeList(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        HibMicroschema container = this.microschemaContainers().get("vcard");
        MicroschemaReferenceImpl reference = new MicroschemaReferenceImpl();
        reference.setUuid(container.getUuid());
        List list = IntStream.range(0, 5).mapToObj(i -> {
            MicronodeResponse micronode = new MicronodeResponse();
            micronode.getFields().put("firstName", (Field)StringField.of((String)("Mickey" + i)));
            micronode.getFields().put("lastName", (Field)StringField.of((String)("Mouse" + i)));
            micronode.setMicroschema((MicroschemaReference)reference);
            return micronode;
        }).collect(Collectors.toList());
        Consumer<MeshWebrootFieldResponse> asserter = response -> {
            Assert.assertFalse((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            JsonArray json = new JsonArray(response.getResponseAsJsonString());
            HashSet valuesSet = new HashSet();
            list.forEach(micronode -> {
                valuesSet.add(micronode.getFields().getStringField("firstName").getString());
                valuesSet.add(micronode.getFields().getStringField("lastName").getString());
            });
            Iterator iterator = json.iterator();
            while (iterator.hasNext()) {
                JsonObject result = (JsonObject)iterator.next();
                Assert.assertTrue((boolean)valuesSet.remove(result.getJsonObject("fields").getString("firstName")));
                Assert.assertTrue((boolean)valuesSet.remove(result.getJsonObject("fields").getString("lastName")));
                iterator.remove();
            }
            Assert.assertTrue((boolean)valuesSet.isEmpty());
        };
        this.testList(fieldShouldExist, contentShouldExist, FieldTypes.MICRONODE, list, Optional.of(asserter));
    }

    @Test
    public void testNodeFieldExists() throws IOException {
        this.testNode(true, true);
    }

    @Test
    public void testNodeNotExists() throws IOException {
        this.testNode(true, false);
    }

    @Test
    public void testNodeFieldNotExists() throws IOException {
        this.testNode(false, false);
    }

    private void testNode(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        HibSchema container = this.schemaContainers().get("folder");
        NodeFieldImpl nodeField = new NodeFieldImpl();
        NodeResponse referenced = this.createNode();
        SchemaReferenceImpl reference = new SchemaReferenceImpl();
        reference.setUuid(container.getUuid());
        nodeField.setUuid(referenced.getUuid());
        Optional maybeField = fieldShouldExist ? Optional.of(new NodeFieldSchemaImpl().setAllowedSchemas(new String[]{"folder"}).setName("node_content").setLabel("Node content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            request.getFields().put("node_content", (Field)nodeField);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            Assert.assertFalse((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            NodeResponse nodeResponse = (NodeResponse)JsonUtil.readValue((String)response.getResponseAsJsonString(), NodeResponse.class);
            Assert.assertEquals((Object)referenced.getUuid(), (Object)nodeResponse.getUuid());
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    @Test
    public void testNodeListExists() throws IOException {
        this.testNodeList(true, true);
    }

    @Test
    public void testNodeListNotExists() throws IOException {
        this.testNodeList(true, false);
    }

    @Test
    public void testNodeListFieldNotExists() throws IOException {
        this.testNodeList(false, false);
    }

    private void testNodeList(boolean fieldShouldExist, boolean contentShouldExist) throws IOException {
        HibSchema container = this.schemaContainers().get("folder");
        NodeFieldImpl nodeField = new NodeFieldImpl();
        List list = IntStream.range(0, 5).mapToObj(i -> {
            NodeResponse referenced = this.createNode();
            SchemaReferenceImpl reference = new SchemaReferenceImpl();
            reference.setUuid(container.getUuid());
            nodeField.setUuid(referenced.getUuid());
            return referenced;
        }).collect(Collectors.toList());
        Consumer<MeshWebrootFieldResponse> asserter = response -> {
            Assert.assertFalse((boolean)response.isPlainText());
            Assert.assertFalse((boolean)response.isBinary());
            JsonArray json = new JsonArray(response.getResponseAsJsonString());
            Set valuesSet = list.stream().map(node -> node.getUuid()).collect(Collectors.toSet());
            Iterator iterator = json.iterator();
            while (iterator.hasNext()) {
                JsonObject result = (JsonObject)iterator.next();
                Assert.assertTrue((boolean)valuesSet.remove(result.getString("uuid")));
                iterator.remove();
            }
            Assert.assertTrue((boolean)valuesSet.isEmpty());
        };
        this.testList(fieldShouldExist, contentShouldExist, FieldTypes.NODE, list, Optional.of(asserter));
    }

    private <T> void testList(boolean fieldShouldExist, boolean contentShouldExist, FieldTypes type, T ... listValues) throws IOException {
        List<T> values = Arrays.asList(listValues);
        this.testList(fieldShouldExist, contentShouldExist, type, values, Optional.empty());
    }

    private <T> void testList(boolean fieldShouldExist, boolean contentShouldExist, FieldTypes type, List<T> values, Optional<Consumer<MeshWebrootFieldResponse>> resultsAsserter) throws IOException {
        String itemTypeName = type.name().toLowerCase();
        Optional maybeField = fieldShouldExist ? Optional.of(new ListFieldSchemaImpl().setListType(itemTypeName).setName(itemTypeName + "_list_content").setLabel(itemTypeName.toUpperCase() + " list content")) : Optional.empty();
        Optional<Consumer<HibNode>> maybeContentSupplier = contentShouldExist ? Optional.of(node -> {
            StringFieldListImpl fieldList;
            String uuid = (String)this.tx(() -> node.getUuid());
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}));
            NodeUpdateRequest request = response.toRequest();
            switch (type) {
                case STRING: {
                    fieldList = new StringFieldListImpl();
                    break;
                }
                case HTML: {
                    fieldList = new HtmlFieldListImpl();
                    break;
                }
                case NUMBER: {
                    fieldList = new NumberFieldListImpl();
                    break;
                }
                case DATE: {
                    fieldList = new DateFieldListImpl();
                    break;
                }
                case BOOLEAN: {
                    fieldList = new BooleanFieldListImpl();
                    break;
                }
                case NODE: {
                    fieldList = new NodeFieldListImpl();
                    break;
                }
                case MICRONODE: {
                    fieldList = new MicronodeFieldListImpl();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported list item type: " + type.name());
                }
            }
            values.forEach(arg_0 -> WebRootFieldTypeTest.lambda$testList$52((FieldList)fieldList, arg_0));
            request.getFields().put(itemTypeName + "_list_content", (Field)fieldList);
            ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), request, new ParameterProvider[0]));
        }) : Optional.empty();
        Consumer<MeshWebrootFieldResponse> resultsConsumer = response -> {
            if (resultsAsserter.isPresent()) {
                ((Consumer)resultsAsserter.get()).accept(response);
            } else {
                Assert.assertFalse((boolean)response.isPlainText());
                Assert.assertFalse((boolean)response.isBinary());
                JsonArray json = new JsonArray(response.getResponseAsJsonString());
                Assert.assertTrue((boolean)Arrays.equals(json.getList().toArray(new Object[values.size()]), values.toArray(new Object[values.size()])));
            }
        };
        this.testField("/News/2015/News_2015.en.html", maybeField, maybeContentSupplier, resultsConsumer, false);
    }

    private <F extends FieldSchema> void testField(String path, Optional<F> field, Optional<Consumer<HibNode>> contentSupplier, Consumer<MeshWebrootFieldResponse> resultsConsumer, boolean isBinaryContent) throws IOException {
        String fieldName;
        HibNode node = this.content("news_2015");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        if (field.isPresent()) {
            try (Tx tx = this.tx();){
                FieldSchema schema = (FieldSchema)field.get();
                ContentDao contentDao = tx.contentDao();
                HibSchema container = this.schemaContainer("content");
                node.setSchemaContainer(container);
                contentDao.getLatestDraftFieldContainer(node, this.english()).setSchemaContainerVersion(container.getLatestVersion());
                this.prepareTypedSchema(node, schema, isBinaryContent);
                tx.success();
                fieldName = schema.getName();
            }
            if (contentSupplier.isPresent()) {
                contentSupplier.get().accept(node);
            }
        } else {
            fieldName = "field";
        }
        if (field.isPresent()) {
            if (contentSupplier.isPresent()) {
                MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)ClientHelper.call(() -> this.client().webrootField("dummy", fieldName, path, new ParameterProvider[]{new VersioningParametersImpl().draft(), new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
                if (StringUtils.isNotBlank((CharSequence)response.getNodeUuid())) {
                    Assert.assertEquals((String)"Webroot response node uuid header value did not match", (Object)nodeUuid, (Object)response.getNodeUuid());
                }
                resultsConsumer.accept(response);
            } else if (isBinaryContent) {
                ClientHelper.call(() -> this.client().webrootField("dummy", fieldName, path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
            } else {
                ClientHelper.call(() -> this.client().webrootField("dummy", fieldName, path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_field_not_found_with_name", (String[])new String[]{fieldName});
            }
        } else if (isBinaryContent) {
            ClientHelper.call(() -> this.client().webrootField("dummy", fieldName, path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_not_found_for_path", (String[])new String[]{path});
        } else {
            ClientHelper.call(() -> this.client().webrootField("dummy", fieldName, path, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"error_field_not_found_with_name", (String[])new String[]{fieldName});
        }
    }

    private static /* synthetic */ void lambda$testList$52(FieldList fieldList, Object value) {
        fieldList.add(value);
    }
}

