/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.database;

import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.dao.TagDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.data.tagfamily.HibTagFamily;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.util.TestUtils;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class TxTest
extends AbstractMeshTest {
    @Before
    public void setup() {
        this.mesh().userNameCache().disable();
    }

    @Test
    public void testTransaction() throws InterruptedException {
        AtomicInteger i = new AtomicInteger(0);
        int e = i.incrementAndGet();
        try (Tx tx = this.tx();){
            UserDao userDao = tx.userDao();
            Assert.assertNotNull((Object)userDao.create("testuser" + e, this.user()));
            Assert.assertNotNull((Object)tx.userDao().findByUsername("testuser" + e));
            tx.success();
        }
        tx = this.tx();
        try {
            Assert.assertNotNull((Object)tx.userDao().findByUsername("testuser" + e));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        int u = i.incrementAndGet();
        Runnable task = () -> {
            try (Tx tx2 = this.tx();){
                UserDao userDao = tx2.userDao();
                Assert.assertNotNull((Object)userDao.create("testuser" + u, this.user()));
                Assert.assertNotNull((Object)userDao.findByUsername("testuser" + u));
                tx2.failure();
            }
            Assert.assertNull(this.tx(tx -> tx.userDao().findByUsername("testuser" + u)));
        };
        Thread t = new Thread(task);
        t.start();
        t.join();
        try (Tx tx = this.tx();){
            Assert.assertNull((Object)tx.userDao().findByUsername("testuser" + u));
            System.out.println("RUN: " + i.get());
        }
    }

    @Test
    public void testMultiThreadedModifications() throws InterruptedException {
        Runnable task2 = () -> {
            try (Tx tx = this.tx();){
                HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
                user.setUsername("test2");
                Assert.assertNotNull((Object)tx.userDao().findByUsername("test2"));
                tx.success();
            }
            Runnable task = () -> {
                try (Tx tx = this.tx();){
                    HibUser user = (HibUser)tx.userDao().findByUuid(this.userUuid());
                    user.setUsername("test3");
                    Assert.assertNotNull((Object)tx.userDao().findByUsername("test3"));
                    tx.failure();
                }
            };
            Thread t = new Thread(task);
            t.start();
            try {
                t.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        Thread t2 = new Thread(task2);
        t2.start();
        t2.join();
        try (Tx tx = this.tx();){
            Assert.assertNull((Object)tx.userDao().findByUsername("test3"));
            Assert.assertNotNull((String)"The user with username test2 could not be found.", (Object)tx.userDao().findByUsername("test2"));
        }
    }

    @Test(expected=RuntimeException.class)
    public void testAsyncNoTrxWithError() throws Throwable {
        CompletableFuture cf = new CompletableFuture();
        this.db().asyncTx(() -> {
            throw new RuntimeException("error");
        }).blockingGet();
        Assert.assertEquals((Object)"error", (Object)((Throwable)cf.get()).getMessage());
        throw (Throwable)cf.get();
    }

    @Test
    public void testAsyncNoTrxNestedAsync() throws InterruptedException, ExecutionException {
        String result = (String)this.db().asyncTx(() -> {
            TestUtils.run(() -> TestUtils.sleep((long)1000L));
            return Single.just((Object)"OK");
        }).blockingGet();
        Assert.assertEquals((Object)"OK", (Object)result);
    }

    @Test
    public void testAsyncNoTrxSuccess() throws Throwable {
        String result = (String)this.db().asyncTx(() -> Single.just((Object)"OK")).blockingGet();
        Assert.assertEquals((Object)"OK", (Object)result);
    }

    @Test
    @Ignore
    public void testUpdateMultithreaded() throws InterruptedException, BrokenBarrierException, TimeoutException {
        int nThreads = 10;
        int nRuns = 20;
        int maxRetry = 20;
        for (int r = 0; r < 20; ++r) {
            int currentRun = r;
            System.out.println("\n\n\n\n");
            CyclicBarrier barrierA = new CyclicBarrier(10);
            CyclicBarrier barrierB = new CyclicBarrier(10);
            HibNode node = this.content();
            HibTagFamily tagFamily = this.tagFamily("colors");
            ArrayList<Thread> threads = new ArrayList<Thread>();
            HibProject project = this.project();
            HibUser user = this.user();
            int i = 0;
            while (i < 10) {
                int threadNo = i++;
                System.out.println("Thread [" + threadNo + "] Starting");
                Thread t = TestUtils.run(() -> {
                    for (int retry = 0; retry < 20; ++retry) {
                        try {
                            try (Tx tx = this.tx();){
                                CommonTx ctx = (CommonTx)tx.unwrap();
                                TagDao tagDao = tx.tagDao();
                                if (retry == 0) {
                                    try {
                                        System.out.println("Thread [" + threadNo + "] Waiting..");
                                        barrierA.await(10L, TimeUnit.SECONDS);
                                        System.out.println("Thread [" + threadNo + "] Waited");
                                    }
                                    catch (Exception e) {
                                        System.out.println("Thread [" + threadNo + "] Error handling barrier timeout? - retry: " + retry);
                                    }
                                }
                                HibTagFamily reloadedTagFamily = (HibTagFamily)ctx.load(tagFamily.getId(), ctx.tagFamilyDao().getPersistenceClass((HibCoreElement)this.project()));
                                HibNode reloadedNode = (HibNode)ctx.load(node.getId(), ctx.nodeDao().getPersistenceClass((HibCoreElement)project));
                                HibUser reloadedUser = (HibUser)ctx.load(user.getId(), ctx.userDao().getPersistenceClass());
                                HibProject reloadedProject = (HibProject)ctx.load(project.getId(), ctx.projectDao().getPersistenceClass());
                                HibTag tag = tagDao.create(reloadedTagFamily, "bogus_" + threadNo + "_" + currentRun, this.project(), reloadedUser);
                                tagDao.addTag(reloadedNode, tag, reloadedProject.getLatestBranch());
                                tx.success();
                                if (retry == 0) {
                                    try {
                                        System.out.println("Thread [" + threadNo + "] Waiting..");
                                        barrierB.await(10L, TimeUnit.SECONDS);
                                        System.out.println("Thread [" + threadNo + "] Waited");
                                    }
                                    catch (Exception e) {
                                        System.out.println("Thread [" + threadNo + "] Error handling barrier timeout? - retry: " + retry);
                                    }
                                }
                            }
                            System.out.println("Thread [" + threadNo + "] Successful updated element - retry: " + retry);
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("Thread [" + threadNo + "] Got exception {" + e.getClass().getName() + "}  - retry: " + retry);
                            e.printStackTrace();
                            continue;
                        }
                    }
                });
                threads.add(t);
            }
            System.out.println("Waiting on lock");
            for (Thread currentThread : threads) {
                currentThread.join();
            }
            try (Tx tx = this.tx();){
                CommonTx ctx = (CommonTx)tx.unwrap();
                TagDao tagDao = tx.tagDao();
                int expect = 10 * (r + 1);
                HibNode reloadedNode = (HibNode)ctx.load(node.getId(), ctx.nodeDao().getPersistenceClass((HibCoreElement)project));
                Assert.assertEquals((String)("Expected {" + expect + "} tags since this is run {" + r + "}."), (long)expect, (long)tagDao.getTags(reloadedNode, this.project().getLatestBranch()).count());
                continue;
            }
        }
    }
}

