/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.BranchResponseAssert;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.link.WebRootLinkReplacer;
import com.gentics.mesh.core.rest.branch.BranchCreateRequest;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BranchLinkRendererTest
extends AbstractMeshTest {
    private WebRootLinkReplacer replacer;
    private String branchUuid;
    @Parameterized.Parameter(value=0)
    public String hostname;
    @Parameterized.Parameter(value=1)
    public String pathPrefix;
    @Parameterized.Parameter(value=2)
    public boolean ssl;
    public String contentUuid;
    public String localNodeUuid;
    public String urlFieldNodeUuid;
    public String updatedUuid;
    public String branchName;
    private String latestBranchUuid;

    @Parameterized.Parameters(name="{index}: hostname {0}, pathPrefix {1}, ssl {2}")
    public static Collection<Object[]> params() {
        ArrayList<Object[]> testData = new ArrayList<Object[]>();
        for (String hostname : Arrays.asList("www.nodea.com", "www.nodeb.com", null)) {
            for (String pathPrefix : Arrays.asList("", "/bla", "/bla/blubb", null)) {
                for (boolean ssl : Arrays.asList(true, false)) {
                    testData.add(new Object[]{hostname, pathPrefix, ssl});
                }
            }
        }
        return testData;
    }

    @Before
    public void setupDeps() {
        this.latestBranchUuid = ((BranchResponse)((BranchListResponse)ClientHelper.call(() -> this.client().findBranches("dummy", new ParameterProvider[0]))).getData().get(0)).getUuid();
        SchemaCreateRequest schemaCreateRequest = new SchemaCreateRequest().setAutoPurge(Boolean.valueOf(true)).setContainer(Boolean.valueOf(false)).setName("schema_without_segment").setFields(Arrays.asList(FieldUtil.createStringFieldSchema((String)"url"), FieldUtil.createStringFieldSchema((String)"name"))).setUrlFields(Arrays.asList("url"));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaCreateRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        this.grantAdmin();
        this.contentUuid = (String)this.tx(() -> this.content("news overview").getUuid());
        this.replacer = this.meshDagger().webRootLinkReplacer();
        this.branchName = String.format("%s_%b", this.hostname, this.ssl);
        BranchCreateRequest request = new BranchCreateRequest();
        request.setName(this.branchName);
        request.setHostname(this.hostname);
        request.setLatest(false);
        request.setSsl(Boolean.valueOf(this.ssl));
        request.setPathPrefix(this.pathPrefix);
        this.waitForJobs(() -> {
            BranchResponse response = (BranchResponse)ClientHelper.call(() -> this.client().createBranch("dummy", request, new ParameterProvider[0]));
            ((BranchResponseAssert)((BranchResponseAssert)MeshAssertions.assertThat((BranchResponse)response).as("Branch Response", new Object[0])).isNotNull()).hasName(this.branchName).isActive().isNotMigrated();
            this.branchUuid = response.getUuid();
        }, JobStatus.COMPLETED, 1);
        String folderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid(folderUuid);
        nodeCreateRequest.setSchemaName("content");
        FieldMapImpl fields = new FieldMapImpl();
        fields.put("slug", (Field)FieldUtil.createStringField((String)"localNode"));
        fields.put("content", (Field)FieldUtil.createStringField((String)("Content2: {{mesh.link('" + this.contentUuid + "')}}")));
        fields.put("teaser", (Field)FieldUtil.createStringField((String)"The Local Node teaser"));
        fields.put("title", (Field)FieldUtil.createStringField((String)"The Local Node"));
        nodeCreateRequest.setFields((FieldMap)fields);
        this.localNodeUuid = ((NodeResponse)ClientHelper.call(() -> this.client().createNode(this.projectName(), nodeCreateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.branchName)}))).getUuid();
        this.updatedUuid = this.updateExistingNode();
        this.urlFieldNodeUuid = ((NodeResponse)ClientHelper.call(() -> {
            NodeCreateRequest anotherNodeCreateRequest = new NodeCreateRequest().setLanguage("en").setParentNodeUuid(folderUuid).setSchemaName("schema_without_segment");
            anotherNodeCreateRequest.getFields().put("url", (Field)FieldUtil.createStringField((String)"/this/is/the/url.html"));
            anotherNodeCreateRequest.getFields().put("name", (Field)FieldUtil.createStringField((String)"Node name"));
            return this.client().createNode("dummy", anotherNodeCreateRequest, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.branchName)});
        })).getUuid();
    }

    private String updateExistingNode() {
        NodeResponse node = ((MeshWebrootResponse)ClientHelper.call(() -> this.client().webroot("dummy", "/Deals", new ParameterProvider[0]))).getNodeResponse();
        NodeUpdateRequest updateRequest = node.toRequest();
        node.getFields().putString("slug", "changedDeals");
        ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), updateRequest, new ParameterProvider[0]));
        return node.getUuid();
    }

    @Test
    public void testResolve() {
        String replacedContent = this.replaceContent("{{mesh.link('" + this.contentUuid + "')}}");
        Assert.assertEquals((String)"Check rendered content", (Object)(this.getPrefix() + "/News/News%20Overview.en.html"), (Object)replacedContent);
    }

    @Test
    public void testResolveWithBranchParameter() {
        String replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '%s')}}", this.updatedUuid, this.branchUuid));
        Assert.assertEquals((String)"Check rendered content", (Object)(this.getPrefix() + "/Deals"), (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '%s')}}", this.updatedUuid, this.branchName));
        Assert.assertEquals((String)"Check rendered content", (Object)(this.getPrefix() + "/Deals"), (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '%s')}}", this.updatedUuid, this.latestBranchUuid));
        Assert.assertEquals((String)"Check rendered content", (Object)"/changedDeals", (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '%s')}}", this.updatedUuid, "dummy"));
        Assert.assertEquals((String)"Check rendered content", (Object)"/changedDeals", (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '')}}", this.updatedUuid));
        Assert.assertEquals((String)"Check rendered content", (Object)"/changedDeals", (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', 'abcdefghijklmnop')}}", this.updatedUuid));
        Assert.assertEquals((String)"Check rendered content", (Object)"/changedDeals", (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '72da59204f994856ab97520d3a571f6f')}}", this.updatedUuid));
        Assert.assertEquals((String)"Check rendered content", (Object)"/changedDeals", (Object)replacedContent);
        replacedContent = this.replaceContent(String.format("{{mesh.link('%s', 'en', '%s')}}", this.updatedUuid, ((UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]))).getUuid()));
        Assert.assertEquals((String)"Check rendered content", (Object)"/changedDeals", (Object)replacedContent);
    }

    private String replaceContent(String content) {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            String string = this.replacer.replace(ac, this.branchUuid, ContainerType.DRAFT, content, LinkType.SHORT, null, null);
            return string;
        }
    }

    @Test
    public void testResolveViaRest() {
        NodeParametersImpl nodeParams = new NodeParametersImpl();
        nodeParams.setResolveLinks(LinkType.SHORT);
        VersioningParametersImpl versionParams = new VersioningParametersImpl();
        versionParams.setBranch(this.branchUuid);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), this.contentUuid, new ParameterProvider[]{nodeParams, versionParams}));
        String expectedPath = "/News/News%20Overview.en.html";
        String expectedPathWithPrefix = this.getPrefix() + expectedPath;
        Assert.assertEquals((String)"The path did not match", (Object)expectedPathWithPrefix, (Object)response.getPath());
        NodeResponse response2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), this.localNodeUuid, new ParameterProvider[]{nodeParams, versionParams}));
        String expectedPath2 = this.getPrefix() + "/News/localNode";
        Assert.assertEquals((String)"The path did not match", (Object)expectedPath2, (Object)response2.getPath());
        Assert.assertEquals((Object)("Content2: " + this.getPathPrefix() + expectedPath), (Object)response2.getFields().getStringField("content").getString());
    }

    @Test
    public void testRenderUrlField() {
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)this.replaceContent(String.format("{{mesh.link('%s', 'en', '%s')}}", this.urlFieldNodeUuid, this.branchUuid))).as("URL", new Object[0])).isEqualTo((Object)(this.getPrefix() + "/this/is/the/url.html"));
    }

    @Test
    public void testRenderUrlFieldViaGraphQL() {
        GraphQLRequest request = new GraphQLRequest().setQuery("query nodeByUuid($uuid:String) {\n  node(uuid: $uuid) {\n    path\n  }\n}").setVariables(new JsonObject().put("uuid", (Object)this.urlFieldNodeUuid));
        GraphQLResponse graphQLResponse = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setBranch(this.branchName)}));
        MeshAssertions.assertThat((JsonObject)graphQLResponse.getData()).compliesTo("$.node.path=" + this.getPathPrefix() + "/this/is/the/url.html");
    }

    private String getPrefix() {
        Object prefix = "";
        if (!StringUtils.isEmpty((CharSequence)this.hostname)) {
            prefix = String.format("http%s://%s", this.ssl ? "s" : "", this.hostname);
        }
        prefix = (String)prefix + this.getPathPrefix();
        return prefix;
    }

    private String getPathPrefix() {
        if (this.pathPrefix == null) {
            return "";
        }
        return this.pathPrefix;
    }
}

