/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.link.WebRootLinkReplacer;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class LinkRenderPathPrefixTest
extends AbstractMeshTest {
    private static final String OTHER_PROJECT_NAME = "projectB";
    private WebRootLinkReplacer replacer;
    private NodeResponse nodeResponse;

    @Before
    public void setupDeps() {
        this.replacer = this.meshDagger().webRootLinkReplacer();
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName(OTHER_PROJECT_NAME);
        request.setHostname("dummy.io");
        request.setPathPrefix("some/prefix");
        request.setSsl(true);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ProjectResponse projectResponse = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        ClientHelper.call(() -> this.client().assignSchemaToProject(OTHER_PROJECT_NAME, schemaUuid));
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page.html"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"Blessed mealtime again!"));
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.setParentNodeUuid(projectResponse.getRootNode().getUuid());
        this.nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode(OTHER_PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]));
    }

    @Test
    public void testProjectPrefixLinkRendering() {
        try (Tx tx = this.tx();){
            String content = "{{mesh.link('" + this.nodeResponse.getUuid() + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.initialBranchUuid(), ContainerType.DRAFT, content, LinkType.SHORT, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"https://dummy.io/some/prefix/new-page.html", (Object)replacedContent);
            String linkToNode = this.replacer.resolve(ac, this.initialBranchUuid(), ContainerType.DRAFT, this.nodeResponse.getUuid(), LinkType.SHORT, "en", new String[0]);
            Assert.assertEquals((String)"Check rendered content", (Object)"https://dummy.io/some/prefix/new-page.html", (Object)linkToNode);
            HibNode node = (HibNode)tx.nodeDao().findByUuid((HibCoreElement)((HibProject)tx.projectDao().findByName(OTHER_PROJECT_NAME)), this.nodeResponse.getUuid());
            linkToNode = this.replacer.resolve(ac, this.initialBranchUuid(), ContainerType.DRAFT, node, LinkType.SHORT, new String[]{"en"});
            Assert.assertEquals((String)"Check rendered content", (Object)"https://dummy.io/some/prefix/new-page.html", (Object)linkToNode);
        }
    }
}

