/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class LinkRendererEndpointTest
extends AbstractMeshTest {
    @Test
    public void testLinkReplacerTypeOff() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            this.testSimpleLink(newsNode, LinkType.OFF, "{{mesh.link('" + newsNode.getUuid() + "')}}");
        }
    }

    @Test
    public void testLinkReplacerTypeShort() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            this.testSimpleLink(newsNode, LinkType.SHORT, "/News/News%20Overview.en.html");
        }
    }

    @Test
    public void testLinkReplacerTypeMedium() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            this.testSimpleLink(newsNode, LinkType.MEDIUM, "/dummy/News/News%20Overview.en.html");
        }
    }

    @Test
    public void testLinkReplacerTypeFull() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            this.testSimpleLink(newsNode, LinkType.FULL, "/api/v2/dummy/webroot/News/News%20Overview.en.html");
        }
    }

    @Test
    public void testLinkInJson() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            JsonObject jsonObject = new JsonObject().put("quotes", (Object)("prefix {{mesh.link('" + newsNode.getUuid() + "')}} postfix")).put("doublequotes", (Object)("prefix {{mesh.link(\"" + newsNode.getUuid() + "\")}} postfix")).put("noquotes", (Object)("prefix {{mesh.link(" + newsNode.getUuid() + ")}} postfix"));
            JsonObject expected = new JsonObject().put("quotes", (Object)"prefix /api/v2/dummy/webroot/News/News%20Overview.en.html postfix").put("doublequotes", (Object)"prefix /api/v2/dummy/webroot/News/News%20Overview.en.html postfix").put("noquotes", (Object)"prefix /api/v2/dummy/webroot/News/News%20Overview.en.html postfix");
            JsonObject resultObject = new JsonObject(this.renderContent(jsonObject.encode(), LinkType.FULL));
            for (String attr : Arrays.asList("quotes", "doublequotes", "noquotes")) {
                Assert.assertEquals((String)("Check attribute '" + attr + "'"), (Object)expected.getString(attr), (Object)resultObject.getString(attr));
            }
        }
    }

    @Test
    public void testInvalidLink() {
        try (Tx tx = this.tx();){
            this.testRenderContent("{{mesh.link('" + UUIDUtil.randomUUID() + "')}}", LinkType.FULL, "/api/v2/project/webroot/error/404");
        }
    }

    @Test
    public void testRenderLanguagesWithBranch() {
        String uuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.testRenderContent(String.format("{{mesh.link(%s, %s, %s)}}", uuid, "en", "demo"), LinkType.SHORT, "/News");
        this.testRenderContent(String.format("{{mesh.link(%s, %s, %s)}}", uuid, "de", "demo"), LinkType.SHORT, "/Neuigkeiten");
    }

    private void testSimpleLink(HibNode node, LinkType linkType, String expectedResult) {
        try (Tx tx = this.tx();){
            this.testRenderContent("{{mesh.link('" + node.getUuid() + "')}}", linkType, expectedResult);
        }
    }

    private void testRenderContent(String content, LinkType linkType, String expectedResult) {
        Assert.assertEquals((String)"Check rendered content", (Object)expectedResult, (Object)this.renderContent(content, linkType));
    }

    private String renderContent(String content, LinkType linkType) {
        return (String)ClientHelper.call(() -> this.client().resolveLinks(content, new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(linkType)}));
    }
}

