/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.s3binary.S3HibBinary;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.link.WebRootLinkReplacer;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.S3BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(awsContainer=AWSTestMode.MINIO, testSize=TestSize.FULL, startServer=false)
public class LinkRendererTest
extends AbstractMeshTest {
    private WebRootLinkReplacer replacer;

    @Before
    public void setupDeps() {
        this.replacer = this.meshDagger().webRootLinkReplacer();
    }

    @Test
    public void testLinkReplacerTypeOff() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.OFF, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)content, (Object)replacedContent);
        }
    }

    @Test
    public void testLinkReplacerTypeShort() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.SHORT, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testLinkReplacerTypeMedium() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.MEDIUM, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/dummy/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testLinkReplacerTypeFull() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testLinkAtStart() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}} postfix";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/News/News%20Overview.en.html postfix", (Object)replacedContent);
        }
    }

    @Test
    public void testLinkAtEnd() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "prefix {{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"prefix /api/v2/dummy/webroot/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testLinkInMiddle() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "prefix {{mesh.link('" + uuid + "')}} postfix";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"prefix /api/v2/dummy/webroot/News/News%20Overview.en.html postfix", (Object)replacedContent);
        }
    }

    @Test
    public void testAdjacentLinks() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}}{{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/News/News%20Overview.en.html/api/v2/dummy/webroot/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testNonAdjacentLinks() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}} in between {{mesh.link('" + uuid + "')}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/News/News%20Overview.en.html in between /api/v2/dummy/webroot/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testInvalidLinks() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link('" + uuid + "')}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)content, (Object)replacedContent);
        }
    }

    @Test
    public void testNoQuote() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "'\"{{mesh.link(" + uuid + ")}}\"'";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"'\"/api/v2/dummy/webroot/News/News%20Overview.en.html\"'", (Object)replacedContent);
        }
    }

    @Test
    public void testNoQuoteGerman() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "'\"{{mesh.link(" + uuid + ", de)}}\"'";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"'\"/api/v2/dummy/webroot/Neuigkeiten/News%20Overview.de.html\"'", (Object)replacedContent);
        }
    }

    @Test
    public void testSingleQuote() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "'\"{{mesh.link('" + uuid + "')}}\"'";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"'\"/api/v2/dummy/webroot/News/News%20Overview.en.html\"'", (Object)replacedContent);
        }
    }

    @Test
    public void testDoubleQuote() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "'\"{{mesh.link(\"" + uuid + "\")}}\"'";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"'\"/api/v2/dummy/webroot/News/News%20Overview.en.html\"'", (Object)replacedContent);
        }
    }

    @Test
    public void testGerman() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link(\"" + uuid + "\", \"de\")}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/Neuigkeiten/News%20Overview.de.html", (Object)replacedContent);
        }
    }

    @Test
    public void testEnglish() {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "{{mesh.link(\"" + uuid + "\", \"en\")}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/News/News%20Overview.en.html", (Object)replacedContent);
        }
    }

    @Test
    public void testNodeReplace() throws IOException, InterruptedException, ExecutionException {
        try (Tx tx = this.tx();){
            NodeDao nodeDao = tx.nodeDao();
            String german = this.german();
            String english = this.english();
            HibNode parentNode = this.folder("2015");
            HibSchemaVersion schemaVersion = (HibSchemaVersion)this.schemaContainer("content").getLatestVersion();
            schemaVersion.getSchema().addField((FieldSchema)new StringFieldSchemaImpl().setName("displayName")).addField((FieldSchema)new StringFieldSchemaImpl().setName("name"));
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)schemaVersion);
            HibNode content = nodeDao.create(parentNode, this.user(), schemaVersion, this.project());
            HibNodeFieldContainer germanContainer = tx.contentDao().createFieldContainer(content, german, content.getProject().getLatestBranch(), this.user());
            germanContainer.createString("displayName").setString("german name");
            germanContainer.createString("name").setString("german.html");
            HibNode content2 = nodeDao.create(parentNode, this.user(), (HibSchemaVersion)this.schemaContainer("content").getLatestVersion(), this.project());
            HibNodeFieldContainer englishContainer = tx.contentDao().createFieldContainer(content2, english, content2.getProject().getLatestBranch(), this.user());
            englishContainer.createString("displayName").setString("content 2 english");
            englishContainer.createString("name").setString("english.html");
            InternalActionContext ac = this.mockActionContext();
            this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, "dgasd", null, null, null);
        }
    }

    @Test
    public void testBinaryFieldLinkResolving() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.content("news overview");
            String uuid = node.getUuid();
            String fileName = "somefile.dat";
            SchemaVersionModel schema = ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField((FieldSchema)new BinaryFieldSchemaImpl().setName("binary").setLabel("Binary content"));
            schema.setSegmentField("binary");
            ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()));
            HibBinary binary = (HibBinary)tx.binaries().create("bogus", 1L).runInExistingTx(tx);
            contentDao.getLatestDraftFieldContainer(node, this.english()).createBinary("binary", binary).setFileName(fileName);
            String meshLink = "{{mesh.link(\"" + uuid + "\", \"en\")}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, meshLink, LinkType.FULL, null, null);
            Assert.assertEquals((String)"Check rendered content", (Object)"/api/v2/dummy/webroot/News/somefile.dat", (Object)replacedContent);
        }
    }

    @Test
    public void testS3BinaryFieldLinkResolving() {
        String fileName = "somefile.jpg";
        String s3Bucket = this.getTestContext().getOptions().getS3Options().getBucket();
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.content("news overview");
            String uuid = node.getUuid();
            SchemaVersionModel schema = ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField((FieldSchema)new S3BinaryFieldSchemaImpl().setName("s3binary").setLabel("Binary content"));
            schema.setSegmentField("s3binary");
            ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()));
            S3HibBinary binary = (S3HibBinary)tx.s3binaries().create(UUIDUtil.randomUUID(), s3Bucket, fileName).runInExistingTx(tx);
            HibNodeFieldContainer original = contentDao.getLatestDraftFieldContainer(node, this.english());
            HibNodeFieldContainer newBinary = contentDao.createFieldContainer(node, this.english(), this.project().getLatestBranch(), this.user(), original, true);
            newBinary.createS3Binary("s3binary", binary).setFileName(fileName);
            File tempFile = this.createTempFile();
            this.s3BinaryStorage().createBucket(s3Bucket).flatMap(unused -> this.s3BinaryStorage().uploadFile(s3Bucket, uuid + "/s3binary", tempFile, false)).blockingGet();
            String meshLink = "{{mesh.link(\"" + uuid + "\", \"en\")}}";
            InternalActionContext ac = this.mockActionContext();
            String replacedContent = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, meshLink, LinkType.FULL, null, null);
            Assert.assertTrue((boolean)replacedContent.matches("https?:\\/\\/[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)\\/" + s3Bucket + "/" + s3Bucket + "\\?X-Amz-Algorithm=[-A-Z0-9]{1,256}&X-Amz-Date=[0-9]{8}T[0-9]{6}Z&X-Amz-SignedHeaders=host&X-Amz-Expires=[0-9]{1,256}&X-Amz-Credential=accessKey%2F[0-9]{8}%2Feu-central-1%2Fs3%2Faws4_request&X-Amz-Signature=[a-z0-9]{1,256}"));
        }
    }

    @Test
    public void testResolving() throws InterruptedException, ExecutionException {
        try (Tx tx = this.tx();){
            HibNode newsNode = this.content("news overview");
            String uuid = newsNode.getUuid();
            String content = "some bla START<a href=\"{{mesh.link('" + uuid + "','en')}}\">Test</a>   dasasdg <a href=\"{{mesh.link(\"" + uuid + "\")}}\">Test</a>DEN";
            System.out.println("From: " + content);
            InternalActionContext ac = this.mockActionContext();
            String output = this.replacer.replace(ac, this.project().getLatestBranch().getUuid(), ContainerType.DRAFT, content, null, null, null);
            System.out.println("To:   " + output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRendering() throws IOException {
        try (Tx tx = this.tx();){
            String uuid = UUIDUtil.randomUUID();
            String content = "some bla START<a href=\"{{mesh.link(\"" + uuid + "\")}}\">Test</a>   dasasdg <a href=\"{{mesh.link(\"" + uuid + "\")}}\">Test</a>DEN";
            System.out.println(content);
            int start = content.indexOf("{{mesh.link(");
            int stop = content.lastIndexOf(")}}") + 3;
            int len = stop - start;
            System.out.println("from " + start + " to " + stop + " len " + len);
            try (InputStream in = IOUtils.toInputStream((String)content);){
                int c;
                int e = 0;
                while ((c = in.read()) != -1) {
                    if (e >= start && e < stop) {
                        in.skip(len);
                        System.out.print("Hugsdibugsdi");
                        e = stop;
                    } else {
                        System.out.print((char)c);
                    }
                    ++e;
                }
            }
        }
    }
}

