/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.link.WebRootLinkReplacer;
import com.gentics.mesh.core.rest.branch.BranchListResponse;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.mock.Mocks;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
@RunWith(value=Parameterized.class)
public class LinkReplacerVariationTest
extends AbstractMeshTest {
    private static final String PROJECT_NAME = "Testproject";
    @Parameterized.Parameter(value=0)
    public boolean folderEn;
    @Parameterized.Parameter(value=1)
    public boolean folderDe;
    @Parameterized.Parameter(value=2)
    public boolean contentEn;
    @Parameterized.Parameter(value=3)
    public boolean contentDe;
    @Parameterized.Parameter(value=4)
    public String language;
    @Parameterized.Parameter(value=5)
    public String linkLanguage;
    @Parameterized.Parameter(value=6)
    public LinkType linkType;
    private WebRootLinkReplacer replacer;
    private String projectUuid;
    private String branchUuid;
    private String folderUuid;
    private String contentUuid;
    private String otherFolderUuid;
    private String otherContentUuid;
    private String expected;
    private String expectedForEn;
    private String expectedForDe;

    @Parameterized.Parameters(name="{index}: folder in en: {0}, folder in de: {1}, content in en {2}, content in de {3}, language {4}, link language {5}, link type {6}")
    public static Collection<Object[]> paramData() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (boolean folderEn : Arrays.asList(true, false)) {
            for (boolean folderDe : Arrays.asList(true, false)) {
                if (!folderEn && !folderDe) continue;
                for (boolean contentEn : Arrays.asList(true, false)) {
                    for (boolean contentDe : Arrays.asList(true, false)) {
                        if (!contentEn && !contentDe) continue;
                        for (String language : Arrays.asList("en", "de")) {
                            for (String linkLanguage : Arrays.asList("en", "de", null)) {
                                for (LinkType linkType : Arrays.asList(LinkType.SHORT, LinkType.MEDIUM, LinkType.FULL)) {
                                    data.add(new Object[]{folderEn, folderDe, contentEn, contentDe, language, linkLanguage, linkType});
                                }
                            }
                        }
                    }
                }
            }
        }
        return data;
    }

    @Before
    public void setup() {
        this.replacer = this.meshDagger().webRootLinkReplacer();
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName(PROJECT_NAME);
        request.setHostname("dummy.io");
        request.setSsl(false);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        ProjectResponse projectResponse = (ProjectResponse)ClientHelper.call(() -> this.client().createProject(request));
        this.projectUuid = projectResponse.getUuid();
        this.branchUuid = ((BranchListResponse)ClientHelper.call(() -> this.client().findBranches(PROJECT_NAME, new ParameterProvider[0]))).getData().stream().filter(BranchResponse::getLatest).findFirst().orElseThrow().getUuid();
        String schemaUuid = (String)this.tx(() -> this.schemaContainer("content").getUuid());
        ClientHelper.call(() -> this.client().assignSchemaToProject(PROJECT_NAME, schemaUuid));
        if (this.folderEn) {
            this.folderUuid = this.createFolder(projectResponse.getRootNode().getUuid(), this.folderUuid, "targetfolder", "en");
        }
        if (this.folderDe) {
            this.folderUuid = this.createFolder(projectResponse.getRootNode().getUuid(), this.folderUuid, "zielordner", "de");
        }
        if (this.contentEn) {
            this.contentUuid = this.createContent(this.folderUuid, this.contentUuid, "targetcontent", "en");
        }
        if (this.contentDe) {
            this.contentUuid = this.createContent(this.folderUuid, this.contentUuid, "zielinhalt", "de");
        }
        this.otherFolderUuid = this.createFolder(projectResponse.getRootNode().getUuid(), this.otherFolderUuid, "otherfolder", "en");
        this.otherFolderUuid = this.createFolder(projectResponse.getRootNode().getUuid(), this.otherFolderUuid, "andererordner", "de");
        this.otherContentUuid = this.createContent(this.otherFolderUuid, this.otherContentUuid, "othercontent", "en");
        this.otherContentUuid = this.createContent(this.otherFolderUuid, this.otherContentUuid, "andererinhalt", "de");
        String expectedLanguage = this.linkLanguage;
        if (StringUtils.isBlank((CharSequence)expectedLanguage)) {
            expectedLanguage = this.language;
        }
        this.expected = this.fixForLinkType(this.getExpectedForLanguage(expectedLanguage));
        this.expectedForEn = this.fixForLinkType(this.getExpectedForLanguage("en"));
        this.expectedForDe = this.fixForLinkType(this.getExpectedForLanguage("de"));
    }

    @Test
    public void testReplace() {
        try (Tx tx = this.tx();){
            String content = String.format("{{mesh.link('%s'%s)}}", this.contentUuid, this.linkLanguage != null ? ", '" + this.linkLanguage + "'" : "");
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid);
            InternalActionContext ac = Mocks.getMockedInternalActionContext("", this.user(), project);
            ac.setParameter("branch", PROJECT_NAME);
            String replacedContent = this.replacer.replace(ac, this.branchUuid, ContainerType.DRAFT, content, this.linkType, PROJECT_NAME, Arrays.asList(this.language));
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)replacedContent).as("Rendered link", new Object[0])).isEqualTo((Object)this.expected);
            tx.success();
        }
    }

    @Test
    public void testReplaceMany() {
        try (Tx tx = this.tx();){
            String link = String.format("{{mesh.link('%s'%s)}}", this.contentUuid, this.linkLanguage != null ? ", '" + this.linkLanguage + "'" : "");
            String linkDe = String.format("{{mesh.link('%s', 'de')}}", this.contentUuid);
            String linkEn = String.format("{{mesh.link('%s', 'en')}}", this.contentUuid);
            String notFoundLink = String.format("{{mesh.link('%s')}}", UUIDUtil.randomUUID());
            String expectedNotFound = this.fixForLinkType("/error/404");
            String composed = String.format("link1: %s, link2: %s, link3: %s, link4: %s", link, notFoundLink, linkDe, linkEn);
            String expectedForComposed = String.format("link1: %s, link2: %s, link3: %s, link4: %s", this.expected, expectedNotFound, this.expectedForDe, this.expectedForEn);
            HibProject project = (HibProject)tx.projectDao().findByUuid(this.projectUuid);
            InternalActionContext ac = Mocks.getMockedInternalActionContext("", this.user(), project);
            ac.setParameter("branch", PROJECT_NAME);
            Map replacedContents = this.replacer.replaceMany(ac, this.branchUuid, ContainerType.DRAFT, (Set)SetUtils.hashSet((Object[])new String[]{link, notFoundLink, linkDe, linkEn, composed}), this.linkType, PROJECT_NAME, new String[]{this.language});
            ((MapAssert)Assertions.assertThat((Map)replacedContents).as("Rendered link", new Object[0])).containsOnly(new Map.Entry[]{Assertions.entry((Object)link, (Object)this.expected), Assertions.entry((Object)notFoundLink, (Object)expectedNotFound), Assertions.entry((Object)linkDe, (Object)this.expectedForDe), Assertions.entry((Object)linkEn, (Object)this.expectedForEn), Assertions.entry((Object)composed, (Object)expectedForComposed)});
            tx.success();
        }
    }

    protected String createFolder(String parentUuid, String uuid, String slug, String language) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNodeUuid(parentUuid);
        nodeCreateRequest.setLanguage(language);
        nodeCreateRequest.setSchemaName("folder");
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)slug));
        if (uuid != null) {
            return ((NodeResponse)ClientHelper.call(() -> this.client().createNode(uuid, PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]))).getUuid();
        }
        return ((NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]))).getUuid();
    }

    protected String createContent(String parentUuid, String uuid, String slug, String language) {
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNodeUuid(parentUuid);
        nodeCreateRequest.setLanguage(language);
        nodeCreateRequest.setSchemaName("content");
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)slug));
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"teaser"));
        nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)"content"));
        if (uuid != null) {
            return ((NodeResponse)ClientHelper.call(() -> this.client().createNode(uuid, PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]))).getUuid();
        }
        return ((NodeResponse)ClientHelper.call(() -> this.client().createNode(PROJECT_NAME, nodeCreateRequest, new ParameterProvider[0]))).getUuid();
    }

    protected String getExpectedForLanguage(String language) {
        switch (language) {
            case "en": {
                if (this.contentEn) {
                    if (this.folderEn) {
                        return "/targetfolder/targetcontent";
                    }
                    return "/zielordner/targetcontent";
                }
                return "/error/404";
            }
            case "de": {
                if (this.contentDe) {
                    if (this.folderDe) {
                        return "/zielordner/zielinhalt";
                    }
                    return "/targetfolder/zielinhalt";
                }
                if (this.folderDe) {
                    return "/zielordner/targetcontent";
                }
                return "/targetfolder/targetcontent";
            }
        }
        Assertions.fail((String)("Unexpected language " + language));
        return null;
    }

    protected String fixForLinkType(String link) {
        switch (this.linkType) {
            case MEDIUM: {
                return String.format("/%s%s", PROJECT_NAME, link);
            }
            case FULL: {
                return String.format("/api/v2/%s/webroot%s", PROJECT_NAME, link);
            }
        }
        return link;
    }
}

