/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.branch.BranchResponse;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class ResolveLinksEndpointTest
extends AbstractMeshTest {
    private NodeResponse nodeWithReference;

    @Before
    public void setUp() throws Exception {
        BranchResponse branch = this.getBranch();
        branch.setSsl(Boolean.valueOf(true));
        branch.setHostname("gentics.com");
        this.client().updateBranch("dummy", branch.getUuid(), branch.toRequest()).blockingAwait();
        this.nodeWithReference = this.createNode("name", (Field)StringField.of((String)("{{mesh.link('" + this.folderUuid() + "')}}")));
    }

    @Test
    public void testShortLink() {
        MeshAssertions.assertThat((NodeResponse)this.getNodeWithReference(LinkType.SHORT)).hasStringField("name", "/News");
    }

    @Test
    public void testShortLinkGraphQl() {
        GraphQLResponse response = (GraphQLResponse)this.client().graphql("dummy", new GraphQLRequest().setQuery("query($uuid: String) { node(uuid: $uuid) { ... on folder { fields { name(linkType: SHORT) } } } }").setVariables(new JsonObject().put("uuid", (Object)this.nodeWithReference.getUuid())), new ParameterProvider[0]).blockingGet();
        MeshAssertions.assertThat((String)response.getData().getJsonObject("node").getJsonObject("fields").getString("name")).isEqualTo((Object)"/News");
    }

    @Test
    public void testMediumLink() {
        MeshAssertions.assertThat((NodeResponse)this.getNodeWithReference(LinkType.MEDIUM)).hasStringField("name", "/dummy/News");
    }

    @Test
    public void testFullLink() {
        MeshAssertions.assertThat((NodeResponse)this.getNodeWithReference(LinkType.FULL)).hasStringField("name", "/api/v2/dummy/webroot/News");
    }

    private NodeResponse getNodeWithReference(LinkType linkType) {
        return (NodeResponse)this.client().findNodeByUuid("dummy", this.nodeWithReference.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(linkType)}).blockingGet();
    }
}

