/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.linkrenderer;

import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class ResolveUrlFieldsTest
extends AbstractMeshTest {
    public static final String SCHEMA_NAME = "urlFieldSchema";
    private String parentNodeUuid;

    @Before
    public void setUp() {
        this.parentNodeUuid = this.getProject().getRootNode().getUuid();
    }

    @Test
    public void testSingleStringField() {
        this.addSchema(new FieldSchema[]{new StringFieldSchemaImpl().setName("url")});
        NodeResponse referencedNode = this.addNode(FieldMap.of((String)"url", (Field)StringField.of((String)"/some/test/url")));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/test/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    @Test
    public void testMultipleStringFields() {
        this.addSchema(new FieldSchema[]{new StringFieldSchemaImpl().setName("url"), new StringFieldSchemaImpl().setName("url2")});
        NodeResponse referencedNode = this.addNode(FieldMap.of((String)"url2", (Field)StringField.of((String)"/some/test/url")));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/test/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    @Test
    public void testStringListField() {
        this.addSchema(new ListFieldSchemaImpl().setListType("string").setName("urls"));
        NodeResponse referencedNode = this.addNode(FieldMap.of((String)"urls", (Field)StringFieldListImpl.of((String[])new String[]{"/some/test/url", "/some/other/url"})));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/test/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    @Test
    public void testStringListFieldWithEmptyEntry() {
        this.addSchema(new ListFieldSchemaImpl().setListType("string").setName("urls"));
        NodeResponse referencedNode = this.addNode(FieldMap.of((String)"urls", (Field)StringFieldListImpl.of((String[])new String[]{"", "/some/other/url"})));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/other/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    @Test
    public void testMultipleStringListFields() {
        this.addSchema(new ListFieldSchemaImpl().setListType("string").setName("urls"), new ListFieldSchemaImpl().setListType("string").setName("urls2"));
        NodeResponse referencedNode = this.addNode(FieldMap.of((String)"urls", (Field)StringFieldListImpl.of((String[])new String[]{"/some/test/url", "/some/other/url"}), (String)"urls2", (Field)StringFieldListImpl.of((String[])new String[]{"/some/test/url2", "/some/other/url2"})));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/test/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    @Test
    public void testMixedFields() {
        this.addSchema(new FieldSchema[]{new ListFieldSchemaImpl().setListType("string").setName("urls"), new StringFieldSchemaImpl().setName("url")});
        NodeResponse referencedNode = this.addNode(FieldMap.of((String)"url", (Field)StringField.of((String)"/some/test/url")));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/test/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    @Test
    public void testWithMissingParentSegment() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName(SCHEMA_NAME);
        request.setFields(Arrays.asList(new StringFieldSchemaImpl().setName("url"), new StringFieldSchemaImpl().setName("slug")));
        request.setUrlFields(new String[]{"url"});
        request.setSegmentField("slug");
        SchemaResponse schemaResponse = (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()).blockingAwait();
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.setParentNodeUuid(this.parentNodeUuid);
        nodeCreateRequest.setSchemaName("folder");
        NodeResponse parentNode = (NodeResponse)this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]).blockingGet();
        NodeResponse referencedNode = this.addNode(parentNode.getUuid(), FieldMap.of((String)"url", (Field)StringField.of((String)"/some/test/url"), (String)"slug", (Field)StringField.of((String)"testSlug")));
        String result = this.resolveLink(referencedNode);
        Assertions.assertThat((String)result).isEqualTo((Object)"/some/test/url");
        String resultUuid = ((MeshWebrootResponse)this.client().webroot("dummy", result, new ParameterProvider[0]).blockingGet()).getNodeUuid();
        Assertions.assertThat((String)referencedNode.getUuid()).isEqualTo((Object)resultUuid);
    }

    private String resolveLink(NodeResponse referencedNode) {
        return (String)this.client().resolveLinks(this.createLink(referencedNode.getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.SHORT)}).blockingGet();
    }

    private SchemaResponse addSchema(FieldSchema ... fieldSchemas) {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName(SCHEMA_NAME);
        request.setFields(Arrays.asList(fieldSchemas));
        request.setUrlFields(Stream.of(fieldSchemas).map(FieldSchema::getName).collect(Collectors.toList()));
        SchemaResponse schemaResponse = (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()).blockingAwait();
        return schemaResponse;
    }

    private NodeResponse addReferencingNode(NodeResponse referencedNode) {
        NodeCreateRequest request = new NodeCreateRequest();
        request.setParentNodeUuid(this.parentNodeUuid);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.setLanguage("en");
        request.setFields(FieldMap.of((String)"content", (Field)StringField.of((String)this.createLink(referencedNode.getUuid()))));
        return (NodeResponse)this.client().createNode("dummy", request, new ParameterProvider[0]).blockingGet();
    }

    private NodeResponse addNode(String parentNodeUuid, FieldMap fields) {
        NodeCreateRequest request = new NodeCreateRequest();
        request.setParentNodeUuid(parentNodeUuid);
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName(SCHEMA_NAME));
        request.setLanguage("en");
        request.setFields(fields);
        return (NodeResponse)this.client().createNode("dummy", request, new ParameterProvider[0]).blockingGet();
    }

    private NodeResponse addNode(FieldMap fields) {
        return this.addNode(this.parentNodeUuid, fields);
    }

    private String createLink(String uuid) {
        return String.format("{{mesh.link('%s')}}", uuid);
    }
}

