/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.impl.MeshAuthUserImpl;
import com.gentics.mesh.core.data.project.HibProject;
import com.gentics.mesh.core.data.user.HibUser;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Database;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.util.HttpQueryUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;

public final class Mocks {
    private Mocks() {
    }

    public static InternalActionContext getMockedInternalActionContext(String query, HibUser user, HibProject project) {
        return Mocks.getMockedInternalActionContext(query, user, project, null);
    }

    public static <T> InternalActionContext getMockedInternalActionContext(String query, HibUser user, HibProject project, T body) {
        InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(Mocks.getMockedRoutingContext(query, false, user, null, body));
        ac.data().put("mesh.project", project);
        ac.put("apiversion", (Object)2);
        return ac;
    }

    public static RoutingContext getMockedRoutingContext(String query, boolean noInternalMap, HibUser user, HibProject project) {
        return Mocks.getMockedRoutingContext(query, noInternalMap, user, project, null);
    }

    public static <T> RoutingContext getMockedRoutingContext(String query, boolean noInternalMap, HibUser user, HibProject project, T body) {
        HashMap map = new HashMap();
        if (noInternalMap) {
            map = null;
        }
        RoutingContext rc = (RoutingContext)Mockito.mock(RoutingContext.class);
        Session session = (Session)Mockito.mock(Session.class);
        HttpServerRequest request = (HttpServerRequest)Mockito.mock(HttpServerRequest.class);
        CommonTx ctx = CommonTx.get();
        Database db = ctx != null ? ctx.data().mesh().database() : (Database)Mockito.mock(Database.class);
        Mockito.when((Object)request.query()).thenReturn((Object)query);
        Map paramMap = HttpQueryUtils.splitQuery((String)query);
        MultiMap paramMultiMap = MultiMap.caseInsensitiveMultiMap();
        for (Map.Entry entry2 : paramMap.entrySet()) {
            paramMultiMap.add((String)entry2.getKey(), (String)entry2.getValue());
        }
        Mockito.when((Object)request.params()).thenReturn((Object)paramMultiMap);
        Mockito.when((Object)request.getParam(Mockito.anyString())).thenAnswer(in -> {
            String key = (String)in.getArguments()[0];
            return paramMap.get(key);
        });
        paramMap.entrySet().stream().forEach(entry -> Mockito.when((Object)request.getParam((String)entry.getKey())).thenReturn((Object)((String)entry.getValue())));
        if (user != null) {
            MeshAuthUserImpl requestUser = MeshAuthUserImpl.create((Database)db, (HibUser)user);
            Mockito.when((Object)rc.user()).thenReturn((Object)requestUser);
        }
        Mockito.when((Object)rc.data()).thenReturn(map);
        MultiMap headerMap = (MultiMap)Mockito.mock(MultiMap.class);
        Mockito.when((Object)headerMap.get("Accept-Language")).thenReturn((Object)"en, en-gb;q=0.8, en;q=0.72");
        Mockito.when((Object)request.headers()).thenReturn((Object)headerMap);
        Mockito.when((Object)rc.request()).thenReturn((Object)request);
        Mockito.when((Object)rc.session()).thenReturn((Object)session);
        if (project != null) {
            Mockito.when((Object)rc.get("mesh.project")).thenReturn((Object)project);
        }
        if (body != null) {
            try {
                Mockito.when((Object)rc.getBodyAsString()).thenReturn((Object)JsonUtil.getMapper().writeValueAsString(body));
            }
            catch (JsonProcessingException e) {
                Assertions.fail((String)"Could not transform body to string", (Throwable)e);
            }
        }
        return rc;
    }
}

