/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.plugin;

import com.gentics.mesh.core.rest.plugin.PluginDeploymentRequest;
import com.gentics.mesh.core.rest.plugin.PluginListResponse;
import com.gentics.mesh.core.rest.plugin.PluginResponse;
import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.plugin.manager.MeshPluginManager;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;

public class AbstractPluginTest
extends AbstractMeshTest {
    public static final String PLUGINS_BASE = "/test-plugins/";
    public static final String BASIC_PATH = "/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar";
    public static final String BASIC2_PATH = "/test-plugins/basic2/target/basic2-plugin-0.0.1-SNAPSHOT.jar";
    public static final String STATIC_PATH = "/test-plugins/static/target/static-plugin-0.0.1-SNAPSHOT.jar";
    public static final String STATIC2_PATH = "/test-plugins/static2/target/static2-plugin-0.0.1-SNAPSHOT.jar";
    public static final String CLIENT_PATH = "/test-plugins/client/target/client-plugin-0.0.1-SNAPSHOT.jar";
    public static final String FAILING_PATH = "/test-plugins/failing/target/failing-plugin-0.0.1-SNAPSHOT.jar";
    public static final String NON_MESH_PATH = "/test-plugins/non-mesh/target/non-mesh-plugin-0.0.1-SNAPSHOT.jar";
    public static final String CLASSLOADER_PATH = "/test-plugins/classloader/target/classloader-plugin-0.0.1-SNAPSHOT.jar";
    public static final String EXTENSION_PROVIDER_PATH = "/test-plugins/extension-provider/target/extension-provider-plugin-0.0.1-SNAPSHOT.jar";
    public static final String EXTENSION_CONSUMER_PATH = "/test-plugins/extension-consumer/target/extension-consumer-plugin-0.0.1-SNAPSHOT.jar";
    public static final String GRAPHQL_PATH = "/test-plugins/graphql/target/graphql-plugin-0.0.1-SNAPSHOT.jar";
    public static final String INVALID_GRAPHQL_PATH = "/test-plugins/invalid-graphql/target/invalid-graphql-plugin-0.0.1-SNAPSHOT.jar";

    @Before
    public void preparePluginDir() throws IOException {
        MeshPluginManager manager = this.pluginManager();
        manager.stop().blockingAwait(15L, TimeUnit.SECONDS);
        manager.start();
        this.cleanup();
    }

    @After
    public void cleanup() throws IOException {
        this.grantAdmin();
        PluginListResponse plugins = (PluginListResponse)ClientHelper.call(() -> this.client().findPlugins(new ParameterProvider[0]));
        for (PluginResponse plugin : plugins.getData()) {
            ClientHelper.call(() -> this.client().undeployPlugin(plugin.getId()));
        }
        File dir = new File(this.pluginDir());
        if (dir.exists()) {
            FileUtils.forceDelete((File)dir);
        }
        dir.mkdirs();
    }

    public void setPluginBaseDir(String baseDir) {
        File pluginDir = new File(baseDir);
        pluginDir.mkdirs();
        MeshOptions options = testContext.getOptions();
        options.setPluginDirectory(baseDir);
        this.pluginManager().start();
    }

    public void copy(String sourcePath, String name) throws IOException {
        AbstractPluginTest.copyFromResources(this.getClass(), sourcePath, this.pluginDir(), name);
    }

    public PluginResponse copyAndDeploy(String sourcePath, String name) throws IOException {
        this.copy(sourcePath, name);
        PluginDeploymentRequest request = new PluginDeploymentRequest().setPath(name);
        return (PluginResponse)ClientHelper.call(() -> this.client().deployPlugin(request));
    }

    public void copyAndDeploy(String sourcePath, String name, HttpResponseStatus status, String key, String ... params) throws IOException {
        this.copy(sourcePath, name);
        PluginDeploymentRequest request = new PluginDeploymentRequest().setPath(name);
        ClientHelper.call(() -> this.client().deployPlugin(request), (HttpResponseStatus)status, (String)key, (String[])params);
    }

    public static void copyFromResources(Class<?> cls, String sourcePath, String targetPath, String name) throws IOException {
        new File(targetPath).mkdirs();
        try (InputStream sourceRes = cls.getResourceAsStream(sourcePath);){
            Files.copy(sourceRes, new File(targetPath, name).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

