/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.plugin;

import com.gentics.mesh.RestAPIVersion;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.plugin.AbstractPlugin;
import com.gentics.mesh.plugin.env.PluginEnvironment;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.rest.client.MeshRestClientConfig;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.vertx.core.eventbus.MessageConsumer;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import org.pf4j.PluginWrapper;

public class BackupPlugin
extends AbstractPlugin {
    protected static AtomicBoolean firstStart = new AtomicBoolean(true);

    public BackupPlugin(PluginWrapper wrapper, PluginEnvironment env) {
        super(wrapper, env);
    }

    public Completable initialize() {
        if (firstStart.getAndSet(false)) {
            return this.invokeBackupAndFail();
        }
        return Completable.complete();
    }

    protected Completable invokeBackupAndFail() {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().callTimeout(Duration.ofMillis(1L)).connectTimeout(Duration.ofMillis(1L)).writeTimeout(Duration.ofMillis(1L)).readTimeout(Duration.ofMillis(1L)).build();
        int port = this.environment().options().getHttpServerOptions().getPort();
        String host = "127.0.0.1";
        MeshRestClient client = MeshRestClient.create((MeshRestClientConfig)MeshRestClientConfig.newConfig().setPort(port).setHost(host).setBasePath(RestAPIVersion.V1.getBasePath()).build(), (OkHttpClient)okHttpClient);
        client.setAPIKey(this.environment().adminToken());
        return client.invokeBackup().toCompletable().onErrorResumeNext(t -> this.waitForEvent(10000)).andThen((CompletableSource)Completable.error((Throwable)new RuntimeException()));
    }

    protected Completable waitForEvent(int timeoutMs) {
        return Completable.fromAction(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            MessageConsumer consumer = this.vertx().eventBus().consumer(MeshEvent.CLUSTER_DATABASE_CHANGE_STATUS.address);
            consumer.handler(msg -> latch.countDown());
            consumer.completionHandler(res -> {
                if (res.failed()) {
                    throw new RuntimeException("Could not listen to event", res.cause());
                }
            });
            try {
                if (!latch.await(timeoutMs, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Timeout while waiting for event");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            consumer.unregister();
        });
    }
}

