/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.plugin;

import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.plugin.AbstractPlugin;
import com.gentics.mesh.plugin.PluginContext;
import com.gentics.mesh.plugin.PluginManifest;
import com.gentics.mesh.plugin.RestPlugin;
import com.gentics.mesh.plugin.env.PluginEnvironment;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import org.pf4j.PluginWrapper;

public class ClientPlugin
extends AbstractPlugin
implements RestPlugin {
    public ClientPlugin(PluginWrapper wrapper, PluginEnvironment env) {
        super(wrapper, env);
    }

    public PluginManifest getManifest() {
        PluginManifest manifest = new PluginManifest();
        manifest.setAuthor("Joe Doe");
        manifest.setId("client");
        manifest.setInception("2018");
        manifest.setVersion("1.0");
        manifest.setLicense("Apache License 2.0");
        manifest.setName("Client Test Plugin");
        manifest.setDescription("Plugin to test client interaction");
        return manifest;
    }

    public Router createGlobalRouter() {
        Router router = Router.router((Vertx)this.vertx());
        router.route("/me").handler(rc -> {
            PluginContext context = this.wrap((RoutingContext)rc);
            context.client().me(new ParameterProvider[0]).toSingle().subscribe(me -> rc.response().end(me.toJson()), arg_0 -> ((RoutingContext)rc).fail(arg_0));
        });
        router.route("/user").handler(rc -> rc.response().end(rc.user().principal().encodePrettily()));
        router.route("/admin").handler(rc -> this.adminClient().me(new ParameterProvider[0]).toSingle().subscribe(me -> rc.response().end(me.toJson()), arg_0 -> ((RoutingContext)rc).fail(arg_0)));
        return router;
    }

    public Router createProjectRouter() {
        Router router = Router.router((Vertx)this.vertx());
        router.route("/project").handler(rc -> {
            PluginContext context = this.wrap((RoutingContext)rc);
            context.client().findProjectByName(context.project().getString("name"), new ParameterProvider[0]).toSingle().subscribe(project -> rc.response().end(project.toJson()), arg_0 -> ((RoutingContext)rc).fail(arg_0));
        });
        return router;
    }

    public String restApiName() {
        return "client";
    }
}

