/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.plugin;

import com.gentics.mesh.etc.config.MeshOptions;
import com.gentics.mesh.plugin.DummyPlugin;
import com.gentics.mesh.plugin.DummyPluginConfig;
import com.gentics.mesh.plugin.PluginManifest;
import com.gentics.mesh.plugin.env.PluginEnvironment;
import com.gentics.mesh.plugin.impl.MeshPluginDescriptorImpl;
import com.gentics.mesh.test.MeshOptionsTypeUnawareContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pf4j.PluginWrapper;

public class PluginConfigTest
implements MeshOptionsTypeUnawareContext {
    public static String PLUGIN_DIR = "target/plugins" + System.currentTimeMillis();
    public static MeshOptions options;

    @Before
    public void cleanConfigFiles() {
        this.setupMeshOptions();
        DummyPlugin plugin = this.mockPlugin();
        plugin.getConfigFile().delete();
        plugin.getLocalConfigFile().delete();
    }

    @Test
    public void testMissingConfig() throws Exception {
        DummyPlugin plugin = this.mockPlugin();
        Assert.assertNull((Object)plugin.readConfig(DummyPluginConfig.class));
    }

    @Test
    public void testWriteConfig() throws Exception {
        DummyPlugin plugin = this.mockPlugin();
        DummyPluginConfig config = new DummyPluginConfig();
        config.setName("test");
        plugin.writeConfig(config);
        Assert.assertTrue((boolean)plugin.getConfigFile().exists());
        Assert.assertEquals((Object)"test", (Object)((DummyPluginConfig)plugin.readConfig(DummyPluginConfig.class)).getName());
        Assert.assertEquals((Object)(PLUGIN_DIR + "/dummy/config.yml"), (Object)plugin.getConfigFile().getPath());
        Assert.assertEquals((Object)(PLUGIN_DIR + "/dummy/storage"), (Object)plugin.getStorageDir().getPath());
    }

    @Test(expected=Exception.class)
    public void testReadInvalidYamlFile() throws Exception {
        DummyPlugin plugin = this.mockPlugin();
        File file = plugin.getConfigFile();
        FileUtils.writeStringToFile((File)file, (String)"foo bar", (Charset)StandardCharsets.UTF_8);
        plugin.readConfig(DummyPluginConfig.class);
    }

    @Test
    public void testReadConfigOverride() throws FileNotFoundException, IOException {
        DummyPlugin plugin = this.mockPlugin();
        DummyPluginConfig config = new DummyPluginConfig();
        config.setName("local");
        plugin.writeConfig(config);
        Assert.assertTrue((boolean)plugin.getConfigFile().exists());
        FileUtils.copyFile((File)plugin.getConfigFile(), (File)plugin.getLocalConfigFile());
        Assert.assertTrue((boolean)plugin.getLocalConfigFile().exists());
        config.setName("original");
        plugin.writeConfig(config);
        Assert.assertTrue((boolean)plugin.getConfigFile().exists());
        config = (DummyPluginConfig)plugin.readConfig(DummyPluginConfig.class);
        Assert.assertEquals((Object)"local", (Object)config.getName());
    }

    private void setupMeshOptions() {
        options = this.getOptions();
        options.setNodeName("ABC");
        options.getAuthenticationOptions().setKeystorePassword("ABC");
        options.setPluginDirectory(PLUGIN_DIR);
    }

    private DummyPlugin mockPlugin() {
        PluginWrapper wrapper = (PluginWrapper)Mockito.mock(PluginWrapper.class);
        Mockito.when((Object)wrapper.getPluginId()).thenReturn((Object)"dummy");
        MeshPluginDescriptorImpl descriptor = (MeshPluginDescriptorImpl)Mockito.mock(MeshPluginDescriptorImpl.class);
        Mockito.when((Object)descriptor.getName()).thenReturn((Object)"dummy");
        PluginManifest manifest = new PluginManifest();
        manifest.setName("dummy");
        Mockito.when((Object)descriptor.toPluginManifest()).thenReturn((Object)manifest);
        Mockito.when((Object)wrapper.getDescriptor()).thenReturn((Object)descriptor);
        PluginEnvironment env = (PluginEnvironment)Mockito.mock(PluginEnvironment.class);
        Mockito.when((Object)env.options()).thenReturn((Object)options);
        DummyPlugin plugin = new DummyPlugin(wrapper, env);
        return plugin;
    }
}

