/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.plugin;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.RestModel;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.plugin.PluginStatus;
import com.gentics.mesh.core.rest.project.ProjectCreateRequest;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.plugin.AbstractPluginTest;
import com.gentics.mesh.plugin.ClientPlugin;
import com.gentics.mesh.plugin.ClonePlugin;
import com.gentics.mesh.plugin.DummyPlugin;
import com.gentics.mesh.plugin.FailingInitializePlugin;
import com.gentics.mesh.plugin.FailingShutdownPlugin;
import com.gentics.mesh.plugin.InitializeTimeoutPlugin;
import com.gentics.mesh.plugin.PluginManifest;
import com.gentics.mesh.plugin.RestPlugin;
import com.gentics.mesh.plugin.SucceedingPlugin;
import com.gentics.mesh.plugin.manager.MeshPluginManager;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.PluginTests;
import com.gentics.mesh.test.helper.ExpectedEvent;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={PluginTests.class})
@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true, inMemoryDB=true)
public class PluginManagerTest
extends AbstractPluginTest {
    private static final String NAME = "basic";

    @Test
    public void testStop() {
        MeshPluginManager manager = this.pluginManager();
        int before = manager.getPluginIds().size();
        for (int i = 0; i < 100; ++i) {
            manager.deploy(ClonePlugin.class, "clone" + i).blockingAwait();
        }
        Assert.assertEquals((long)(before + 100), (long)manager.getPluginIds().size());
        Assert.assertEquals((long)100L, (long)manager.getPluginIds().size());
        manager.stop().blockingAwait();
        manager.unloadPlugins();
        Assert.assertEquals((long)0L, (long)manager.getPluginIds().size());
        Assert.assertEquals((String)"Not all deployed verticles have been undeployed.", (long)before, (long)manager.getPluginIds().size());
    }

    @Test
    public void testFilesystemDeployment() throws Exception {
        String name = "basic.jar";
        this.setPluginBaseDir("abc");
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            this.copy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", name);
            String id = (String)this.pluginManager().deploy(new File(this.pluginDir(), name).toPath()).blockingGet();
            Assert.assertEquals((Object)NAME, (Object)id);
        }
        for (int i = 0; i < 2; ++i) {
            ProjectCreateRequest request = new ProjectCreateRequest();
            request.setName("test" + i);
            request.setSchemaRef("folder");
            ClientHelper.call(() -> this.client().createProject(request));
        }
        Assert.assertEquals((Object)"world", (Object)this.httpGetNow("/api/v2/plugins/basic/hello", new ParameterProvider[0]));
        Assert.assertEquals((Object)"world-project", (Object)this.httpGetNow("/api/v2/test0/plugins/basic/hello", new ParameterProvider[0]));
        Assert.assertEquals((Object)"world-project", (Object)this.httpGetNow("/api/v2/test1/plugins/basic/hello", new ParameterProvider[0]));
    }

    @Test
    public void testStartupDeployment() throws IOException, TimeoutException {
        MeshPluginManager manager = this.pluginManager();
        this.copy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.jar");
        this.copy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "duplicate-plugin.jar");
        this.copy("/test-plugins/basic/target/basic-plugin-0.0.1-SNAPSHOT.jar", "plugin.blub");
        this.copy("/test-plugins/graphql/target/graphql-plugin-0.0.1-SNAPSHOT.jar", "gql-plugin.jar");
        this.copy("/test-plugins/graphql/target/graphql-plugin-0.0.1-SNAPSHOT.jar", "gql-plugin2.jar");
        Assert.assertEquals((long)0L, (long)manager.getPluginIds().size());
        manager.deployExistingPluginFiles().blockingAwait();
        Assert.assertEquals((long)2L, (long)manager.getPluginIds().size());
        manager.deployExistingPluginFiles().blockingAwait();
        manager.deployExistingPluginFiles().blockingAwait();
        manager.deployExistingPluginFiles().blockingAwait();
        Assert.assertEquals((String)"Only two plugins should have been deployed because all others are copies.", (long)2L, (long)manager.getPluginIds().size());
        manager.stop().blockingAwait();
        Assert.assertEquals((long)0L, (long)manager.getPluginIds().size());
        manager.start();
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            manager.deployExistingPluginFiles().blockingAwait();
            Assert.assertEquals((long)2L, (long)manager.getPluginIds().size());
        }
        String queryName = "plugin/graphql-plugin-query";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        System.out.println(response.toJson());
        MeshAssertions.assertThat((JsonObject)new JsonObject(response.toJson())).compliesToAssertions(queryName);
    }

    @Test
    public void testPluginAuth() throws IOException, TimeoutException {
        MeshPluginManager manager = this.pluginManager();
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            manager.deploy(ClientPlugin.class, "client").blockingAwait();
        }
        JsonObject json = new JsonObject(this.getJSONViaClient("/api/v2/plugins/client/user"));
        Assert.assertNotNull((Object)json.getString("uuid"));
    }

    @Test
    public void testClientFlooding() throws GenericRestException, IOException, TimeoutException {
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            this.pluginManager().deploy(ClientPlugin.class, "client").blockingAwait();
        }
        int before = this.threadCount();
        for (int i = 0; i < 200; ++i) {
            UserResponse anonymous = (UserResponse)JsonUtil.readValue((String)this.httpGetNow("/api/v2/plugins/client/me", new ParameterProvider[0]), UserResponse.class);
            Assert.assertEquals((String)"The plugin should return the anonymous user since no api key was passed along", (Object)"anonymous", (Object)anonymous.getUsername());
        }
        int after = this.threadCount();
        int diff = after - before;
        MeshAssertions.assertThat((int)diff).isLessThan(100);
    }

    @Test
    public void testClientAPI() throws IOException, TimeoutException {
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            this.pluginManager().deploy(ClientPlugin.class, "client").blockingAwait();
        }
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("testabc");
        request.setSchemaRef("folder");
        ClientHelper.call(() -> this.client().createProject(request));
        UserResponse anonymous = (UserResponse)JsonUtil.readValue((String)this.httpGetNow("/api/v2/plugins/client/me", new ParameterProvider[0]), UserResponse.class);
        Assert.assertEquals((String)"The plugin should return the anonymous user since no api key was passed along", (Object)"anonymous", (Object)anonymous.getUsername());
        UserResponse user = this.getViaClient(UserResponse.class, "/api/v2/plugins/client/me");
        Assert.assertEquals((String)"The plugin should return the authenticated response", (Object)"joe1", (Object)user.getUsername());
        UserResponse admin = this.getViaClient(UserResponse.class, "/api/v2/plugins/client/admin");
        Assert.assertEquals((String)"The admin endpoint should return the response which was authenticated using the admin user", (Object)"admin", (Object)admin.getUsername());
        ProjectResponse project = this.getViaClient(ProjectResponse.class, "/api/v2/testabc/plugins/client/project");
        Assert.assertEquals((Object)"testabc", (Object)project.getName());
    }

    private String getJSONViaClient(String path) throws IOException {
        HttpUrl url = this.prepareUrl(path, new ParameterProvider[0]);
        Request.Builder b = new Request.Builder();
        b.url(url);
        b.method("GET", null);
        b.addHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + this.client().getAuthentication().getToken());
        String json = this.httpClient().newCall(b.build()).execute().body().string();
        return json;
    }

    private <T extends RestModel> T getViaClient(Class<T> clazz, String path) throws IOException {
        String json = this.getJSONViaClient(path);
        return (T)((RestModel)JsonUtil.readValue((String)json, clazz));
    }

    @Test
    public void testJavaDeployment() throws IOException, TimeoutException {
        MeshPluginManager manager = this.pluginManager();
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            manager.deploy(DummyPlugin.class, "dummy").blockingAwait();
            Assert.assertEquals((long)1L, (long)manager.getPluginIds().size());
        }
        ProjectCreateRequest request = new ProjectCreateRequest();
        request.setName("test");
        request.setSchemaRef("folder");
        ClientHelper.call(() -> this.client().createProject(request));
        String apiName = "dummy";
        PluginManifest manifest = (PluginManifest)JsonUtil.readValue((String)this.httpGetNow("/api/v2/plugins/" + apiName + "/manifest", new ParameterProvider[0]), PluginManifest.class);
        Assert.assertEquals((Object)"Unknown Author", (Object)manifest.getAuthor());
        String pluginApiName = ((RestPlugin)manager.getPlugin("dummy").getPlugin()).restApiName();
        Assert.assertEquals((Object)apiName, (Object)pluginApiName);
        JsonObject idInfo = new JsonObject(this.httpGetNow("/api/v2/plugins/" + apiName + "/id", new ParameterProvider[0]));
        String id = idInfo.getString("id");
        Assert.assertEquals((String)"Invalid id", (Object)"dummy", (Object)id);
        Assert.assertEquals((Object)"world", (Object)this.httpGetNow("/api/v2/plugins/" + apiName + "/hello", new ParameterProvider[0]));
        Assert.assertEquals((Object)"project", (Object)this.httpGetNow("/api/v2/test/plugins/" + apiName + "/hello", new ParameterProvider[0]));
    }

    @Test
    public void testDeployAfterShutdownFailure() {
        MeshPluginManager manager = this.pluginManager();
        manager.deploy(FailingShutdownPlugin.class, "failing").blockingAwait();
        manager.undeploy("failing").blockingAwait(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)manager.getPluginIds().size());
        manager.deploy(SucceedingPlugin.class, "succeeding").blockingAwait();
        Assert.assertEquals((long)1L, (long)manager.getPluginIds().size());
    }

    @Test
    public void testInitializeTimeoutPlugin() throws TimeoutException {
        this.options().setPluginTimeout(1);
        MeshPluginManager manager = this.pluginManager();
        try (ExpectedEvent failed = this.expectEvent(MeshEvent.PLUGIN_DEPLOY_FAILED, 10000);){
            manager.deploy(InitializeTimeoutPlugin.class, "timeout").blockingAwait();
        }
        Assert.assertEquals((long)1L, (long)manager.getPluginIds().size());
        PluginStatus status = manager.getStatus((String)manager.getPluginIds().iterator().next());
        Assert.assertEquals((Object)PluginStatus.FAILED, (Object)status);
    }

    @Test
    public void testRedeployAfterInitFailure() throws TimeoutException {
        MeshPluginManager manager = this.pluginManager();
        try (ExpectedEvent failed = this.expectEvent(MeshEvent.PLUGIN_DEPLOY_FAILED, 10000);){
            manager.deploy(FailingInitializePlugin.class, "failing").blockingAwait();
        }
        PluginStatus status = manager.getStatus((String)manager.getPluginIds().iterator().next());
        Assert.assertEquals((Object)PluginStatus.FAILED, (Object)status);
        Assert.assertEquals((long)1L, (long)manager.getPluginIds().size());
        Assert.assertEquals((long)1L, (long)manager.getPluginsMap().size());
        try (ExpectedEvent registration = this.expectEvent(MeshEvent.PLUGIN_REGISTERED, 20000);){
            manager.deploy(SucceedingPlugin.class, "succeeding").blockingAwait();
            Assert.assertEquals((long)2L, (long)manager.getPluginIds().size());
            Assert.assertEquals((long)2L, (long)manager.getPluginsMap().size());
        }
    }
}

