/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.rest;

import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshWebrootFieldResponse;
import com.gentics.mesh.rest.client.MeshWebrootResponse;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ConnectionVerifier;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.MeshTestContext;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class ConnectionLeakTest
extends AbstractMeshTest {
    public static final String BINARY_SCHEMA_NAME = "binary_schema";
    public static final String BINARY_FIELD_NAME = "binary";
    public static final String CONTENT_TYPE = "image/png";
    public static final String FILENAME = "somefile.png";
    public static final String WEBROOT_PATH = "/somefile.png";
    protected NodeResponse node;
    protected int uploadSize;
    @Rule
    public ConnectionVerifier connectionVerifier = new ConnectionVerifier(MeshTestContext.okHttp);

    @Before
    public void setup() throws IOException {
        this.setupBinarySchema();
        this.setupBinaryData();
    }

    public void setupBinarySchema() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName(BINARY_SCHEMA_NAME);
        request.setFields(Arrays.asList(new BinaryFieldSchemaImpl().setName(BINARY_FIELD_NAME)));
        request.setSegmentField(BINARY_FIELD_NAME);
        SchemaResponse schemaResponse = (SchemaResponse)this.client().createSchema(request, new ParameterProvider[0]).blockingGet();
        this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()).blockingAwait();
    }

    public void setupBinaryData() throws IOException {
        ProjectResponse project = (ProjectResponse)ClientHelper.call(() -> this.client().findProjectByName("dummy", new ParameterProvider[0]));
        this.node = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", new NodeCreateRequest().setLanguage("en").setParentNodeUuid(project.getRootNode().getUuid()).setSchemaName(BINARY_SCHEMA_NAME), new ParameterProvider[0]));
        InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        this.node = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", this.node.getUuid(), "en", "draft", BINARY_FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), FILENAME, CONTENT_TYPE, new ParameterProvider[0]));
        this.uploadSize = buffer.length();
    }

    @Test
    public void testNode() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().findNodeByUuid("dummy", this.node.getUuid(), new ParameterProvider[0]).toSingle().doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testNodeErrorWhileConsuming() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().findNodeByUuid("dummy", this.node.getUuid(), new ParameterProvider[0]).toSingle().doOnSuccess(response -> {
            throw new RuntimeException("Something bad happens here");
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testNodeBlocking() throws InterruptedException {
        this.client().findNodeByUuid("dummy", this.node.getUuid(), new ParameterProvider[0]).toSingle().blockingGet();
    }

    @Test
    public void testBinaryField() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger downloadSize = new AtomicInteger();
        this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().flatMapObservable(binResponse -> binResponse.getFlowable().toObservable().doOnComplete(() -> binResponse.close())).doOnNext(bytes -> downloadSize.addAndGet(((byte[])bytes).length)).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)downloadSize.get()).as("Downloaded bytes", new Object[0])).isEqualTo(this.uploadSize);
    }

    @Test
    public void testBinaryFieldNotConsumed() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().doAfterSuccess(response -> response.close()).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testBinaryFieldErrorWhileConsuming() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().doAfterSuccess(response -> response.close()).doOnSuccess(response -> {
            throw new RuntimeException("Something bad happens here");
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testBinaryFieldErrorWhileConsumingData() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().flatMapObservable(binResponse -> binResponse.getFlowable().toObservable()).doOnNext(bytes -> {
            throw new RuntimeException("Something bad happens here");
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testBinaryFieldBlocking() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger downloadSize = new AtomicInteger();
        MeshBinaryResponse response = (MeshBinaryResponse)this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().blockingGet();
        response.getFlowable().doOnNext(bytes -> downloadSize.addAndGet(((byte[])bytes).length)).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)downloadSize.get()).as("Downloaded bytes", new Object[0])).isEqualTo(this.uploadSize);
    }

    @Test
    public void testBinaryFieldBlockingNotConsumed() throws IOException, InterruptedException {
        MeshBinaryResponse response = (MeshBinaryResponse)this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().blockingGet();
        if (response != null) {
            response.close();
        }
    }

    @Test
    public void testBinaryFieldBlockingErrorWhileConsumingData() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        MeshBinaryResponse response = (MeshBinaryResponse)this.client().downloadBinaryField("dummy", this.node.getUuid(), "en", BINARY_FIELD_NAME, new ParameterProvider[0]).toSingle().blockingGet();
        response.getFlowable().doOnNext(bytes -> {
            throw new RuntimeException("Something bad happens here");
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebroot() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger downloadSize = new AtomicInteger();
        this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().doFinally(() -> latch.countDown()).subscribe(response -> {
            if (response.isBinary()) {
                response.getBinaryResponse().getFlowable().doOnNext(bytes -> downloadSize.addAndGet(((byte[])bytes).length)).subscribe();
            }
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)downloadSize.get()).as("Downloaded bytes", new Object[0])).isEqualTo(this.uploadSize);
    }

    @Test
    public void testWebrootNotConsumed() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().doAfterSuccess(response -> response.close()).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebrootErrorWhileConsuming() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().doAfterSuccess(response -> response.close()).doOnSuccess(response -> {
            throw new RuntimeException("Something bad happens here");
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebrootErrorWhileConsumingData() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().doOnSuccess(response -> {
            if (response.isBinary()) {
                response.getBinaryResponse().getFlowable().doOnNext(bytes -> {
                    throw new RuntimeException("Something bad happens here");
                }).subscribe();
            }
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebrootBlocking() throws IOException, InterruptedException {
        AtomicInteger downloadSize = new AtomicInteger();
        MeshWebrootResponse response = (MeshWebrootResponse)this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().blockingGet();
        if (response.isBinary()) {
            response.getBinaryResponse().getFlowable().doOnNext(bytes -> downloadSize.addAndGet(((byte[])bytes).length)).blockingSubscribe();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)downloadSize.get()).as("Downloaded bytes", new Object[0])).isEqualTo(this.uploadSize);
    }

    @Test
    public void testWebrootBlockingNotConsumed() throws IOException, InterruptedException {
        MeshWebrootResponse response = (MeshWebrootResponse)this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().blockingGet();
        if (response != null) {
            response.close();
        }
    }

    @Test
    public void testWebrootBlockingErrorWhileConsumingData() throws IOException, InterruptedException {
        MeshWebrootResponse response = (MeshWebrootResponse)this.client().webroot("dummy", WEBROOT_PATH, new ParameterProvider[0]).toSingle().blockingGet();
        if (response.isBinary()) {
            try {
                response.getBinaryResponse().getFlowable().doOnNext(bytes -> {
                    throw new RuntimeException("Something bad happens here");
                }).blockingSubscribe();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testWebrootField() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger downloadSize = new AtomicInteger();
        this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().doFinally(() -> latch.countDown()).subscribe(response -> {
            if (response.isBinary()) {
                response.getBinaryResponse().getFlowable().doOnNext(bytes -> downloadSize.addAndGet(((byte[])bytes).length)).subscribe();
            }
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)downloadSize.get()).as("Downloaded bytes", new Object[0])).isEqualTo(this.uploadSize);
    }

    @Test
    public void testWebrootFieldNotConsumed() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().doAfterSuccess(response -> response.close()).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebrootFieldErrorWhileConsuming() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().doAfterSuccess(response -> response.close()).doOnSuccess(response -> {
            throw new RuntimeException("Something bad happens here");
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebrootFieldErrorWhileConsumingData() throws IOException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().doOnSuccess(response -> {
            if (response.isBinary()) {
                response.getBinaryResponse().getFlowable().doOnNext(bytes -> {
                    throw new RuntimeException("Something bad happens here");
                }).subscribe();
            }
        }).doFinally(() -> latch.countDown()).subscribe();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(1L, TimeUnit.MINUTES)).as("Call ended in time", new Object[0])).isTrue();
    }

    @Test
    public void testWebrootFieldBlocking() throws IOException, InterruptedException {
        AtomicInteger downloadSize = new AtomicInteger();
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().blockingGet();
        if (response.isBinary()) {
            response.getBinaryResponse().getFlowable().doOnNext(bytes -> downloadSize.addAndGet(((byte[])bytes).length)).blockingSubscribe();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)downloadSize.get()).as("Downloaded bytes", new Object[0])).isEqualTo(this.uploadSize);
    }

    @Test
    public void testWebrootFieldBlockingNotConsumed() throws IOException, InterruptedException {
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().blockingGet();
        if (response != null) {
            response.close();
        }
    }

    @Test
    public void testWebrootFieldBlockingErrorWhileConsumingData() throws IOException, InterruptedException {
        MeshWebrootFieldResponse response = (MeshWebrootFieldResponse)this.client().webrootField("dummy", BINARY_FIELD_NAME, WEBROOT_PATH, new ParameterProvider[0]).toSingle().blockingGet();
        if (response.isBinary()) {
            try {
                response.getBinaryResponse().getFlowable().doOnNext(bytes -> {
                    throw new RuntimeException("Something bad happens here");
                }).blockingSubscribe();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

