/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaReferenceInfo;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.tag.TagResponse;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.rest.ClientSchemaStorage;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import com.google.common.base.Objects;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class RestModelTest
extends AbstractMeshTest {
    @Test
    public void testNodeResponse() throws JsonParseException, JsonMappingException, IOException {
        this.meshDagger().serverSchemaStorage().addSchema((SchemaVersionModel)this.getDummySchema());
        NodeResponse response = new NodeResponse();
        StringFieldImpl stringField = new StringFieldImpl();
        stringField.setString("some text");
        FieldMapImpl fields = new FieldMapImpl();
        fields.put("name", (Field)stringField);
        response.setFields((FieldMap)fields);
        response.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(UUIDUtil.randomUUID()));
        String json = response.toJson();
        Assert.assertNotNull((Object)json);
        NodeResponse deserializedResponse = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
        Assert.assertNotNull((Object)deserializedResponse);
    }

    private SchemaModelImpl getDummySchema() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("content");
        schema.setDisplayField("title");
        StringFieldSchemaImpl titleFieldSchema = new StringFieldSchemaImpl();
        titleFieldSchema.setName("title");
        titleFieldSchema.setLabel("Title");
        schema.addField((FieldSchema)titleFieldSchema);
        StringFieldSchemaImpl nameFieldSchema = new StringFieldSchemaImpl();
        nameFieldSchema.setName("name");
        nameFieldSchema.setLabel("Name");
        schema.addField((FieldSchema)nameFieldSchema);
        schema.setContainer(Boolean.valueOf(false));
        return schema;
    }

    @Test
    public void testNodeCreateRequest() throws JsonParseException, JsonMappingException, IOException {
        ClientSchemaStorage schemaStorage = new ClientSchemaStorage();
        schemaStorage.addSchema((SchemaVersionModel)this.getDummySchema());
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchema((SchemaReference)((SchemaReference)new SchemaReferenceImpl().setName("content")).setUuid(UUIDUtil.randomUUID()));
        request.setLanguage("en");
        request.setParentNodeUuid(UUIDUtil.randomUUID());
        StringFieldImpl stringField = new StringFieldImpl();
        stringField.setString("some text");
        request.getFields().put("name", (Field)stringField);
        StringFieldImpl titleField = new StringFieldImpl();
        titleField.setString("The awesome title");
        request.getFields().put("title", (Field)titleField);
        String json = request.toJson();
        System.out.println(json);
        SchemaReferenceInfo info = (SchemaReferenceInfo)JsonUtil.readValue((String)json, SchemaReferenceInfo.class);
        Assert.assertNotNull((Object)info.getSchema());
        Assert.assertNotNull((Object)info.getSchema().getName());
        Assert.assertNotNull((Object)info.getSchema().getUuid());
        Assert.assertEquals((Object)"content", (Object)info.getSchema().getName());
        NodeCreateRequest loadedRequest = (NodeCreateRequest)JsonUtil.readValue((String)json, NodeCreateRequest.class);
        FieldMap fields = loadedRequest.getFields();
        Assert.assertNotNull((Object)fields);
        Assert.assertNotNull((Object)fields.hasField("name"));
        Assert.assertNotNull((Object)fields.getStringField("name").getString());
        Assert.assertEquals((Object)StringFieldImpl.class.getName(), (Object)fields.getStringField("name").getClass().getName());
    }

    @Test
    public void testNodeList() throws Exception {
        try (Tx tx = this.tx();){
            SchemaVersionModel folderSchema = ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getSchema();
            SchemaVersionModel contentSchema = ((HibSchemaVersion)this.schemaContainer("content").getLatestVersion()).getSchema();
            NodeResponse folder = new NodeResponse();
            FieldMapImpl folderFields = new FieldMapImpl();
            folder.setSchema((SchemaReference)new SchemaReferenceImpl().setName(folderSchema.getName()));
            folderFields.put("name", (Field)FieldUtil.createStringField((String)"folder name"));
            folder.setFields((FieldMap)folderFields);
            NodeResponse content = new NodeResponse();
            content.setSchema((SchemaReference)new SchemaReferenceImpl().setName(contentSchema.getName()));
            FieldMapImpl contentFields = new FieldMapImpl();
            contentFields.put("name", (Field)FieldUtil.createStringField((String)"content name"));
            contentFields.put("content", (Field)FieldUtil.createStringField((String)"some content"));
            content.setFields((FieldMap)contentFields);
            ClientSchemaStorage storage = new ClientSchemaStorage();
            storage.addSchema(folderSchema);
            storage.addSchema(contentSchema);
            NodeListResponse list = new NodeListResponse();
            list.getData().add(folder);
            list.getData().add(content);
            String json = list.toJson();
            NodeListResponse deserializedList = (NodeListResponse)JsonUtil.readValue((String)json, NodeListResponse.class);
            Assert.assertNotNull((Object)deserializedList);
        }
    }

    @Test
    public void testSchema() throws JsonParseException, JsonMappingException, IOException {
        SchemaModelImpl schemaCreateRequest = new SchemaModelImpl();
        schemaCreateRequest.setName("blogpost");
        schemaCreateRequest.setDisplayField("name");
        Assert.assertEquals((Object)"name", (Object)schemaCreateRequest.getDisplayField());
        Assert.assertEquals((Object)"blogpost", (Object)schemaCreateRequest.getName());
        StringFieldSchemaImpl stringSchema = new StringFieldSchemaImpl();
        stringSchema.setLabel("string field label");
        stringSchema.setName("name");
        schemaCreateRequest.addField((FieldSchema)stringSchema);
        BooleanFieldSchemaImpl booleanSchema = new BooleanFieldSchemaImpl();
        booleanSchema.setLabel("boolean field label");
        booleanSchema.setName("boolean");
        schemaCreateRequest.addField((FieldSchema)booleanSchema);
        ListFieldSchemaImpl listFieldSchema = new ListFieldSchemaImpl();
        listFieldSchema.setName("list");
        listFieldSchema.setLabel("list field label");
        listFieldSchema.setListType("node");
        listFieldSchema.setAllowedSchemas(new String[]{"image", "gallery"});
        schemaCreateRequest.addField((FieldSchema)listFieldSchema);
        String json = schemaCreateRequest.toJson();
        Assert.assertNotNull((Object)json);
        SchemaModel loadedRequest = (SchemaModel)JsonUtil.readValue((String)json, SchemaModelImpl.class);
        Assert.assertNotNull((Object)loadedRequest);
        String json2 = loadedRequest.toJson();
        Assert.assertEquals((Object)json, (Object)json2);
    }

    @Test
    public void testNodeSchema2() {
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("blogpost");
        schema.setDisplayField("name");
        StringFieldSchemaImpl stringSchema = new StringFieldSchemaImpl();
        stringSchema.setLabel("string field label");
        stringSchema.setName("string");
        schema.addField((FieldSchema)stringSchema);
        BooleanFieldSchemaImpl booleanSchema = new BooleanFieldSchemaImpl();
        booleanSchema.setLabel("boolean field label");
        booleanSchema.setName("boolean");
        schema.addField((FieldSchema)booleanSchema);
        ListFieldSchemaImpl listFieldSchema = new ListFieldSchemaImpl();
        listFieldSchema.setName("list field name");
        listFieldSchema.setLabel("list field label");
        listFieldSchema.setListType("node");
        listFieldSchema.setAllowedSchemas(new String[]{"image", "gallery"});
        for (FieldSchema fieldEntry : schema.getFields()) {
            System.out.println("Schema Field: " + fieldEntry.getName() + " has " + fieldEntry.getType());
            System.out.println();
        }
    }

    @Test
    public void testEquals() {
        String uuid = UUIDUtil.randomUUID();
        NodeResponse r1 = new NodeResponse();
        NodeResponse r2 = new NodeResponse();
        Assert.assertTrue((boolean)r1.equals((Object)r2));
        r1.setUuid(uuid);
        r2.setUuid(uuid);
        Assert.assertTrue((boolean)r1.equals((Object)r2));
        r2.setUuid(UUIDUtil.randomUUID());
        Assert.assertFalse((boolean)r1.equals((Object)r2));
        UserResponse r3 = new UserResponse();
        Assert.assertFalse((boolean)r3.equals((Object)r1));
        r3.setUuid(uuid);
        Assert.assertTrue((boolean)r3.equals((Object)r1));
        TagResponse t1 = new TagResponse();
        TagResponse t2 = new TagResponse();
        Assert.assertTrue((boolean)t1.equals((Object)t2));
        t1.setUuid(uuid);
        t2.setUuid(uuid);
        Assert.assertTrue((boolean)t1.equals((Object)t2));
        t2.setUuid(UUIDUtil.randomUUID());
        Assert.assertFalse((boolean)t1.equals((Object)t2));
        r3.setUuid(UUIDUtil.randomUUID());
        Assert.assertFalse((boolean)r3.equals((Object)t1));
        r3.setUuid(uuid);
        Assert.assertTrue((boolean)r3.equals((Object)t1));
    }

    @Test
    public void testNodeResponseEquals() {
        String uuid = UUIDUtil.randomUUID();
        String version = "1.0";
        String lang = "de";
        NodeResponse r1 = new NodeResponse();
        r1.setUuid(uuid);
        r1.setLanguage(lang);
        r1.setVersion(version);
        NodeResponse r2 = new NodeResponse();
        r2.setUuid(uuid);
        r2.setLanguage(lang);
        r2.setVersion(version);
        Assert.assertTrue((String)"Should be equal since all fields are the same", (boolean)r1.equals((Object)r2));
        r1.setUuid(UUIDUtil.randomUUID());
        Assert.assertFalse((String)"Should be not equal since uuid is different", (boolean)r1.equals((Object)r2));
        r1.setUuid(uuid);
        r1.setVersion("2.0");
        Assert.assertFalse((String)"Should be not equal since version is different", (boolean)r1.equals((Object)r2));
        r1.setVersion(version);
        r1.setLanguage("ru");
        Assert.assertFalse((String)"Should be not equal since lang is different", (boolean)r1.equals((Object)r2));
        r1.setLanguage(lang);
        Assert.assertTrue((String)"Should be equal since all fields are the same", (boolean)r1.equals((Object)r2));
    }

    @Test
    public void testHashCode() {
        String uuid = UUIDUtil.randomUUID();
        NodeResponse response = new NodeResponse();
        response.setUuid(uuid);
        Assert.assertEquals((long)Objects.hashCode((Object[])new Object[]{uuid}), (long)response.hashCode());
    }
}

