/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.rest.node;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.common.FieldTypes;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.BooleanField;
import com.gentics.mesh.core.rest.node.field.DateField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.HtmlField;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.node.field.NodeField;
import com.gentics.mesh.core.rest.node.field.NumberField;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.impl.BinaryFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.BooleanFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.DateFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.MicronodeFieldList;
import com.gentics.mesh.core.rest.node.field.list.NodeFieldList;
import com.gentics.mesh.core.rest.node.field.list.impl.BooleanFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.DateFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NumberFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.util.DateUtils;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class FieldMapTest {
    @Test
    public void testJsonMapNullHandling() throws JsonParseException, JsonMappingException, IOException {
        FieldMapImpl fieldMap = new FieldMapImpl();
        fieldMap.put("stringField", (Field)new StringFieldImpl().setString("text"));
        fieldMap.put("stringFieldNull", null);
        fieldMap.put("stringFieldNullValue", (Field)new StringFieldImpl().setString(null));
        fieldMap.put("dateField", (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)100L)));
        fieldMap.put("dateFieldNull", null);
        fieldMap.put("dateFieldNullValue", (Field)new DateFieldImpl().setDate(null));
        fieldMap.put("htmlField", (Field)new HtmlFieldImpl().setHTML("someHtml"));
        fieldMap.put("htmlFieldNull", null);
        fieldMap.put("htmlFieldNullValue", (Field)new HtmlFieldImpl().setHTML(null));
        fieldMap.put("numberField", (Field)new NumberFieldImpl().setNumber((Number)42));
        fieldMap.put("numberFieldNull", null);
        fieldMap.put("numberFieldNullValue", (Field)new NumberFieldImpl().setNumber(null));
        BinaryFieldImpl field = new BinaryFieldImpl();
        field.setFileName("name");
        field.setDominantColor("#22A7F0");
        fieldMap.put("binaryField", (Field)field);
        fieldMap.put("binaryFieldNull", null);
        fieldMap.put("booleanField", (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(true)));
        fieldMap.put("booleanFieldNull", null);
        fieldMap.put("booleanFieldNullValue", (Field)new BooleanFieldImpl().setValue(null));
        fieldMap.put("micronodeField", (Field)new MicronodeResponse());
        fieldMap.put("micronodeFieldNull", null);
        fieldMap.put("nodeField", (Field)new NodeResponse());
        fieldMap.put("nodeFieldNull", null);
        NodeFieldListImpl nodeList = new NodeFieldListImpl();
        nodeList.add((Object)new NodeFieldListItemImpl().setUuid("blub"));
        nodeList.add((Object)new NodeFieldListItemImpl().setUuid("blub2"));
        NodeResponse nodeResponse = new NodeResponse();
        nodeResponse.setUuid("blub3");
        nodeList.add((Object)nodeResponse);
        fieldMap.put("nodeListField", (Field)nodeList);
        MicronodeFieldListImpl micronodeList = new MicronodeFieldListImpl();
        MicronodeResponse modelA = new MicronodeResponse();
        modelA.setUuid("blub");
        MicronodeResponse modelB = new MicronodeResponse();
        modelB.setUuid("blab");
        MicronodeResponse modelC = new MicronodeResponse();
        modelC.setUuid("blar");
        micronodeList.add((Object)modelA);
        micronodeList.add((Object)modelB);
        micronodeList.add((Object)modelC);
        fieldMap.put("micronodeListField", (Field)micronodeList);
        StringFieldListImpl stringList = new StringFieldListImpl();
        stringList.add((Object)"first");
        stringList.add((Object)"second");
        stringList.add((Object)"third");
        fieldMap.put("stringListField", (Field)stringList);
        DateFieldListImpl dateList = new DateFieldListImpl();
        dateList.add((Object)DateUtils.toISO8601((long)1000L));
        dateList.add((Object)DateUtils.toISO8601((long)4200L));
        dateList.add((Object)DateUtils.toISO8601((long)System.currentTimeMillis()));
        fieldMap.put("dateListField", (Field)dateList);
        BooleanFieldListImpl booleanList = new BooleanFieldListImpl();
        booleanList.add((Object)true);
        booleanList.add((Object)true);
        booleanList.add((Object)false);
        fieldMap.put("booleanListField", (Field)booleanList);
        HtmlFieldListImpl htmlList = new HtmlFieldListImpl();
        htmlList.add((Object)"htmlA");
        htmlList.add((Object)"htmlB");
        htmlList.add((Object)"htmlC");
        fieldMap.put("htmlListField", (Field)htmlList);
        NumberFieldListImpl numberList = new NumberFieldListImpl();
        numberList.add((Object)10);
        numberList.add((Object)42);
        numberList.add((Object)12);
        fieldMap.put("numberListField", (Field)numberList);
        fieldMap.put("nulled", null);
        this.assertMap((FieldMap)fieldMap);
        Assert.assertNull((String)"The nulled Value should be returned with null value", (Object)fieldMap.getField("nulled", FieldTypes.STRING, null, false));
        String json = fieldMap.toJson();
        JsonObject jsonObject = new JsonObject(json);
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("nulled");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("nodeFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("binaryFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("micronodeFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("booleanFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("binaryFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("numberFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("htmlFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("dateFieldNull");
        MeshAssertions.assertThat((JsonObject)jsonObject).hasNullValue("stringFieldNull");
        Assert.assertNotNull((Object)json);
        FieldMap fieldMapDeserialized = (FieldMap)JsonUtil.readValue((String)json, FieldMap.class);
        this.assertMap(fieldMapDeserialized);
    }

    @Test
    public void testEmptyMap() {
        FieldMapImpl map = new FieldMapImpl();
        Assert.assertTrue((String)"The map should be empty.", (boolean)map.isEmpty());
        Assert.assertEquals((String)"No field should be stored in the map.", (long)0L, (long)map.size());
    }

    private void assertMap(FieldMap fieldMap) {
        StringField stringField = (StringField)fieldMap.getField("stringField", FieldTypes.STRING, null, false);
        Assert.assertNotNull((Object)stringField);
        Assert.assertNotNull((Object)fieldMap.getStringField("stringField"));
        Assert.assertNull((String)"The field value was set to null and thus the field should be null.", (Object)fieldMap.getField("stringFieldNullValue", FieldTypes.STRING, null, false));
        Assert.assertNull((String)"The field was explicitly set to null and should be null but it was not.", (Object)fieldMap.getStringField("stringFieldNull"));
        HtmlField htmlField = (HtmlField)fieldMap.getField("htmlField", FieldTypes.HTML, null, false);
        Assert.assertNotNull((Object)htmlField);
        Assert.assertNotNull((Object)fieldMap.getHtmlField("htmlField"));
        Assert.assertNull((Object)fieldMap.getField("htmlFieldNullValue", FieldTypes.HTML, null, false));
        Assert.assertNull((String)"The field was explicitly set to null and should be null but it was not.", (Object)fieldMap.getHtmlField("htmlFieldNull"));
        BooleanField booleanField = (BooleanField)fieldMap.getField("booleanField", FieldTypes.BOOLEAN, null, false);
        Assert.assertNotNull((Object)booleanField);
        Assert.assertNotNull((Object)fieldMap.getBooleanField("booleanField"));
        Assert.assertNull((Object)fieldMap.getField("booleanFieldNullValue", FieldTypes.BOOLEAN, null, false));
        Assert.assertNull((String)"The field was explicitly set to null and should be null but it was not.", (Object)fieldMap.getBooleanField("booleanFieldNull"));
        DateField dateField = (DateField)fieldMap.getField("dateField", FieldTypes.DATE, null, false);
        Assert.assertNotNull((Object)dateField);
        Assert.assertNotNull((Object)fieldMap.getDateField("dateField"));
        Assert.assertNull((Object)fieldMap.getField("numberFieldNullValue", FieldTypes.NUMBER, null, false));
        Assert.assertNull((String)"The field was explicitly set to null and should be null but it was not.", (Object)fieldMap.getNumberField("numberFieldNull"));
        NodeField nodeField = (NodeField)fieldMap.getField("nodeField", FieldTypes.NODE, null, false);
        Assert.assertNotNull((Object)nodeField);
        Assert.assertNotNull((Object)fieldMap.getNodeField("nodeField"));
        Assert.assertNull((String)"The field was explicitly set to null and should be null but it was not.", (Object)fieldMap.getField("nodeFieldNullValue", FieldTypes.NODE, null, false));
        MicronodeField micronodeField = (MicronodeField)fieldMap.getField("micronodeField", FieldTypes.MICRONODE, null, false);
        Assert.assertNotNull((Object)micronodeField);
        Assert.assertNotNull((Object)fieldMap.getMicronodeField("micronodeField"));
        MicronodeField micronodeFieldNull = (MicronodeField)fieldMap.getField("micronodeFieldNull", FieldTypes.MICRONODE, null, false);
        Assert.assertNull((Object)micronodeFieldNull);
        NumberField numberField = (NumberField)fieldMap.getField("numberField", FieldTypes.NUMBER, null, false);
        Assert.assertNotNull((Object)numberField);
        Assert.assertNotNull((Object)fieldMap.getNumberField("numberField"));
        Assert.assertNull((Object)fieldMap.getField("numberFieldNull", FieldTypes.NUMBER, null, false));
        Assert.assertNull((Object)fieldMap.getField("numberFieldNullValue", FieldTypes.NUMBER, null, false));
        BinaryField binaryField = (BinaryField)fieldMap.getField("binaryField", FieldTypes.BINARY, null, false);
        Assert.assertNotNull((Object)fieldMap.getBinaryField("binaryField"));
        Assert.assertNotNull((Object)binaryField);
        NumberFieldListImpl numberList = fieldMap.getNumberFieldList("numberListField");
        Assert.assertNotNull((Object)numberList);
        Assert.assertEquals((long)3L, (long)numberList.getItems().size());
        HtmlFieldListImpl htmlList = fieldMap.getHtmlFieldList("htmlListField");
        Assert.assertNotNull((Object)htmlList);
        Assert.assertEquals((long)3L, (long)htmlList.getItems().size());
        DateFieldListImpl dateList = fieldMap.getDateFieldList("dateListField");
        Assert.assertNotNull((Object)dateList);
        Assert.assertEquals((long)3L, (long)dateList.getItems().size());
        BooleanFieldListImpl booleanList = fieldMap.getBooleanFieldList("booleanListField");
        Assert.assertNotNull((Object)booleanList);
        Assert.assertEquals((long)3L, (long)booleanList.getItems().size());
        StringFieldListImpl stringList = fieldMap.getStringFieldList("stringListField");
        Assert.assertNotNull((Object)stringList);
        Assert.assertEquals((long)3L, (long)stringList.getItems().size());
        NodeFieldList nodeList = fieldMap.getNodeFieldList("nodeListField");
        Assert.assertNotNull((Object)nodeList);
        Assert.assertEquals((long)3L, (long)nodeList.getItems().size());
        MicronodeFieldList micronodeList = fieldMap.getMicronodeFieldList("micronodeListField");
        Assert.assertNotNull((Object)micronodeList);
        Assert.assertEquals((long)3L, (long)micronodeList.getItems().size());
        Assert.assertEquals((String)"The map did not contain the expected amount of fields.", (long)29L, (long)fieldMap.size());
        Assert.assertFalse((String)"The map should not be empty.", (boolean)fieldMap.isEmpty());
        Assert.assertTrue((String)"The string field should be within the map.", (boolean)fieldMap.hasField("stringField"));
        Assert.assertNotNull((Object)fieldMap.getField("stringField", (FieldSchema)new StringFieldSchemaImpl().setName("stringField")));
        Assert.assertNull((String)"Null should be returned for a key that was not added to the map.", (Object)fieldMap.getField("bogus", FieldTypes.STRING, null, false));
        Assert.assertFalse((String)"No field with key bogus should be contained within the map.", (boolean)fieldMap.hasField("bogus"));
        Assert.assertTrue((String)"The key should be stored in the map.", (boolean)fieldMap.hasField("stringField"));
    }
}

