/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.SSLTestMode;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.MeshTestContext;
import com.gentics.mesh.test.context.PluginHelper;
import com.gentics.mesh.test.context.TestGraphHelper;
import com.gentics.mesh.test.context.TestHttpMethods;
import com.gentics.mesh.test.context.event.EventAsserter;
import com.gentics.mesh.test.util.MeshAssert;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import java.lang.annotation.Annotation;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class AbstractMultiESTest
implements TestHttpMethods,
TestGraphHelper,
PluginHelper {
    private OkHttpClient httpClient;
    private static ElasticsearchTestMode currentMode;
    private EventAsserter eventAsserter;
    private static final MeshTestContext testContext;
    public static Runnable cleanupAction;
    public MeshTestSetting settings;

    @Parameterized.Parameters(name="{index}: ({0})")
    public static Collection esVersions() {
        return Arrays.asList({ElasticsearchTestMode.CONTAINER_ES6}, {ElasticsearchTestMode.CONTAINER_ES7});
    }

    public AbstractMultiESTest(ElasticsearchTestMode elasticsearch) throws Exception {
        if (currentMode != null && currentMode != elasticsearch) {
            this.getTestContext().tearDownOnce(this.settings);
        }
        MeshTestSetting clazzAnnotation = this.getClass().getAnnotation(MeshTestSetting.class);
        this.settings = new MeshTestSettingProxy(clazzAnnotation, elasticsearch);
        this.eventAsserter = new EventAsserter(testContext);
        if (currentMode == null || currentMode != elasticsearch) {
            this.getTestContext().setupOnce(this.settings);
        }
        currentMode = elasticsearch;
        cleanupAction = () -> {
            try {
                this.getTestContext().tearDownOnce(this.settings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
    }

    @Before
    public void setup() throws Throwable {
        this.getTestContext().setup(this.settings);
    }

    @After
    public void tearDown() throws Throwable {
        this.getTestContext().tearDown(this.settings);
    }

    @Override
    public MeshTestContext getTestContext() {
        return testContext;
    }

    @Override
    public OkHttpClient httpClient() {
        if (this.httpClient == null) {
            try {
                int timeout = MeshAssert.getTimeout();
                this.httpClient = new OkHttpClient.Builder().writeTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).connectTimeout((long)timeout, TimeUnit.SECONDS).build();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return this.httpClient;
    }

    @Override
    public EventAsserter eventAsserter() {
        return this.eventAsserter;
    }

    static {
        System.setProperty("vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        currentMode = null;
        testContext = new MeshTestContext();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (cleanupAction != null) {
                cleanupAction.run();
            }
        }));
    }

    public class MeshTestSettingProxy
    implements MeshTestSetting {
        private MeshTestSetting delegate;
        private ElasticsearchTestMode elasticsearch;

        public MeshTestSettingProxy(MeshTestSetting clazzAnnotation, ElasticsearchTestMode elasticsearch) {
            this.delegate = clazzAnnotation;
            this.elasticsearch = elasticsearch;
        }

        public Class<? extends Annotation> annotationType() {
            return this.delegate.annotationType();
        }

        public ElasticsearchTestMode elasticsearch() {
            return this.elasticsearch;
        }

        public AWSTestMode awsContainer() {
            return this.delegate.awsContainer();
        }

        public TestSize testSize() {
            return this.delegate.testSize();
        }

        public boolean startServer() {
            return this.delegate.startServer();
        }

        public boolean inMemoryDB() {
            return this.delegate.inMemoryDB();
        }

        public boolean startStorageServer() {
            return this.delegate.startStorageServer();
        }

        public boolean useKeycloak() {
            return this.delegate.useKeycloak();
        }

        public boolean clusterMode() {
            return this.delegate.clusterMode();
        }

        public SSLTestMode ssl() {
            return this.delegate.ssl();
        }

        public boolean monitoring() {
            return this.delegate.monitoring();
        }

        public MeshCoreOptionChanger optionChanger() {
            return this.delegate.optionChanger();
        }

        public Class<? extends MeshOptionChanger> customOptionChanger() {
            return this.delegate.customOptionChanger();
        }
    }
}

