/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.node.NodeListResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.search.AbstractMultiESTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.context.MeshTestHelper;
import com.gentics.mesh.util.IndexOptionHelper;
import com.gentics.mesh.util.Tuple;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;

public abstract class AbstractNodeSearchEndpointTest
extends AbstractMultiESTest {
    public AbstractNodeSearchEndpointTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    protected void searchWithLanguages(String ... expectedLanguages) throws Exception {
        this.recreateIndices();
        String uuid = (String)this.db().tx(() -> this.content("concorde").getUuid());
        NodeListResponse response = (NodeListResponse)ClientHelper.call(() -> this.client().searchNodes("dummy", MeshTestHelper.getSimpleQuery("fields.content", "concorde"), new ParameterProvider[]{new PagingParametersImpl().setPage(1L).setPerPage(Long.valueOf(100L)), new NodeParametersImpl().setLanguages(expectedLanguages), new VersioningParametersImpl().draft()}));
        Assert.assertEquals((String)"Check # of returned nodes", (long)expectedLanguages.length, (long)response.getData().size());
        Assert.assertEquals((String)"Check total count", (long)expectedLanguages.length, (long)response.getMetainfo().getTotalCount());
        HashSet<String> foundLanguages = new HashSet<String>();
        for (NodeResponse nodeResponse : response.getData()) {
            Assert.assertEquals((String)"Check uuid of found node", (Object)uuid, (Object)nodeResponse.getUuid());
            foundLanguages.add(nodeResponse.getLanguage());
        }
        HashSet<String> notFound = new HashSet<String>(Arrays.asList(expectedLanguages));
        notFound.removeAll(foundLanguages);
        Assert.assertTrue((String)("Did not find nodes in expected languages: " + notFound), (boolean)notFound.isEmpty());
        HashSet unexpected = new HashSet(foundLanguages);
        unexpected.removeAll(Arrays.asList(expectedLanguages));
        Assert.assertTrue((String)("Found nodes in unexpected languages: " + unexpected), (boolean)unexpected.isEmpty());
    }

    protected void addNumberSpeedFieldToOneNode(Number number) {
        HibNode node = (HibNode)this.tx(() -> this.content("concorde"));
        this.tx(() -> {
            SchemaVersionModel schema = ((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()).getSchema();
            schema.addField((FieldSchema)new NumberFieldSchemaImpl().setName("speed"));
            ((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()));
        });
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest request = response.toRequest();
        request.getFields().put("speed", (Field)new NumberFieldImpl().setNumber(number));
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), request, new ParameterProvider[0]));
    }

    protected void addMicronodeField() {
        HibNode node = (HibNode)this.tx(() -> {
            HibNode nodeTmp = this.content("concorde");
            SchemaVersionModel schema = ((HibSchemaVersion)nodeTmp.getSchemaContainer().getLatestVersion()).getSchema();
            MicronodeFieldSchemaImpl vcardFieldSchema = new MicronodeFieldSchemaImpl();
            vcardFieldSchema.setName("vcard");
            vcardFieldSchema.setAllowedMicroSchemas(new String[]{"vcard"});
            schema.addField((FieldSchema)vcardFieldSchema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)nodeTmp.getSchemaContainer().getLatestVersion()));
            return nodeTmp;
        });
        NodeUpdateRequest request = (NodeUpdateRequest)this.tx(() -> {
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[0]));
            NodeUpdateRequest requestTmp = response.toRequest();
            MicronodeResponse field = new MicronodeResponse();
            field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
            field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Mickey"));
            field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Mouse"));
            requestTmp.getFields().put("vcard", (Field)field);
            return requestTmp;
        });
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), request, new ParameterProvider[0]));
    }

    protected void addMicronodeListField() {
        HibNode node = (HibNode)this.tx(() -> this.content("concorde"));
        this.tx(() -> {
            SchemaVersionModel schema = ((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()).getSchema();
            ListFieldSchemaImpl vcardListFieldSchema = new ListFieldSchemaImpl();
            vcardListFieldSchema.setName("vcardlist");
            vcardListFieldSchema.setListType("micronode");
            vcardListFieldSchema.setAllowedSchemas(new String[]{"vcard"});
            schema.addField((FieldSchema)vcardListFieldSchema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()));
        });
        MicronodeFieldListImpl listField = new MicronodeFieldListImpl();
        for (Tuple testdata : Arrays.asList(Tuple.tuple((Object)"Mickey", (Object)"Mouse"), Tuple.tuple((Object)"Donald", (Object)"Duck"))) {
            MicronodeResponse field = new MicronodeResponse();
            field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
            field.getFields().put("firstName", (Field)new StringFieldImpl().setString((String)testdata.v1()));
            field.getFields().put("lastName", (Field)new StringFieldImpl().setString((String)testdata.v2()));
            listField.add((Object)field);
        }
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest request = response.toRequest();
        request.getFields().put("vcardlist", (Field)listField);
        request.setLanguage(this.english());
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), request, new ParameterProvider[0]));
        NodeUpdateRequest germanRequest = ((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"})}))).toRequest();
        germanRequest.getFields().put("vcardlist", (Field)new MicronodeFieldListImpl());
        germanRequest.setLanguage(this.german());
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), germanRequest, new ParameterProvider[0]));
    }

    protected void addNodeListField() {
        HibNode node = (HibNode)this.tx(() -> this.content("concorde"));
        this.tx(() -> {
            SchemaVersionModel schema = ((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()).getSchema();
            ListFieldSchemaImpl nodeListFieldSchema = new ListFieldSchemaImpl();
            nodeListFieldSchema.setName("nodelist");
            nodeListFieldSchema.setListType("node");
            nodeListFieldSchema.setAllowedSchemas(new String[]{schema.getName()});
            schema.addField((FieldSchema)nodeListFieldSchema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)this.content("concorde").getSchemaContainer().getLatestVersion()));
        });
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[0]));
        NodeUpdateRequest request = response.toRequest();
        NodeFieldListImpl fieldList = new NodeFieldListImpl();
        fieldList.add((Object)new NodeFieldListItemImpl().setUuid(node.getUuid()));
        request.getFields().put("nodelist", (Field)fieldList);
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), request, new ParameterProvider[0]));
        NodeUpdateRequest germanRequest = ((NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid(this.projectName(), node.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"de"})}))).toRequest();
        germanRequest.getFields().put("nodelist", (Field)new NodeFieldListImpl());
        ClientHelper.call(() -> this.client().updateNode(this.projectName(), node.getUuid(), germanRequest, new ParameterProvider[0]));
    }

    protected String getNestedVCardListSearch(String firstName, String lastName) throws IOException {
        JsonObject request = new JsonObject("{\"query\":{\"nested\":{\"path\":\"fields.vcardlist\",\"query\":{\"bool\":{\"must\":[{\"match\":{\"fields.vcardlist.fields-vcard.firstName\":\"Mickey\"}},{\"match\":{\"fields.vcardlist.fields-vcard.lastName\":\"Duck\"}}]}}}}}\n");
        JsonArray must = request.getJsonObject("query").getJsonObject("nested").getJsonObject("query").getJsonObject("bool").getJsonArray("must");
        must.getJsonObject(0).getJsonObject("match").put("fields.vcardlist.fields-vcard.firstName", (Object)firstName);
        must.getJsonObject(1).getJsonObject("match").put("fields.vcardlist.fields-vcard.lastName", (Object)lastName);
        return request.toString();
    }

    protected void addRawToSchemaField() {
        String schemaUuid = (String)this.tx(() -> this.content().getSchemaContainer().getUuid());
        SchemaUpdateRequest request = (SchemaUpdateRequest)this.tx(() -> (SchemaUpdateRequest)JsonUtil.readValue((String)((HibSchemaVersion)this.content().getSchemaContainer().getLatestVersion()).getJson(), SchemaUpdateRequest.class));
        request.getField("teaser").setElasticsearch(IndexOptionHelper.getRawFieldOption());
        this.grantAdmin();
        this.waitForJob(() -> ClientHelper.call(() -> this.client().updateSchema(schemaUuid, request, new ParameterProvider[0])));
        this.revokeAdmin();
    }
}

