/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.i18n.I18NUtil;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.core.rest.validation.SchemaValidationResponse;
import com.gentics.mesh.core.rest.validation.ValidationStatus;
import com.gentics.mesh.etc.config.search.ComplianceMode;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.SchemaUpdateParametersImpl;
import com.gentics.mesh.search.AbstractNodeSearchEndpointTest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.IndexOptionHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class CustomIndexSettingsTest
extends AbstractNodeSearchEndpointTest {
    private static final Logger log = LoggerFactory.getLogger(CustomIndexSettingsTest.class);
    static final String REGEX = "%ha%(.*?)%he%";
    static final Pattern HL_PATTERN = Pattern.compile("%ha%(.*?)%he%");

    public CustomIndexSettingsTest(ElasticsearchTestMode elasticsearch) throws Exception {
        super(elasticsearch);
    }

    @Test
    public void testValidationErrorOnCreate() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("settingsTest");
        request.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(new JsonObject().put("bogus", (Object)"value")));
        ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[]{new SchemaUpdateParametersImpl().setStrictValidation(true)}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"schema_error_index_validation", (String[])new String[]{"Failed to parse mapping [" + this.typeName() + "]: illegal field [bogus], only fields can be specified inside fields"});
    }

    @Test
    public void testValidationErrorOnUpdate() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("settingsTest");
        request.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        SchemaUpdateRequest updateRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)request.toJson(), SchemaUpdateRequest.class);
        updateRequest.removeField("text");
        updateRequest.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(new JsonObject().put("bogus", (Object)"value")));
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[]{new SchemaUpdateParametersImpl().setStrictValidation(true)}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"schema_error_index_validation", (String[])new String[]{"Failed to parse mapping [" + this.typeName() + "]: illegal field [bogus], only fields can be specified inside fields"});
    }

    @Test
    public void testSuccessfulValidation() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("settingsTest");
        request.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
    }

    @Test
    public void testSchemaDiff() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("settingsTest");
        request.setUrlFields(new String[]{"text"});
        request.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        SchemaUpdateRequest updateRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)request.toJson(), SchemaUpdateRequest.class);
        updateRequest.setElasticsearch(new JsonObject().put("number_of_shards", (Object)3));
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[0]));
        SchemaResponse response2 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(response.getUuid(), new ParameterProvider[0]));
        Assert.assertEquals((long)3L, (long)response2.getElasticsearch().getInteger("number_of_shards").intValue());
        Assert.assertNotEquals((String)"The schema should have been updated by the introduced change but it was not.", (Object)response.getVersion(), (Object)response2.getVersion());
        Assertions.assertThat((List)response2.getUrlFields()).containsOnly((Object[])new String[]{"text"});
        updateRequest.setElasticsearch(new JsonObject());
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[0]));
        SchemaResponse response3 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(response.getUuid(), new ParameterProvider[0]));
        Assert.assertTrue((String)"The options should be empty", (boolean)new JsonObject().equals((Object)response3.getElasticsearch()));
        Assert.assertNotEquals((String)"The schema should have been updated by the introduced change but it was not.", (Object)response2.getVersion(), (Object)response3.getVersion());
        Assertions.assertThat((List)response3.getUrlFields()).containsOnly((Object[])new String[]{"text"});
        updateRequest.setElasticsearch(null);
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[0]));
        SchemaResponse response4 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(response.getUuid(), new ParameterProvider[0]));
        Assertions.assertThat((List)response4.getUrlFields()).containsOnly((Object[])new String[]{"text"});
    }

    @Test
    public void testSchemaFieldDiff() {
        SchemaCreateRequest request = new SchemaCreateRequest();
        request.setName("settingsTest");
        request.setUrlFields(new String[]{"text"});
        request.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(IndexOptionHelper.getRawFieldOption()));
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(request, new ParameterProvider[0]));
        SchemaUpdateRequest updateRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)request.toJson(), SchemaUpdateRequest.class);
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[0]));
        SchemaResponse response2 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(response.getUuid(), new ParameterProvider[0]));
        Assert.assertEquals((String)"No new version should have been created.", (Object)response.getVersion(), (Object)response2.getVersion());
        updateRequest.getField("text").setElasticsearch(new JsonObject());
        ClientHelper.call(() -> this.client().updateSchema(response.getUuid(), updateRequest, new ParameterProvider[0]));
        SchemaResponse response3 = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(response.getUuid(), new ParameterProvider[0]));
        Assert.assertNotEquals((String)"The schema should have been updated by the introduced change but it was not.", (Object)response.getVersion(), (Object)response3.getVersion());
    }

    @Test
    public void testSchemaValidationError() {
        SchemaCreateRequest schema = new SchemaCreateRequest();
        schema.setName("settingsTest");
        schema.addField(FieldUtil.createStringFieldSchema((String)"text").setElasticsearch(new JsonObject().put("bogus", (Object)"value")));
        SchemaValidationResponse response = (SchemaValidationResponse)ClientHelper.call(() -> this.client().validateSchema((SchemaModel)schema));
        Assert.assertNotNull((Object)response.getElasticsearch());
        Assert.assertEquals((Object)ValidationStatus.INVALID, (Object)response.getStatus());
        String message = I18NUtil.get((Locale)Locale.ENGLISH, (String)"schema_error_index_validation", (String[])new String[]{"Failed to parse mapping [" + this.typeName() + "]: illegal field [bogus], only fields can be specified inside fields"});
        Assert.assertEquals((Object)message, (Object)response.getMessage().getMessage());
        Assert.assertEquals((Object)"schema_error_index_validation", (Object)response.getMessage().getInternalMessage());
    }

    @Test
    public void testCustomAnalyzerAndQuery() throws Exception {
        this.grantAdmin();
        this.recreateIndices();
        SchemaCreateRequest schema = new SchemaCreateRequest();
        schema.setName("customIndexTest");
        JsonObject elasticsearchSettings = this.getJson("/elasticsearch/custom/suggestionSettings.json");
        schema.setElasticsearch(elasticsearchSettings);
        JsonObject fieldSettings = this.getJson("/elasticsearch/custom/suggestionFieldMapping.json");
        schema.addField(FieldUtil.createStringFieldSchema((String)"content").setElasticsearch(fieldSettings));
        SchemaValidationResponse validationResponse = (SchemaValidationResponse)ClientHelper.call(() -> this.client().validateSchema((SchemaModel)schema));
        Assert.assertEquals((Object)ValidationStatus.VALID, (Object)validationResponse.getStatus());
        SchemaResponse response = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schema, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", response.getUuid()));
        HashSet<CallSite> contents = new HashSet<CallSite>();
        String prefix = "One this is<pre>another set of <strong>important</strong>content ";
        contents.add((CallSite)((Object)(prefix + "no text with more content you can poke a stick at")));
        contents.add((CallSite)((Object)(prefix + "s<b>om</b>e text with more content test you can poke content the a convert stick at")));
        contents.add((CallSite)((Object)(prefix + "some <strong>more</strong> content text you content this Content thAmbalaru can poke a content Telefon connection stick at too")));
        contents.add((CallSite)((Object)(prefix + "someth<strong>ing</strong> context completely conTent save different")));
        contents.add((CallSite)((Object)(prefix + "some<strong>what</strong> strange content")));
        for (String string : contents) {
            NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
            nodeCreateRequest.setParentNodeUuid((String)this.tx(() -> this.project().getBaseNode().getUuid()));
            nodeCreateRequest.setLanguage("en");
            nodeCreateRequest.setSchemaName("customIndexTest");
            nodeCreateRequest.getFields().put("content", (Field)FieldUtil.createStringField((String)string));
            ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
        }
        this.waitForSearchIdleEvent();
        String searchQuery = this.getText("/elasticsearch/custom/customSearchQuery.es");
        JsonObject jsonObject = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchNodesRaw("dummy", searchQuery, new ParameterProvider[0]))).toString());
        System.out.println(jsonObject.encodePrettily());
        String query = "Content t";
        JsonObject autocompleteQuery = new JsonObject(this.getText("/elasticsearch/custom/autocompleteQuery.es"));
        autocompleteQuery.getJsonObject("query").getJsonObject("match").getJsonObject("fields.content.auto").put("query", (Object)query);
        JsonObject autocompleteResult = new JsonObject(((ObjectNode)ClientHelper.call(() -> this.client().searchNodesRaw("dummy", autocompleteQuery.encodePrettily(), new ParameterProvider[0]))).toString());
        System.out.println(autocompleteResult.encodePrettily());
        System.out.println("------------------------------");
        System.out.println(new JsonObject(this.parseResult(autocompleteResult, query)).encodePrettily());
    }

    private Map<String, Object> parseResult(JsonObject result, String query) {
        List<String> partials = Arrays.asList(query.split(" "));
        HashMap<String, Object> map = new HashMap<String, Object>();
        JsonArray hits = result.getJsonArray("responses").getJsonObject(0).getJsonObject("hits").getJsonArray("hits");
        for (int i = 0; i < hits.size(); ++i) {
            JsonObject hit = hits.getJsonObject(i);
            JsonArray highlights = hit.getJsonObject("highlight").getJsonArray("fields.content.auto");
            HashSet<String> foundTokens = new HashSet<String>();
            for (int e = 0; e < highlights.size(); ++e) {
                String firstHighlight = highlights.getString(e);
                firstHighlight = firstHighlight.replaceAll("<[^>]+>", "");
                Matcher matcher = HL_PATTERN.matcher(firstHighlight);
                while (matcher.find()) {
                    String part = matcher.group(1);
                    foundTokens.add(part);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found tokens: " + foundTokens));
            }
            this.constructOptions(map, foundTokens, partials);
        }
        return map;
    }

    private void constructOptions(Map<String, Object> map, Set<String> foundTokens, List<String> partials) {
        StringBuffer baseBuffer = new StringBuffer();
        String lastUnknownPartial = null;
        for (String partial : partials) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking found tokens against partial {" + partial + "}"));
            }
            if (foundTokens.stream().map(e -> e.toLowerCase()).collect(Collectors.toSet()).contains(partial.toLowerCase())) {
                baseBuffer.append(partial);
                foundTokens.remove(partial);
                continue;
            }
            lastUnknownPartial = partial;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using last partial {" + lastUnknownPartial + "}"));
        }
        String baseString = baseBuffer.toString();
        for (String tokenOption : foundTokens) {
            if (tokenOption.toLowerCase().startsWith(lastUnknownPartial.toLowerCase())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found token {" + tokenOption + "} which starts with the given last partial {" + lastUnknownPartial + "}"));
                }
                StringBuffer optionBuffer = new StringBuffer();
                optionBuffer.append(baseString);
                if (!baseString.isEmpty()) {
                    optionBuffer.append(" ");
                }
                optionBuffer.append(tokenOption);
                map.put(optionBuffer.toString(), optionBuffer.toString());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Rejecting token {" + tokenOption + "} since it does not match up with the last partial {" + lastUnknownPartial + "}"));
        }
    }

    @Test
    public void testSchemaValidationSuccess() {
        SchemaCreateRequest schema = new SchemaCreateRequest();
        schema.setName("settingsTest");
        SchemaValidationResponse response = (SchemaValidationResponse)ClientHelper.call(() -> this.client().validateSchema((SchemaModel)schema));
        Assert.assertNotNull((Object)response.getElasticsearch());
        Assert.assertEquals((Object)ValidationStatus.VALID, (Object)response.getStatus());
    }

    @Test
    public void testMicroschemaValidationError() {
        MicroschemaCreateRequest microschema = new MicroschemaCreateRequest();
        ClientHelper.call(() -> this.client().validateMicroschema((MicroschemaModel)microschema), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"schema_error_no_name", (String[])new String[0]);
    }

    @Test
    public void testMicroschemaValidationSucess() {
        MicroschemaCreateRequest microschema = new MicroschemaCreateRequest();
        microschema.setName("someName");
        ClientHelper.call(() -> this.client().validateMicroschema((MicroschemaModel)microschema));
    }

    private String typeName() {
        String name = "default";
        if (this.complianceMode() == ComplianceMode.ES_7) {
            name = "_doc";
        }
        return name;
    }
}

