/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.data.search.index.IndexInfo;
import com.gentics.mesh.search.impl.ElasticSearchProvider;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class ElasticSearchProviderTest
extends AbstractMeshTest {
    @Test
    public void testProvider() throws IOException {
        ElasticSearchProvider provider = this.getProvider();
        provider.createIndex(new IndexInfo("test", new JsonObject(), new JsonObject(), "testSchema")).blockingAwait();
        String uuid = UUIDUtil.randomUUID();
        provider.updateDocument("test", uuid, new JsonObject(), true).blockingAwait();
        provider.deleteDocument("test", uuid).blockingAwait();
        provider.deleteDocument("test", uuid).blockingAwait();
        provider.deleteIndex(new String[]{"testindex"}).blockingAwait();
        provider.createIndex(new IndexInfo("testindex", new JsonObject(), new JsonObject(), "testSchema")).blockingAwait();
        provider.createIndex(new IndexInfo("testindex", new JsonObject(), new JsonObject(), "testSchema")).blockingAwait();
        provider.deleteIndex(new String[]{"testindex"}).blockingAwait();
    }

    @Test
    public void testVersion() {
        ElasticSearchProvider provider = this.getProvider();
        Assert.assertEquals((Object)"6.8.1", (Object)provider.getVersion(true));
    }

    @Test
    public void testPrefixHandling() {
        Assert.assertEquals((Object)"mesh-", (Object)this.getProvider().installationPrefix());
        String fullIndex = "mesh-node-blar";
        Assert.assertEquals((Object)"node-blar", (Object)this.getProvider().removePrefix(fullIndex));
    }

    @Test
    public void testIndexSegmentation() {
        ElasticSearchProvider provider = this.getProvider();
        ArrayList<String> indices = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            StringBuilder builder = new StringBuilder();
            builder.append("mesh-test");
            for (int e = 0; e < 4; ++e) {
                builder.append(UUIDUtil.randomUUID());
            }
            String name = builder.toString();
            indices.add(name);
            provider.createIndex(new IndexInfo(name, new JsonObject(), new JsonObject(), "testSchema")).blockingAwait();
        }
        String[] names = (String[])indices.stream().toArray(String[]::new);
        provider.refreshIndex(names).blockingAwait();
        provider.refreshIndex(names).blockingAwait();
        provider.clear().blockingAwait();
        provider.clear().blockingAwait();
    }

    @Test
    public void testConcurrencyConflictError() {
        ElasticSearchProvider provider = this.getProvider();
        provider.createIndex(new IndexInfo("test", new JsonObject(), new JsonObject(), "testSchema")).blockingAwait();
        provider.storeDocument("test", "1", new JsonObject().put("value", (Object)0)).blockingAwait();
        Observable.range((int)1, (int)2000).flatMapCompletable(i -> provider.updateDocument("test", "1", new JsonObject().put("value", i), false)).blockingAwait();
    }

    private JsonObject getPipelineConfig(List<String> fields) {
        JsonObject config = new JsonObject();
        config.put("description", (Object)"Extract attachment information");
        JsonArray processors = new JsonArray();
        for (String field : fields) {
            JsonObject processor = new JsonObject();
            JsonObject settings = new JsonObject();
            settings.put("field", (Object)field);
            settings.put("target_field", (Object)("field." + field));
            settings.put("ignore_missing", (Object)true);
            processor.put("attachment", (Object)settings);
            processors.add((Object)processor);
        }
        config.put("processors", (Object)processors);
        return config;
    }
}

