/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.search;

import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.etc.config.search.ElasticSearchOptions;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServer;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FailingTests.class})
@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.PROJECT_AND_NODE, startServer=true, optionChanger=MeshCoreOptionChanger.RANDOM_ES_PORT)
public class ElasticSearchProviderTimeoutTest
extends AbstractMeshTest {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchProviderTimeoutTest.class);

    @BeforeClass
    public static void setupTimeoutServer() throws IOException {
        Vertx vertx = new Vertx(testContext.getVertx());
        ElasticSearchOptions options = testContext.getOptions().getSearchOptions();
        String url = options.getUrl();
        int port = new URL(url).getPort();
        HttpServer server = vertx.createHttpServer(new HttpServerOptions().setPort(port));
        server.requestHandler(rh -> {
            if (rh.absoluteURI().indexOf("_template/validation") > 0) {
                rh.response().end(new JsonObject().encodePrettily());
            } else {
                log.info((Object)("Waiting for 16 second to answer request: " + rh.absoluteURI()));
                vertx.setTimer(Duration.ofSeconds(3L).toMillis(), th -> rh.response().end());
            }
        });
        server.rxListen().blockingGet();
    }

    @Test
    public void testDocumentCreation() throws IOException {
        String username = "testuser42a";
        try (Tx tx = this.tx();){
            this.createUser(username);
        }
    }

    @Test
    public void testSearchQuery() throws IOException {
        String json = this.getESText("userWildcard.es");
        ClientHelper.call(() -> this.client().searchUsers(json, new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)"search_error_timeout", (String[])new String[0]);
    }
}

